/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.internal;

import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.internal.InternalConfigurationController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AppConfiguration {
    private final String applicationIdField = "X-LC-Id";
    private final String apiKeyField = "X-LC-Key";
    String applicationId;
    String clientKey;
    protected StorageType storageType = StorageType.StorageTypeQiniu;
    protected static Map<String, String> serviceHostMap = Collections.synchronizedMap(new HashMap());

    public void setStorageType(StorageType type) {
        this.storageType = type;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String getService(String service) {
        return AVUtils.isBlankString(serviceHostMap.get(service)) ? serviceHostMap.get(AVOSServices.STORAGE_SERVICE.toString()) : serviceHostMap.get(service);
    }

    public void configureService(String service, String host) {
        serviceHostMap.put(service, host);
    }

    public abstract boolean isConfigured();

    public abstract void setupThreadPoolExecutor(ThreadPoolExecutor var1);

    public abstract boolean isConnected();

    protected abstract void setEnv();

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("X-LC-Id", this.applicationId);
        return result;
    }

    public String dumpRequestHeaders() {
        return String.format("-H \"%s: %s\" -H \"%s: %s\"", "X-LC-Id", this.applicationId, "X-LC-Key", this.dumpKey(this.clientKey, "YourAppKey"));
    }

    protected String dumpKey(String key, String mask) {
        return InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog() ? key : mask;
    }

    public static enum StorageType {
        StorageTypeQiniu,
        StorageTypeAV,
        StorageTypeS3;

    }
}

