/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.okhttp.Call;
import com.avos.avoscloud.okhttp.MediaType;
import com.avos.avoscloud.okhttp.OkHttpClient;
import com.avos.avoscloud.okhttp.Request;
import com.avos.avoscloud.okhttp.RequestBody;
import com.avos.avoscloud.okhttp.Response;
import java.nio.charset.Charset;

public class S3Uploader
extends HttpClientUploader {
    private volatile Call call;
    private String uploadUrl;
    private AVFile parseFile;

    S3Uploader(AVFile parseFile, String uploadUrl, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(saveCallback, progressCallback);
        this.uploadUrl = uploadUrl;
        this.parseFile = parseFile;
    }

    @Override
    public AVException doWork() {
        OkHttpClient httpClient = S3Uploader.getOKHttpClient();
        Response response = null;
        String serverResponse = null;
        try {
            byte[] bytes = this.parseFile.getData();
            Request.Builder builder = new Request.Builder();
            builder.url(this.uploadUrl);
            Charset charset = Charset.forName("UTF-8");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.parseFile.mimeType()), (byte[])bytes);
            builder.put(requestBody);
            builder.addHeader("Content-Type", this.parseFile.mimeType());
            this.call = httpClient.newCall(builder.build());
            response = this.call.execute();
            if (2 != response.code() / 100) {
                serverResponse = AVUtils.stringFromBytes(response.body().bytes());
                LogUtil.avlog.e(serverResponse);
                return AVErrorUtils.createException(-1, "upload file failure:" + response.code());
            }
        }
        catch (Exception e) {
            return new AVException(e.getCause());
        }
        return null;
    }
}

