/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AsyncHttpResponseHandler;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.internal.framed.Header;

public class PostHttpResponseHandler
extends AsyncHttpResponseHandler {
    PostHttpResponseHandler(GenericObjectCallback cb) {
        super(cb);
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, byte[] body) {
        String contentType;
        String content = AVUtils.stringFromBytes(body);
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.avlog.d(content);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = AVUtils.extractContentType(headers), this.getCallback())) {
            return;
        }
        int code = AVErrorUtils.errorCode(content);
        if (code > 0) {
            if (this.getCallback() != null) {
                this.getCallback().onFailure(AVErrorUtils.createException(content), content);
            }
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onSuccess(content, null);
        }
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        String contentType;
        String content = AVUtils.stringFromBytes(responseBody);
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.avlog.e(content + "\nerror:" + error);
        }
        if (AVUtils.checkResponseType(statusCode, content, contentType = AVUtils.extractContentType(headers), this.getCallback())) {
            return;
        }
        if (this.getCallback() != null) {
            this.getCallback().onFailure(statusCode, error, content);
        }
    }
}

