/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVObjectReferenceCount;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AsyncHttpResponseHandler;
import com.avos.avoscloud.DNSAmendNetwork;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PostHttpResponseHandler;
import com.avos.avoscloud.internal.InternalCache;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.Call;
import com.avos.avoscloud.okhttp.Callback;
import com.avos.avoscloud.okhttp.Dns;
import com.avos.avoscloud.okhttp.Interceptor;
import com.avos.avoscloud.okhttp.MediaType;
import com.avos.avoscloud.okhttp.OkHttpClient;
import com.avos.avoscloud.okhttp.Request;
import com.avos.avoscloud.okhttp.RequestBody;
import com.avos.avoscloud.okhttp.Response;
import com.avos.avoscloud.okhttp.ResponseBody;
import com.avos.avoscloud.okhttp.internal.framed.Header;
import com.avos.avoscloud.okio.Buffer;
import com.avos.avoscloud.okio.BufferedSource;
import com.avos.avoscloud.okio.ForwardingSource;
import com.avos.avoscloud.okio.Okio;
import com.avos.avoscloud.okio.Source;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class PaasClient {
    private static final CookieHandler cookieHandler = new CookieHandler(){

        @Override
        public Map<String, List<String>> get(URI uri, Map<String, List<String>> map) throws IOException {
            return Collections.emptyMap();
        }

        @Override
        public void put(URI uri, Map<String, List<String>> map) throws IOException {
        }
    };
    private final String apiVersion;
    protected static String sessionTokenField = "X-LC-Session";
    private static boolean isCN = true;
    private boolean isProduction = true;
    private static final String defaultEncoding = "UTF-8";
    public static final String defaultContentType = "application/json";
    public static final String DEFAULT_FAIL_STRING = "request failed!!!";
    private AVACL defaultACL;
    private volatile AVHttpClient httpClient;
    private static boolean lastModifyEnabled = false;
    private static String REQUEST_STATIS_HEADER = "X-Android-RS";
    private String baseUrl;
    static Map<String, PaasClient> serviceClientMap = new HashMap<String, PaasClient>();
    static Map<String, AVObjectReferenceCount> internalObjectsForEventuallySave = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> lastModify = Collections.synchronizedMap(new WeakHashMap());
    private static Comparator<File> fileModifiedDateComparator = new Comparator<File>(){

        @Override
        public int compare(File f, File s) {
            return (int)(f.lastModified() - s.lastModified());
        }
    };

    void setProduction(boolean production) {
        this.isProduction = production;
    }

    protected static PaasClient sharedInstance(AVOSServices service) {
        String host = InternalConfigurationController.globalInstance().getAppConfiguration().getService(service.toString());
        PaasClient instance = serviceClientMap.get(host);
        if (instance == null) {
            instance = new PaasClient();
            instance.setBaseUrl(host);
            serviceClientMap.put(host, instance);
        }
        return instance;
    }

    public static PaasClient storageInstance() {
        return PaasClient.sharedInstance(AVOSServices.STORAGE_SERVICE);
    }

    public static PaasClient cloudInstance() {
        return PaasClient.sharedInstance(AVOSServices.FUNCTION_SERVICE);
    }

    public static PaasClient statistisInstance() {
        return PaasClient.sharedInstance(AVOSServices.STATISTICS_SERVICE);
    }

    AVACL getDefaultACL() {
        return this.defaultACL;
    }

    void setDefaultACL(AVACL acl) {
        this.defaultACL = acl;
    }

    public Map<String, String> userHeaderMap() {
        AVUser user = AVUser.getCurrentUser();
        if (user != null) {
            return user.headerMap();
        }
        return null;
    }

    private PaasClient() {
        this.apiVersion = "1.1";
        this.useUruluServer();
    }

    protected void updateHeaders(Request.Builder builder, Map<String, String> header, boolean needRequestStatistic) throws AVException {
        if (!InternalConfigurationController.globalInstance().getAppConfiguration().isConfigured()) {
            throw new AVException(109, "You must call AVOSCloud.initialize before using the AVOSCloud library");
        }
        builder.header("X-LC-Prod", this.isProduction ? "1" : "0");
        AVUser currAVUser = AVUser.getCurrentUser();
        builder.header(sessionTokenField, currAVUser != null && currAVUser.getSessionToken() != null ? currAVUser.getSessionToken() : "");
        builder.header("Accept", defaultContentType);
        builder.header("Content-Type", defaultContentType);
        builder.header("User-Agent", InternalConfigurationController.globalInstance().getClientConfiguration().getUserAgent());
        builder.header("X-LC-Sign", InternalConfigurationController.globalInstance().getInternalRequestSign().requestSign());
        for (Map.Entry<String, String> entry : InternalConfigurationController.globalInstance().getAppConfiguration().getRequestHeaders().entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        if (needRequestStatistic) {
            builder.header(REQUEST_STATIS_HEADER, "1");
        }
    }

    public synchronized AVHttpClient clientInstance() {
        if (this.httpClient == null) {
            this.httpClient = new AVHttpClient();
        }
        this.httpClient.setConnectTimeout(InternalConfigurationController.globalInstance().getClientConfiguration().getNetworkTimeoutInMills(), TimeUnit.MILLISECONDS);
        return this.httpClient;
    }

    public void useUruluServer() {
        if (isCN) {
            PaasClient.useAVCloudCN();
        } else {
            PaasClient.useAVCloudUS();
        }
    }

    public static void useAVCloudUS() {
        isCN = false;
    }

    protected static void updateAPIServer(String apiServer) {
        if (isCN) {
            InternalConfigurationController.globalInstance().getAppConfiguration().configureService(AVOSServices.STORAGE_SERVICE.toString(), apiServer);
        } else {
            InternalConfigurationController.globalInstance().getAppConfiguration().configureService(AVOSServices.STORAGE_SERVICE.toString(), "https://us-api.leancloud.cn");
        }
    }

    public static void useAVCloudCN() {
        isCN = true;
    }

    protected static void useLocalStg() {
        InternalConfigurationController.globalInstance().getAppConfiguration().configureService(AVOSServices.STORAGE_SERVICE.toString(), "https://cn-stg1.avoscloud.com");
    }

    public String buildUrl(String path) {
        return String.format("%s/%s/%s", this.baseUrl, this.apiVersion, path);
    }

    public String buildUrl(String path, AVRequestParams params) {
        String endPoint = this.buildUrl(path);
        if (params == null || params.isEmpty()) {
            return endPoint;
        }
        return params.getWholeUrl(endPoint);
    }

    private String batchUrl() {
        return String.format("%s/%s/batch", this.baseUrl, this.apiVersion);
    }

    private String batchSaveRelativeUrl() {
        return "batch/save";
    }

    private AsyncHttpResponseHandler createGetHandler(GenericObjectCallback callback, AVQuery.CachePolicy policy, String absoluteURLString) {
        GetHttpResponseHandler handler = new GetHttpResponseHandler(callback, policy, absoluteURLString);
        return handler;
    }

    private AsyncHttpResponseHandler createPostHandler(GenericObjectCallback callback) {
        PostHttpResponseHandler handler = new PostHttpResponseHandler(callback);
        return handler;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    protected void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected static void setServiceHost(AVOSServices service, String host) {
        InternalConfigurationController.globalInstance().getAppConfiguration().configureService(service.toString(), host);
    }

    public String getObject(final String relativePath, final AVRequestParams parameters, final boolean sync, final Map<String, String> header, final GenericObjectCallback callback, final AVQuery.CachePolicy policy, final long maxAgeInMilliseconds) {
        String absoluteURLString = this.buildUrl(relativePath, parameters);
        final String absolutURLString = this.generateQueryPath(relativePath, parameters);
        final String lastModifyTime = PaasClient.getLastModify(absolutURLString);
        switch (policy) {
            default: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ONLY: {
                InternalConfigurationController.globalInstance().getCache().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, callback);
                break;
            }
            case NETWORK_ONLY: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ELSE_NETWORK: {
                InternalConfigurationController.globalInstance().getCache().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                this.getObject(relativePath, parameters, sync, header, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        InternalCache cacheManager = InternalConfigurationController.globalInstance().getCache();
                        if (cacheManager.hasValidCache(absolutURLString, lastModifyTime, maxAgeInMilliseconds)) {
                            cacheManager.get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, callback);
                        } else {
                            callback.onFailure(error, content);
                        }
                    }
                }, policy);
                break;
            }
            case CACHE_THEN_NETWORK: {
                InternalConfigurationController.globalInstance().getCache().get(absolutURLString, maxAgeInMilliseconds, lastModifyTime, new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        callback.onFailure(error, content);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
            }
        }
        return absoluteURLString;
    }

    String generateQueryPath(String relativePath, AVRequestParams parameters) {
        return this.buildUrl(relativePath, parameters);
    }

    public void getObject(String relativePath, AVRequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy) {
        this.getObject(relativePath, parameters, sync, inputHeader, callback, policy, !policy.equals((Object)AVQuery.CachePolicy.CACHE_ONLY) && PaasClient.isLastModifyEnabled());
    }

    public void getObject(String relativePath, AVRequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy, boolean fetchRetry) {
        Map<String, String> myHeader = inputHeader;
        if (inputHeader == null) {
            myHeader = new HashMap<String, String>();
        }
        this.updateHeaderForPath(relativePath, parameters, myHeader);
        String url = this.buildUrl(relativePath, parameters);
        AsyncHttpResponseHandler handler = this.createGetHandler(callback, policy, url);
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            this.dumpHttpGetRequest(this.buildUrl(relativePath), parameters == null ? null : parameters.getDumpQueryString());
        }
        AVHttpClient client = this.clientInstance();
        Request.Builder builder = new Request.Builder();
        builder.url(url).get();
        try {
            this.updateHeaders(builder, myHeader, callback != null && callback.isRequestStatisticNeed());
        }
        catch (AVException e) {
            this.processException(e, callback);
        }
        client.execute(builder.build(), sync, handler);
    }

    public void getObject(String relativePath, AVRequestParams parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        this.getObject(relativePath, parameters, sync, header, callback, AVQuery.CachePolicy.IGNORE_CACHE);
    }

    public void putObject(String relativePath, String object, boolean sync, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        this.putObject(relativePath, object, sync, false, header, callback, objectId, _internalId);
    }

    public void putObject(String relativePath, String object, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("put", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                    this.dumpHttpPutRequest(header, url, object);
                }
                AVHttpClient client = this.clientInstance();
                Request.Builder builder = new Request.Builder();
                builder.url(url).put(RequestBody.create((MediaType)AVHttpClient.JSON, (String)object));
                this.updateHeaders(builder, header, callback != null && callback.isRequestStatisticNeed());
                client.execute(builder.build(), sync, handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    private void processException(Exception e, GenericObjectCallback cb) {
        if (cb != null) {
            cb.onFailure(e, null);
        }
    }

    Map<String, Object> batchItemMap(String method, String path, Object body, Map params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("method", method);
        result.put("path", path);
        result.put("body", body);
        if (params != null) {
            result.put("params", params);
        }
        return result;
    }

    Map<String, Object> batchItemMap(String method, String path, Object body) {
        return this.batchItemMap(method, path, body, null);
    }

    @Deprecated
    List<Object> assembleBatchOpsList(List<Object> itemList, String path) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : itemList) {
            Map<String, Object> opDict = this.batchItemMap("PUT", path, object);
            list.add(opDict);
        }
        return list;
    }

    private Map<String, Object> batchRequest(List<Object> list) {
        HashMap<String, Object> requests = new HashMap<String, Object>();
        requests.put("requests", list);
        return requests;
    }

    public void postBatchObject(List<Object> parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        try {
            String url = this.batchUrl();
            Map<String, Object> requests = this.batchRequest(parameters);
            String json = JSON.toJSONString(requests);
            if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                this.dumpHttpPostRequest(header, url, json);
            }
            AsyncHttpResponseHandler handler = this.createPostHandler(callback);
            AVHttpClient client = this.clientInstance();
            Request.Builder builder = new Request.Builder();
            builder.url(url).post(RequestBody.create((MediaType)AVHttpClient.JSON, (String)json));
            this.updateHeaders(builder, header, callback != null && callback.isRequestStatisticNeed());
            client.execute(builder.build(), sync, handler);
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postBatchSave(List list, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("requests", list);
            String paramString = AVUtils.jsonStringFromMapWithNull(params);
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", this.batchSaveRelativeUrl(), paramString, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(this.batchSaveRelativeUrl());
                if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                    this.dumpHttpPostRequest(header, url, paramString);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                AVHttpClient client = this.clientInstance();
                Request.Builder builder = new Request.Builder();
                builder.url(url).post(RequestBody.create((MediaType)AVHttpClient.JSON, (String)paramString));
                this.updateHeaders(builder, header, callback != null && callback.isRequestStatisticNeed());
                client.execute(builder.build(), sync, handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postObject(String relativePath, String object, boolean sync, GenericObjectCallback callback) {
        this.postObject(relativePath, object, sync, false, callback, null, null);
    }

    public void postObject(String relativePath, String object, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                    this.dumpHttpPostRequest(null, url, object);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                AVHttpClient client = this.clientInstance();
                Request.Builder builder = new Request.Builder();
                this.updateHeaders(builder, null, callback != null && callback.isRequestStatisticNeed());
                builder.url(url).post(RequestBody.create((MediaType)AVHttpClient.JSON, (String)object));
                client.execute(builder.build(), sync, handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void deleteObject(String relativePath, boolean sync, GenericObjectCallback callback, String objectId, String _internalId) {
        Map<String, Object> emptymap = Collections.emptyMap();
        this.deleteObject(relativePath, emptymap, sync, false, callback, objectId, _internalId);
    }

    public void deleteObject(String relativePath, Map<String, Object> object, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("delete", relativePath, null, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                String body = AVUtils.jsonStringFromMapWithNull(object);
                if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                    this.dumpHttpDeleteRequest(null, url, body);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                AVHttpClient client = this.clientInstance();
                Request.Builder builder = new Request.Builder();
                this.updateHeaders(builder, null, callback != null && callback.isRequestStatisticNeed());
                builder.url(url).delete(RequestBody.create((MediaType)AVHttpClient.JSON, (String)body));
                client.execute(builder.build(), sync, handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    private File archiveRequest(String method, String relativePath, String paramString, String objectId, String _internalId) {
        File theArchivedFile = new File(InternalConfigurationController.globalInstance().getInternalPersistence().getCommandCacheDir(), AVUtils.getArchiveRequestFileName(objectId, _internalId, method, relativePath, paramString));
        HashMap<String, String> fileMap = new HashMap<String, String>(3);
        fileMap.put("method", method);
        fileMap.put("relativePath", relativePath);
        fileMap.put("paramString", paramString);
        fileMap.put("objectId", objectId);
        fileMap.put("_internalId", _internalId);
        InternalConfigurationController.globalInstance().getInternalPersistence().saveContentToFile(AVUtils.toJSON(fileMap), theArchivedFile);
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            LogUtil.log.d(AVUtils.restfulServerData(fileMap) + "\ndid save to " + theArchivedFile.getAbsolutePath());
        }
        return theArchivedFile;
    }

    private void handleArchivedRequest(File archivedFile, boolean sync) {
        this.handleArchivedRequest(archivedFile, sync, null);
    }

    private void handleArchivedRequest(final File archivedFile, boolean sync, final GenericObjectCallback callback) {
        try {
            String archivedFileContent = InternalConfigurationController.globalInstance().getInternalPersistence().readContentFromFile(archivedFile);
            Map fileMap = null;
            fileMap = AVUtils.getFromJSON(archivedFileContent, Map.class);
            if (fileMap != null && !fileMap.isEmpty()) {
                String method = (String)fileMap.get("method");
                String relativePath = (String)fileMap.get("relativePath");
                String paramString = (String)fileMap.get("paramString");
                String objectId = (String)fileMap.get("objectId");
                String _internalId = (String)fileMap.get("_internalId");
                GenericObjectCallback newCallback = new GenericObjectCallback(){

                    @Override
                    public void onSuccess(String content, AVException e) {
                        if (callback != null) {
                            callback.onSuccess(content, e);
                        }
                        try {
                            Map objectMap = AVUtils.getFromJSON(content, Map.class);
                            for (String _internalId : objectMap.keySet()) {
                                if (internalObjectsForEventuallySave.get(_internalId) == null) continue;
                                internalObjectsForEventuallySave.get(_internalId).getValue().copyFromMap(objectMap);
                                PaasClient.unregisterEvtuallyObject(internalObjectsForEventuallySave.get(_internalId).getValue());
                            }
                        }
                        catch (Exception e1) {
                            LogUtil.avlog.e("parse exception during archive request" + e.getMessage());
                        }
                        InternalConfigurationController.globalInstance().getInternalPersistence().deleteFile(archivedFile);
                    }

                    @Override
                    public void onFailure(Throwable error, String content) {
                        if (callback != null) {
                            callback.onFailure(error, content);
                        }
                    }
                };
                if (method == null) {
                    newCallback.onFailure(new AVRuntimeException("Null method."), null);
                }
                if ("post".equalsIgnoreCase(method)) {
                    this.postObject(relativePath, paramString, sync, newCallback);
                } else if ("put".equalsIgnoreCase(method)) {
                    this.putObject(relativePath, paramString, sync, null, newCallback, objectId, _internalId);
                } else if ("delete".equalsIgnoreCase(method)) {
                    this.deleteObject(relativePath, sync, newCallback, objectId, _internalId);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void handleAllArchivedRequest() {
        this.handleAllArchivedRequest(false);
    }

    protected void handleAllArchivedRequest(boolean sync) {
        File commandCacheDir = InternalConfigurationController.globalInstance().getInternalPersistence().getCommandCacheDir();
        File[] archivedRequests = commandCacheDir.listFiles();
        if (archivedRequests != null && archivedRequests.length > 0) {
            Arrays.sort(archivedRequests, fileModifiedDateComparator);
            for (File file : archivedRequests) {
                if (file.isFile()) {
                    this.handleArchivedRequest(file, sync);
                    continue;
                }
                if (!InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog()) continue;
                LogUtil.avlog.e(file.getAbsolutePath() + " is a dir");
            }
        }
    }

    public void dumpHttpGetRequest(String path, String parameters) {
        String string = "";
        string = parameters != null ? String.format("curl -X GET %s -G --data-urlencode '%s' %s", InternalConfigurationController.globalInstance().getAppConfiguration().dumpRequestHeaders(), parameters, path) : String.format("curl -X GET %s %s", InternalConfigurationController.globalInstance().getAppConfiguration().dumpRequestHeaders(), path);
        LogUtil.avlog.d(string);
    }

    private String headerString(Map<String, String> header) {
        String string = InternalConfigurationController.globalInstance().getAppConfiguration().dumpRequestHeaders();
        StringBuilder sb = new StringBuilder(string);
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String item = String.format(" -H \"%s: %s\" ", entry.getKey(), entry.getValue());
                sb.append(item);
            }
        }
        sb.append(" -H \"Content-Type: application/json\" ");
        return sb.toString();
    }

    public void dumpHttpPutRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X PUT %s  -d ' %s ' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void dumpHttpPostRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X POST %s  -d '%s' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void dumpHttpDeleteRequest(Map<String, String> header, String path, String object) {
        String string = String.format("curl -X DELETE %s  -d '%s' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string);
    }

    public void updateHeaderForPath(String relativePath, AVRequestParams parameters, Map<String, String> header) {
        if (PaasClient.isLastModifyEnabled() && null != header && !AVUtils.isBlankString(relativePath)) {
            String absoluteURLString = this.generateQueryPath(relativePath, parameters);
            String modify = PaasClient.getLastModify(absoluteURLString);
            boolean exist = InternalConfigurationController.globalInstance().getCache().hasCache(absoluteURLString, modify);
            if (modify != null && exist) {
                header.put("If-Modified-Since", modify);
            }
        }
    }

    public static String getLastModify(String absolutURLString) {
        if (!PaasClient.isLastModifyEnabled()) {
            return null;
        }
        return lastModify.get(absolutURLString);
    }

    public static boolean isLastModifyEnabled() {
        return lastModifyEnabled;
    }

    public static void setLastModifyEnabled(boolean e) {
        lastModifyEnabled = e;
    }

    public static void clearLastModifyCache() {
        for (Map.Entry<String, String> pairs : lastModify.entrySet()) {
            InternalConfigurationController.globalInstance().getCache().remove(pairs.getKey(), pairs.getValue());
        }
        lastModify.clear();
    }

    public static String lastModifyFromHeaders(Header[] headers) {
        for (Header h : headers) {
            if (!"Last-Modified".equalsIgnoreCase(h.name.utf8())) continue;
            return h.value.utf8();
        }
        return null;
    }

    public static boolean updateLastModify(String absolutURLString, String ts) {
        if (!PaasClient.isLastModifyEnabled()) {
            return false;
        }
        if (!AVUtils.isBlankString(ts)) {
            lastModify.put(absolutURLString, ts);
            return true;
        }
        return false;
    }

    public static void removeLastModifyForUrl(String absolutURLString) {
        lastModify.remove(absolutURLString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerEventuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter = internalObjectsForEventuallySave.get(object.internalId());
                if (counter != null) {
                    counter.increment();
                } else {
                    counter = new AVObjectReferenceCount(object);
                    internalObjectsForEventuallySave.put(object.internalId(), counter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterEvtuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter;
                AVObjectReferenceCount aVObjectReferenceCount = counter = internalObjectsForEventuallySave.get(object.internalId()) == null ? internalObjectsForEventuallySave.get(object.internalId()) : internalObjectsForEventuallySave.get(object.getUuid());
                if (counter != null && counter.desc() <= 0) {
                    internalObjectsForEventuallySave.remove(object.internalId());
                    internalObjectsForEventuallySave.remove(object.getUuid());
                }
            }
        }
    }

    public static interface ProgressListener {
        public void update(long var1, long var3, boolean var5);
    }

    private static class ProgressResponseBody
    extends ResponseBody {
        private final ResponseBody responseBody;
        private final ProgressListener progressListener;
        private BufferedSource bufferedSource;

        public ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
            this.responseBody = responseBody;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() throws IOException {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() throws IOException {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    ProgressResponseBody.this.progressListener.update(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                    return bytesRead;
                }
            };
        }
    }

    public static class ProgressInterceptor
    implements Interceptor {
        private ProgressListener progressListener;

        public ProgressInterceptor(ProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response originalResponse = chain.proceed(chain.request());
            return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), this.progressListener)).build();
        }
    }

    public static class AVHttpClient {
        OkHttpClient client = new OkHttpClient();
        public static final MediaType JSON = MediaType.parse((String)"application/json");

        public AVHttpClient() {
            this.client.setCookieHandler(cookieHandler);
            this.client.interceptors().addAll(InternalConfigurationController.globalInstance().getClientConfiguration().getClientInterceptors());
            if (AVUtils.isAndroid()) {
                this.client.setDns((Dns)DNSAmendNetwork.getInstance());
            }
        }

        public void execute(Request request, boolean sync, ProgressListener progressListener, AsyncHttpResponseHandler handler) {
            Call call = this.getProgressCall(request, progressListener);
            if (sync) {
                try {
                    Response response = call.execute();
                    handler.onResponse(response);
                }
                catch (IOException e) {
                    handler.onFailure(request, e);
                }
            } else {
                call.enqueue((Callback)handler);
            }
        }

        public void execute(Request request, boolean sync, AsyncHttpResponseHandler handler) {
            Call call = this.getCall(request);
            if (sync) {
                try {
                    Response response = call.execute();
                    handler.onResponse(response);
                }
                catch (IOException e) {
                    handler.onFailure(request, e);
                }
            } else {
                call.enqueue((Callback)handler);
            }
        }

        private synchronized Call getProgressCall(Request request, ProgressListener progressListener) {
            ProgressInterceptor progressInterceptor = new ProgressInterceptor(progressListener);
            this.client.networkInterceptors().add(progressInterceptor);
            Call call = this.client.newCall(request);
            this.client.networkInterceptors().remove(progressInterceptor);
            return call;
        }

        private synchronized Call getCall(Request request) {
            return this.client.newCall(request);
        }

        public void setConnectTimeout(long networkTimeout, TimeUnit timeUnit) {
            this.client.setConnectTimeout(networkTimeout, timeUnit);
        }
    }
}

