/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.Request;

public class AppRouterManager {
    private static final String ROUTER_ADDRESS = " https://app-router.leancloud.cn/1/route?appId=";
    private static final String PUSH_ROUTER_SERVER_KEY = "push_router_server";
    private static final String API_SERVER_KEY = "api_server";
    private static final String TTL_KEY = "ttl";
    private static final String LATEST_UPDATE_TIME_KEY = "latest_update_time";
    private static String routerSharePreferenceName = "";
    private String apiServer = "";
    private String routerServer = "";
    private static final String DETAULT_UCLOUD_API_SERVER = "https://api.leancloud.cn";
    private static final String DEFAULT_QCLOUD_API_SERVER = "https://e1-api.leancloud.cn";
    protected static final String DEFAULT_US_API_SERVER = "https://us-api.leancloud.cn";
    private static final String DEFAULT_UCLOUD_ROUTER_SERVER = "https://router-g0-push.leancloud.cn";
    private static final String DEFAULT_QCLOUD_ROUTER_SERVER = "https://router-q0-push.leancloud.cn";
    public static AppRouterManager appRouterManager;

    public static synchronized AppRouterManager getInstance() {
        if (null == appRouterManager) {
            appRouterManager = new AppRouterManager();
        }
        return appRouterManager;
    }

    private AppRouterManager() {
    }

    public String getAPIServer() {
        if (AVUtils.isBlankContent(this.apiServer)) {
            return this.isQCloudApp(InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId()) ? DEFAULT_QCLOUD_API_SERVER : DETAULT_UCLOUD_API_SERVER;
        }
        return this.apiServer;
    }

    public String getRouterServer() {
        if (AVUtils.isBlankContent(this.routerServer)) {
            return this.isQCloudApp(InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId()) ? DEFAULT_QCLOUD_ROUTER_SERVER : DEFAULT_UCLOUD_ROUTER_SERVER;
        }
        return this.routerServer;
    }

    public void updateRouterServer(String router, boolean persistence) {
        this.routerServer = AppRouterManager.addHttpsPrefix(router);
        if (persistence) {
            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingString(routerSharePreferenceName, PUSH_ROUTER_SERVER_KEY, this.routerServer);
        }
    }

    public void updateAPIServer(String server, boolean persistence) {
        this.apiServer = AppRouterManager.addHttpsPrefix(server);
        if (persistence) {
            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingString(routerSharePreferenceName, API_SERVER_KEY, this.apiServer);
        }
    }

    public void fetchRouter(boolean force) {
        this.updateServers();
        Long lastTime = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingLong(routerSharePreferenceName, LATEST_UPDATE_TIME_KEY, 0L);
        int ttl = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingInteger(routerSharePreferenceName, TTL_KEY, 0);
        if (force || System.currentTimeMillis() - lastTime > (long)(ttl * 1000)) {
            PaasClient.AVHttpClient client = new PaasClient.AVHttpClient();
            Request.Builder builder = new Request.Builder();
            builder.url(ROUTER_ADDRESS + InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId()).get();
            client.execute(builder.build(), false, new GetHttpResponseHandler(new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    if (null == e) {
                        if (InternalConfigurationController.globalInstance().getInternalLogger().showInternalDebugLog()) {
                            LogUtil.avlog.d(" fetchRouter :" + content);
                        }
                        JSONObject response = null;
                        try {
                            response = JSON.parseObject((String)content);
                        }
                        catch (Exception exception) {
                            LogUtil.log.e("get router error ", exception);
                        }
                        if (null != response && response.containsKey((Object)AppRouterManager.PUSH_ROUTER_SERVER_KEY) && response.containsKey((Object)AppRouterManager.API_SERVER_KEY)) {
                            AppRouterManager.this.apiServer = AppRouterManager.addHttpsPrefix(response.getString(AppRouterManager.API_SERVER_KEY));
                            AppRouterManager.this.routerServer = AppRouterManager.addHttpsPrefix(response.getString(AppRouterManager.PUSH_ROUTER_SERVER_KEY));
                            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingString(routerSharePreferenceName, AppRouterManager.PUSH_ROUTER_SERVER_KEY, AppRouterManager.this.routerServer);
                            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingString(routerSharePreferenceName, AppRouterManager.API_SERVER_KEY, AppRouterManager.this.apiServer);
                            if (response.containsKey((Object)AppRouterManager.TTL_KEY)) {
                                InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingInteger(routerSharePreferenceName, AppRouterManager.TTL_KEY, response.getIntValue(AppRouterManager.TTL_KEY));
                            }
                            InternalConfigurationController.globalInstance().getInternalPersistence().savePersistentSettingLong(routerSharePreferenceName, AppRouterManager.LATEST_UPDATE_TIME_KEY, System.currentTimeMillis());
                            PaasClient.updateAPIServer(AppRouterManager.this.apiServer);
                        }
                    } else {
                        LogUtil.log.e("get router error ", e);
                    }
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    LogUtil.log.e("get router error ", new AVException(error));
                }
            }));
        }
    }

    private void updateServers() {
        routerSharePreferenceName = "com.avos.avoscloud.approuter." + InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId();
        this.routerServer = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingString(routerSharePreferenceName, PUSH_ROUTER_SERVER_KEY, this.getRouterServer());
        this.apiServer = InternalConfigurationController.globalInstance().getInternalPersistence().getPersistentSettingString(routerSharePreferenceName, API_SERVER_KEY, this.getAPIServer());
        PaasClient.updateAPIServer(this.apiServer);
    }

    private static String addHttpsPrefix(String url) {
        if (!AVUtils.isBlankContent(url) && !url.startsWith("http")) {
            return "https://" + url;
        }
        return url;
    }

    private boolean isQCloudApp(String appId) {
        return !AVUtils.isBlankContent(appId) && appId.endsWith("9Nh9j0Va");
    }
}

