/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.JSONHelper;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.okhttp.internal.framed.Header;
import com.avos.avoscloud.utils.Base64;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class AVUtils {
    private static final String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String classNameTag = "className";
    public static final String typeTag = "__type";
    public static final String objectIdTag = "objectId";
    private static Map<Class<?>, Field[]> fieldsMap = Collections.synchronizedMap(new WeakHashMap());
    static Pattern pattern = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    static Pattern emailPattern = Pattern.compile("^\\w+?@\\w+?[.]\\w+");
    static Pattern phoneNumPattern = Pattern.compile("1\\d{10}");
    static Pattern verifyCodePattern = Pattern.compile("\\d{6}");
    static Pattern artVMPatter = Pattern.compile("(\\d)\\.\\d+\\.?.*");
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL_DATE_FORMAT = new ThreadLocal();
    static Random random = new Random();
    static AtomicInteger acu = new AtomicInteger(-65536);
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_MOBILE = 2;
    public static final int TYPE_NOT_CONNECTED = 0;
    private static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final boolean IS_ANDROID = AVUtils.isAndroid(JAVA_VM_NAME);
    protected static final int defaultFileKeyLength = 40;

    public static Map<String, Object> createArrayOpMap(String key, String op, Collection<?> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Object> array = new ArrayList<Object>();
        for (Object obj : objects) {
            array.add(AVUtils.getParsedObject(obj));
        }
        map.put("objects", array);
        HashMap<String, Object> ops = new HashMap<String, Object>();
        ops.put(key, map);
        return ops;
    }

    public static Field[] getAllFiels(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return new Field[0];
        }
        Field[] theResult = fieldsMap.get(clazz);
        if (theResult != null) {
            return theResult;
        }
        ArrayList<Field[]> fields = new ArrayList<Field[]>();
        int length = 0;
        while (clazz != null && clazz != Object.class) {
            Field[] declaredFields = clazz.getDeclaredFields();
            length += declaredFields != null ? declaredFields.length : 0;
            fields.add(declaredFields);
            clazz = clazz.getSuperclass();
        }
        theResult = new Field[length];
        int i = 0;
        for (Field[] someFields : fields) {
            if (someFields == null) continue;
            for (Field field : someFields) {
                field.setAccessible(true);
            }
            System.arraycopy(someFields, 0, theResult, i, someFields.length);
            i += someFields.length;
        }
        fieldsMap.put(clazz, theResult);
        return theResult;
    }

    public static boolean checkEmailAddress(String email) {
        return emailPattern.matcher(email).find();
    }

    public static boolean checkMobilePhoneNumber(String phoneNumber) {
        return phoneNumPattern.matcher(phoneNumber).find();
    }

    public static boolean checkMobileVerifyCode(String verifyCode) {
        return verifyCodePattern.matcher(verifyCode).find();
    }

    public static void checkClassName(String className) {
        if (AVUtils.isBlankString(className)) {
            throw new IllegalArgumentException("Blank class name");
        }
        if (!pattern.matcher(className).matches()) {
            throw new IllegalArgumentException("Invalid class name");
        }
    }

    public static boolean isBlankString(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean isBlankContent(String content) {
        return AVUtils.isBlankString(content) || content.trim().equals("{}");
    }

    public static boolean contains(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }

    public static Map<String, Object> createDeleteOpMap(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("__op", "Delete");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, map);
        return result;
    }

    public static Map<String, Object> createPointerArrayOpMap(String key, String op, Collection<AVObject> objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("__op", op);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (AVObject obj : objects) {
            list.add(AVUtils.mapFromPointerObject(obj));
        }
        map.put("objects", list);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, map);
        return result;
    }

    public static Map<String, Object> createStringObjectMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static Map<String, Object> mapFromPointerObject(AVObject object) {
        return AVUtils.mapFromPointerObject(object, false);
    }

    public static Map<String, Object> mapFromPointerObject(AVObject object, boolean withPointerValue) {
        return AVUtils.mapFromAVObject(object, false, false, false, withPointerValue);
    }

    public static Map<String, Object> mapFromUserObjectId(String userObjectId) {
        if (AVUtils.isBlankString(userObjectId)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Pointer");
        result.put(classNameTag, "_User");
        result.put(objectIdTag, userObjectId);
        return result;
    }

    public static Map<String, String> mapFromChildObject(AVObject object, String key) {
        String cid = object.internalId();
        HashMap<String, String> child = new HashMap<String, String>(3);
        child.put("cid", cid);
        child.put(classNameTag, object.getClassName());
        child.put("key", key);
        return child;
    }

    public static boolean isDigitString(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static Date dateFromString(String content) {
        if (AVUtils.isBlankString(content)) {
            return null;
        }
        if (AVUtils.isDigitString(content)) {
            return new Date(Long.parseLong(content));
        }
        Date date = null;
        SimpleDateFormat format = THREAD_LOCAL_DATE_FORMAT.get();
        if (format == null) {
            format = new SimpleDateFormat(dateFormat);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            THREAD_LOCAL_DATE_FORMAT.set(format);
        }
        try {
            date = format.parse(content);
        }
        catch (Exception exception) {
            LogUtil.log.e(exception.toString());
        }
        return date;
    }

    public static String stringFromDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String isoDate = df.format(date);
        return isoDate;
    }

    public static Map<String, Object> mapFromDate(Date date) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Date");
        result.put("iso", AVUtils.stringFromDate(date));
        return result;
    }

    public static Date dateFromMap(Map<String, Object> map) {
        String value = (String)map.get("iso");
        return AVUtils.dateFromString(value);
    }

    public static Map<String, Object> mapFromGeoPoint(AVGeoPoint point) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "GeoPoint");
        result.put("latitude", point.getLatitude());
        result.put("longitude", point.getLongitude());
        return result;
    }

    public static AVGeoPoint geoPointFromMap(Map<String, Object> map) {
        double la = 0.0;
        double lo = 0.0;
        if (map.containsKey("latitude") && null != map.get("latitude")) {
            la = ((Number)map.get("latitude")).doubleValue();
        }
        if (map.containsKey("longitude") && null != map.get("longitude")) {
            lo = ((Number)map.get("longitude")).doubleValue();
        }
        AVGeoPoint point = new AVGeoPoint(la, lo);
        return point;
    }

    public static AVObject objectFromRelationMap(Map<String, Object> map) {
        String className = (String)map.get(classNameTag);
        AVObject object = AVUtils.objectFromClassName(className);
        return object;
    }

    public static Map<String, Object> mapFromByteArray(byte[] data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(typeTag, "Bytes");
        result.put("base64", Base64.encodeToString(data, 2));
        return result;
    }

    public static byte[] dataFromMap(Map<String, Object> map) {
        String value = (String)map.get("base64");
        return Base64.decode(value, 2);
    }

    public static String jsonStringFromMapWithNull(Object map) {
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
    }

    public static String jsonStringFromObjectWithNull(Object map) {
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
    }

    @Deprecated
    public static Map<String, Object> mapFromFile(AVFile file) {
        return file.toMap();
    }

    @Deprecated
    public static AVFile fileFromMap(Map<String, Object> map) {
        return AVFile.fileFromMap(map);
    }

    public static AVObject parseObjectFromMap(Map<String, Object> map) {
        AVObject object = AVUtils.newAVObjectByClassName((String)map.get(classNameTag));
        object.setObjectId((String)map.get(objectIdTag));
        AVUtils.copyPropertiesFromMapToAVObject(map, object);
        return object;
    }

    public static String restfulServerData(Map<String, ?> data) {
        if (data == null) {
            return "{}";
        }
        Map<String, Object> map = AVUtils.getParsedMap(data);
        return AVUtils.jsonStringFromMapWithNull(map);
    }

    public static String restfulCloudData(Object object) {
        if (object == null) {
            return "{}";
        }
        if (object instanceof Map) {
            return AVUtils.jsonStringFromMapWithNull(AVUtils.getParsedMap((Map)object, true));
        }
        if (object instanceof Collection) {
            return AVUtils.jsonStringFromObjectWithNull(AVUtils.getParsedList((Collection)object, true));
        }
        if (object instanceof AVObject) {
            return AVUtils.jsonStringFromMapWithNull(AVUtils.mapFromAVObject((AVObject)object, true));
        }
        if (object instanceof AVGeoPoint) {
            return AVUtils.jsonStringFromMapWithNull(AVUtils.mapFromGeoPoint((AVGeoPoint)object));
        }
        if (object instanceof Date) {
            return AVUtils.jsonStringFromObjectWithNull(AVUtils.mapFromDate((Date)object));
        }
        if (object instanceof byte[]) {
            return AVUtils.jsonStringFromMapWithNull(AVUtils.mapFromByteArray((byte[])object));
        }
        if (object instanceof AVFile) {
            return AVUtils.jsonStringFromMapWithNull(((AVFile)object).toMap());
        }
        if (object instanceof JSONObject) {
            return AVUtils.jsonStringFromObjectWithNull(JSON.parse((String)object.toString()));
        }
        if (object instanceof JSONArray) {
            return AVUtils.jsonStringFromObjectWithNull(JSON.parse((String)object.toString()));
        }
        return AVUtils.jsonStringFromObjectWithNull(object);
    }

    private static Map<String, Object> mapFromAVObject(AVObject object, boolean topObject) {
        return AVUtils.mapFromAVObject(object, topObject, false);
    }

    private static Map<String, Object> mapFromAVObject(AVObject object, boolean topObject, boolean instanceValue) {
        return AVUtils.mapFromAVObject(object, topObject, instanceValue, false, false);
    }

    private static Map<String, Object> mapFromAVObject(AVObject object, boolean topObject, boolean instanceValue, boolean withDate, boolean withPointerValue) {
        Map<String, Object> serverData;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(classNameTag, object.internalClassName());
        if (!AVUtils.isBlankString(object.getObjectId())) {
            result.put(objectIdTag, object.getObjectId());
        }
        result.put(typeTag, topObject ? "Object" : "Pointer");
        if ((withPointerValue || topObject) && (serverData = AVUtils.getParsedMap(object.serverData, false, false, false, withPointerValue)) != null && !serverData.isEmpty()) {
            result.putAll(serverData);
        }
        if (instanceValue && (serverData = AVUtils.getParsedMap(object.instanceData, false, false, false, withPointerValue)) != null && !serverData.isEmpty()) {
            result.putAll(serverData);
        }
        if (withDate) {
            if (object.getCreatedAt() != null) {
                result.put("createdAt", object.createdAt);
            }
            if (object.getUpdatedAt() != null) {
                result.put("updatedAt", object.updatedAt);
            }
        }
        return result;
    }

    private static List getParsedList(Collection object, boolean topObject, boolean instanceValue, boolean withDate, boolean withPointerValue) {
        if (!topObject) {
            return AVUtils.getParsedList(object);
        }
        ArrayList<Object> newList = new ArrayList<Object>(object.size());
        for (Object o : object) {
            newList.add(AVUtils.getParsedObject(o, true, instanceValue, withDate, false, withPointerValue));
        }
        return newList;
    }

    private static List getParsedList(Collection object, boolean topObject) {
        return AVUtils.getParsedList(object, topObject, false, false, false);
    }

    private static Map<String, Object> getParsedMap(Map<String, Object> object, boolean topObject, boolean instanceData, boolean withDate) {
        return AVUtils.getParsedMap(object, topObject, instanceData, withDate, false);
    }

    private static Map<String, Object> getParsedMap(Map<String, Object> object, boolean topObject, boolean instanceData, boolean withDate, boolean withPointerValue) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(object.size());
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            newMap.put(key, AVUtils.getParsedObject(o, topObject, instanceData, withDate, false, withPointerValue));
        }
        return newMap;
    }

    private static Map<String, Object> getParsedMap(Map<String, Object> object, boolean topObject) {
        return AVUtils.getParsedMap(object, topObject, false, false);
    }

    public static boolean hasProperty(Class<?> clazz, String property) {
        Field[] fields;
        for (Field f : fields = AVUtils.getAllFiels(clazz)) {
            if (!f.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAndSetValue(Class<?> clazz, Object parent, String property, Object value) {
        if (clazz == null) {
            return false;
        }
        try {
            Field[] fields;
            for (Field f : fields = AVUtils.getAllFiels(clazz)) {
                if (!f.getName().equals(property) || !f.getType().isInstance(value) && value != null) continue;
                f.set(parent, value);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void updatePropertyFromMap(AVObject parent, String key, Map<String, Object> map) {
        String objectId = (String)map.get(objectIdTag);
        String type = (String)map.get(typeTag);
        if (type == null && objectId == null) {
            parent.put(key, map, false);
            return;
        }
        if (AVUtils.isGeoPoint(type)) {
            AVGeoPoint point = AVUtils.geoPointFromMap(map);
            parent.put(key, point, false);
        } else if (AVUtils.isDate(type)) {
            Date date = AVUtils.dateFromMap(map);
            parent.put(key, date, false);
        } else if (AVUtils.isData(type)) {
            byte[] data = AVUtils.dataFromMap(map);
            parent.put(key, data, false);
        } else if (AVUtils.isFile(type)) {
            AVFile file = AVFile.fileFromMap(map);
            parent.put(key, file, false);
        } else if (AVUtils.isFileFromUrulu(map)) {
            AVFile file = AVFile.fileFromMap(map);
            parent.put(key, file, false);
        } else if (AVUtils.isRelation(type)) {
            parent.addRelationFromServer(key, (String)map.get(classNameTag), false);
        } else if (AVUtils.isPointer(type) || !AVUtils.isBlankString(objectId) && type != null) {
            AVObject object = AVUtils.parseObjectFromMap(map);
            parent.put(key, object, false);
        } else {
            parent.put(key, map, false);
        }
    }

    public static void updatePropertyFromList(AVObject object, String key, Collection<Object> list) {
        List data = AVUtils.getObjectFrom(list);
        object.put(key, data, false);
    }

    public static void copyPropertiesFromJsonStringToAVObject(String content, AVObject object) {
        if (AVUtils.isBlankString(content)) {
            return;
        }
        try {
            Map<String, Object> map = JSONHelper.mapFromString(content);
            AVUtils.copyPropertiesFromMapToAVObject(map, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void copyPropertiesFromMapToAVObject(Map<String, Object> map, AVObject object) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key != null && key.startsWith("_")) continue;
            Object valueObject = entry.getValue();
            if (AVUtils.checkAndSetValue(object.getClass(), object, key, valueObject)) {
                if (key.startsWith("_") || AVObject.INVALID_KEYS.contains(key)) continue;
                object.put(key, valueObject, false);
                continue;
            }
            if (valueObject instanceof Collection) {
                AVUtils.updatePropertyFromList(object, key, (Collection)valueObject);
                continue;
            }
            if (valueObject instanceof Map) {
                AVUtils.updatePropertyFromMap(object, key, (Map)valueObject);
                continue;
            }
            if (key.startsWith("_")) continue;
            object.put(key, valueObject, false);
        }
    }

    public static void copyPropertiesFromMapToObject(Map<String, Object> map, Object object) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object valueObject = entry.getValue();
            if (!AVUtils.checkAndSetValue(object.getClass(), object, key, valueObject)) continue;
        }
    }

    public static Class getClass(Map<String, ?> map) {
        Object type = map.get(typeTag);
        if (type == null || !(type instanceof String)) {
            return Map.class;
        }
        if (type.equals("Pointer")) {
            return AVObject.class;
        }
        if (type.equals("GeoPoint")) {
            return AVGeoPoint.class;
        }
        if (type.equals("Bytes")) {
            return byte[].class;
        }
        if (type.equals("Date")) {
            return Date.class;
        }
        return Map.class;
    }

    public static boolean isRelation(String type) {
        return type != null && type.equals("Relation");
    }

    public static boolean isPointer(String type) {
        return type != null && type.equals("Pointer");
    }

    public static boolean isGeoPoint(String type) {
        return type != null && type.equals("GeoPoint");
    }

    public static boolean isACL(String type) {
        return type != null && type.equals("ACL");
    }

    public static boolean isDate(String type) {
        return type != null && type.equals("Date");
    }

    public static boolean isData(String type) {
        return type != null && type.equals("Bytes");
    }

    public static boolean isFile(String type) {
        return type != null && type.equals("File");
    }

    public static boolean isFileFromUrulu(Map<String, Object> map) {
        boolean result = true;
        return result &= map.get("mime_type") != null;
    }

    public static AVObject objectFromClassName(String className) {
        if (className.equals(AVPowerfulUtils.getAVClassName(AVUser.class.getSimpleName()))) {
            return AVUser.newAVUser();
        }
        AVObject object = AVUtils.newAVObjectByClassName(className);
        return object;
    }

    public static AVObject newAVObjectByClassName(String name) {
        if (name.equals("_Role")) {
            return new AVRole();
        }
        if (name.equals(AVUser.userClassName())) {
            return AVUser.newAVUser();
        }
        Class<? extends AVObject> subClazz = AVObject.getSubClass(name);
        if (subClazz != null) {
            try {
                return subClazz.newInstance();
            }
            catch (Exception e) {
                throw new AVRuntimeException("New subclass instance failed.", e);
            }
        }
        return new AVObject(name);
    }

    public static Class<? extends AVObject> getAVObjectClassByClassName(String name) {
        if (name.equals("_Role")) {
            return AVRole.class;
        }
        if (name.equals(AVUser.userClassName())) {
            return AVUser.class;
        }
        Class<? extends AVObject> subClazz = AVObject.getSubClass(name);
        return subClazz;
    }

    public static AVObject newAVObjectByClassName(String className, String defaultClassName) {
        String objectClassName = AVUtils.isBlankString(className) ? defaultClassName : className;
        return AVUtils.newAVObjectByClassName(objectClassName);
    }

    public static final <T> T getFromJSON(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static final <T> String toJSON(T clazz) {
        if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
            return JSON.toJSONString(clazz, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString(clazz);
    }

    static Map<String, Object> getParsedMap(Map<String, Object> map) {
        return AVUtils.getParsedMap(map, false);
    }

    static List getParsedList(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            newList.add(AVUtils.getParsedObject(o));
        }
        return newList;
    }

    public static Object getParsedObject(Object object) {
        return AVUtils.getParsedObject(object, false);
    }

    public static Object getParsedObject(Object object, boolean topObject) {
        return AVUtils.getParsedObject(object, topObject, false);
    }

    public static Object getParsedObject(Object object, boolean topObject, boolean instanceValue) {
        return AVUtils.getParsedObject(object, topObject, instanceValue, false);
    }

    public static Object getParsedObject(Object object, boolean topObject, boolean instanceValue, boolean withDate) {
        return AVUtils.getParsedObject(object, topObject, instanceValue, withDate, false);
    }

    public static Object getParsedObject(Object object, boolean topObject, boolean instanceValue, boolean withDate, boolean withACL) {
        return AVUtils.getParsedObject(object, topObject, instanceValue, withDate, withACL, false);
    }

    public static Object getParsedObject(Object object, boolean topObject, boolean instanceValue, boolean withDate, boolean withACL, boolean withPointerValue) {
        return new ObjectParser().asTopObject(topObject).withInstanceValue(instanceValue).withDate(withDate).withACL(withACL).withPointerValue(withPointerValue).parse(object);
    }

    static List getObjectFrom(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Object obj : list) {
            newList.add(AVUtils.getObjectFrom(obj));
        }
        return newList;
    }

    static Object getObjectFrom(Map<String, Object> map) {
        Object type = map.get(typeTag);
        if (type == null || !(type instanceof String)) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object o = entry.getValue();
                newMap.put(key, AVUtils.getObjectFrom(o));
            }
            return newMap;
        }
        if (type.equals("Pointer") || type.equals("Object")) {
            AVObject parseObject = AVUtils.objectFromClassName((String)map.get(classNameTag));
            map.remove(typeTag);
            AVUtils.copyPropertiesFromMapToAVObject(map, parseObject);
            return parseObject;
        }
        if (type.equals("GeoPoint")) {
            return AVUtils.geoPointFromMap(map);
        }
        if (type.equals("Bytes")) {
            return AVUtils.dataFromMap(map);
        }
        if (type.equals("Date")) {
            return AVUtils.dateFromMap(map);
        }
        if (type.equals("Relation")) {
            return AVUtils.objectFromRelationMap(map);
        }
        if (type.equals("File")) {
            return AVFile.fileFromMap(map);
        }
        return map;
    }

    static Object getObjectFrom(Object obj) {
        if (obj instanceof Collection) {
            return AVUtils.getObjectFrom((Collection)obj);
        }
        if (obj instanceof Map) {
            return AVUtils.getObjectFrom((Map)obj);
        }
        return obj;
    }

    public static String md5(String string) {
        byte[] hash = null;
        try {
            hash = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh,UTF-8 should be supported?", e);
        }
        return AVUtils.computeMD5(hash);
    }

    public static String getRandomString(int length) {
        String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder randomString = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            randomString.append(letters.charAt(random.nextInt(letters.length())));
        }
        return randomString.toString();
    }

    public static int getNextIMRequestId() {
        int val = acu.incrementAndGet();
        if (val > 65535) {
            while (val > 65535 && !acu.compareAndSet(val, -65536)) {
                val = acu.get();
            }
            return val;
        }
        return val;
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static String joinCollection(Collection<String> collection, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean wasFirst = true;
        for (String value : collection) {
            if (wasFirst) {
                wasFirst = false;
                builder.append(value);
                continue;
            }
            builder.append(separator).append(value);
        }
        return builder.toString();
    }

    public static String stringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String fileMd5(String fileName) throws IOException {
        return AVUtils.computeMD5(AVUtils.readFile(fileName));
    }

    public static byte[] readFile(String file) throws IOException {
        return AVUtils.readFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            long longlength = f.length();
            int length = (int)longlength;
            if ((long)length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            byte[] data = new byte[length];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            AVUtils.closeQuietly(f);
        }
    }

    public static String computeMD5(byte[] input) {
        try {
            if (null == input) {
                return null;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input, 0, input.length);
            byte[] md5bytes = md.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < md5bytes.length; ++i) {
                String hex = Integer.toHexString(0xFF & md5bytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static String getJSONString(com.alibaba.fastjson.JSONObject object, String key, String defaultValue) {
        if (object.containsKey((Object)key)) {
            return object.getString(key);
        }
        return defaultValue;
    }

    static long getJSONInteger(com.alibaba.fastjson.JSONObject object, String key, long defaultValue) {
        if (object.containsKey((Object)key)) {
            return object.getInteger(key).intValue();
        }
        return defaultValue;
    }

    public static String getArchiveRequestFileName(String objectId, String _internalId, String method, String relativePath, String paramString) {
        if (method.equalsIgnoreCase("put")) {
            return AVUtils.md5(relativePath + paramString);
        }
        if (method.equalsIgnoreCase("post")) {
            return _internalId;
        }
        if (method.equalsIgnoreCase("delete")) {
            return AVUtils.isBlankString(objectId) ? _internalId : AVUtils.md5(relativePath + paramString);
        }
        return AVUtils.md5(relativePath + paramString);
    }

    public static int collectionNonNullCount(Collection collection) {
        int count = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            ++count;
        }
        return count;
    }

    public static String urlCleanLastSlash(String url) {
        if (!AVUtils.isBlankString(url) && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getSessionKey(String selfId) {
        StringBuilder sb = new StringBuilder(InternalConfigurationController.globalInstance().getAppConfiguration().getApplicationId());
        sb.append(selfId);
        return sb.toString();
    }

    public static boolean isEmptyList(List e) {
        return e == null || e.isEmpty();
    }

    public static void ensureElementsNotNull(List<String> e, String errorLog) {
        for (String i : e) {
            if (i != null) continue;
            throw new NullPointerException(errorLog);
        }
    }

    public static boolean compareNumberString(String firstNumber, String secondNumber) {
        return Double.compare(Double.parseDouble(firstNumber), Double.parseDouble(secondNumber)) == 1;
    }

    public static String Base64Encode(String data) {
        return Base64.encodeToString(data.getBytes(), 10);
    }

    public static PaasClient.AVHttpClient getDirectlyClientForUse() {
        return PaasClient.storageInstance().clientInstance();
    }

    public static Map<String, Object> createMap(String cmp, Object value) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put(cmp, value);
        return dict;
    }

    public static boolean checkResponseType(int statusCode, String content, String contentType, GenericObjectCallback callback) {
        if (statusCode > 0 && !AVUtils.isJSONResponse(contentType, content)) {
            if (callback != null) {
                callback.onFailure(statusCode, new AVException(107, "Wrong response content type:" + contentType), content);
            }
            return true;
        }
        return false;
    }

    public static String getHostName(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String domain = uri.getHost();
        return domain.startsWith("www.") ? domain.substring(4) : domain;
    }

    public static String getAVObjectClassName(Class<? extends AVObject> clazz) {
        return AVObject.getSubClassName(clazz);
    }

    public static String getAVObjectCreatedAt(AVObject object) {
        return object.createdAt;
    }

    public static String getAVObjectUpdatedAt(AVObject object) {
        return object.updatedAt;
    }

    public static String getEncodeUrl(String url, Map<String, String> params) {
        return new AVRequestParams(params).getWholeUrl(url);
    }

    public static String getJSONValue(String msg, String key) {
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        Object action = jsonMap.get(key);
        return action != null ? action.toString() : null;
    }

    public static boolean equals(String a, String b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LogUtil.log.d(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContentBytesFromFile(File fileForRead) {
        if (fileForRead == null) {
            LogUtil.avlog.e("null file object.");
            return null;
        }
        if (!fileForRead.exists() || !fileForRead.isFile()) {
            if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                LogUtil.log.d("not file object", new FileNotFoundException());
            }
            return null;
        }
        byte[] data = null;
        BufferedInputStream input = null;
        try {
            data = new byte[(int)fileForRead.length()];
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(fileForRead), 8192);
            while (totalBytesRead < data.length) {
                int bytesRemaining = data.length - totalBytesRead;
                int bytesRead = ((InputStream)input).read(data, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
            byte[] byArray = data;
            AVUtils.closeQuietly(input);
            return byArray;
        }
        catch (IOException e) {
            if (InternalConfigurationController.globalInstance().getInternalLogger().isDebugEnabled()) {
                LogUtil.log.e("Exception during file read", e);
            }
        }
        finally {
            AVUtils.closeQuietly(input);
        }
        return null;
    }

    public static boolean isJSONResponse(String contentType, String content) {
        boolean result = false;
        if (!AVUtils.isBlankString(contentType)) {
            result = contentType.toLowerCase().contains("application/json");
        }
        if (!result) {
            result = AVUtils.isJSONResponseContent(content);
        }
        return result;
    }

    public static boolean isJSONResponseContent(String content) {
        try {
            JSON.parse((String)content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String extractContentType(Header[] headers) {
        if (headers != null) {
            for (Header h : headers) {
                if (!h.name.toString().equalsIgnoreCase("Content-Type")) continue;
                return h.value.toString();
            }
        }
        return null;
    }

    public static String fileCacheKey(String key, String ts) {
        if (!AVUtils.isBlankString(ts)) {
            return AVUtils.md5(key + ts);
        }
        return AVUtils.md5(key);
    }

    public static boolean isART(String vmName) {
        Matcher matcher = artVMPatter.matcher(vmName);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1)) >= 2;
        }
        return false;
    }

    public static boolean isAndroid(String vmName) {
        if (vmName == null) {
            return false;
        }
        String lowerVMName = vmName.toLowerCase();
        return lowerVMName.contains("dalvik") || AVUtils.isART(lowerVMName);
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static <T> T or(T object, T defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static void callCallback(AVCallback callback, Object t, AVException parseException) {
        if (callback != null) {
            callback.internalDone0(t, parseException);
        }
    }

    public static String addQueryParams(String path, Map<String, Object> params) {
        LinkedList<BasicNameValuePair> pairs = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), JSON.toJSONString((Object)entry.getValue())));
        }
        return String.format("%s?%s", path, URLEncodedUtils.format(pairs, (String)"UTF-8"));
    }

    public static String parseFileKey(String fileName) {
        String key = AVUtils.getRandomString(40);
        int idx = 0;
        if (!AVUtils.isBlankString(fileName)) {
            idx = fileName.lastIndexOf(".");
        }
        if (idx > 0) {
            String postFix = fileName.substring(idx);
            key = key + postFix;
        }
        return key;
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte b : data) {
            int halfbyte = b >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                buf.append(0 <= halfbyte && halfbyte <= 9 ? (char)(48 + halfbyte) : (char)(97 + (halfbyte - 10)));
                halfbyte = b & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String SHA1(byte[] data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(data, 0, data.length);
        byte[] sha1hash = md.digest();
        return AVUtils.convertToHex(sha1hash);
    }

    public static class ObjectParser {
        boolean topObject;
        boolean instanceValue;
        boolean withDate;
        boolean withACL;
        boolean withPointerValue;

        public ObjectParser asTopObject(boolean topObject) {
            this.topObject = topObject;
            return this;
        }

        public ObjectParser withInstanceValue(boolean withInstanceValue) {
            this.instanceValue = withInstanceValue;
            return this;
        }

        public ObjectParser withDate(boolean withDate) {
            this.withDate = withDate;
            return this;
        }

        public ObjectParser withACL(boolean withACL) {
            this.withACL = withACL;
            return this;
        }

        public ObjectParser withPointerValue(boolean withPointerValue) {
            this.withPointerValue = withPointerValue;
            return this;
        }

        public Object parse(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Map) {
                return AVUtils.getParsedMap((Map)object, this.topObject, this.instanceValue, this.withDate, this.withPointerValue);
            }
            if (object instanceof Collection) {
                return AVUtils.getParsedList((Collection)object, this.topObject, this.instanceValue, this.withDate, this.withPointerValue);
            }
            if (object instanceof AVObject) {
                if (!this.topObject) {
                    return AVUtils.mapFromPointerObject((AVObject)object, this.withPointerValue);
                }
                if (!this.instanceValue) {
                    return AVUtils.mapFromAVObject((AVObject)object, true, false, this.withDate, this.withPointerValue);
                }
                Map map = AVUtils.mapFromAVObject((AVObject)object, true, true, false, this.withPointerValue);
                if (this.withACL && ((AVObject)object).acl != null) {
                    map.putAll(AVUtils.getParsedMap(((AVObject)object).acl.getACLMap()));
                }
                return map;
            }
            if (object instanceof AVGeoPoint) {
                return AVUtils.mapFromGeoPoint((AVGeoPoint)object);
            }
            if (object instanceof Date) {
                return AVUtils.mapFromDate((Date)object);
            }
            if (object instanceof byte[]) {
                return AVUtils.mapFromByteArray((byte[])object);
            }
            if (object instanceof AVFile) {
                return ((AVFile)object).toMap();
            }
            if (object instanceof JSONObject) {
                return JSON.parse((String)object.toString());
            }
            if (object instanceof JSONArray) {
                return JSON.parse((String)object.toString());
            }
            return object;
        }
    }
}

