/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Parcel;
import android.os.Parcelable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVClassName;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRelation;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVStatusQuery;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.CountCallback;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ObjectValueFilter;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RefreshCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.StatusCallback;
import com.avos.avoscloud.StatusListCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@AVClassName(value="_Status")
@JSONType(ignores={"acl", "updatedAt", "uuid"})
public class AVStatus
extends AVObject {
    private final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    public static final String IMAGE_TAG = "image";
    public static final String MESSAGE_TAG = "message";
    private static final String AV_CLASS_NAME = "_FeedStatus";
    private static int DEFAULT_COUNT = 100;
    @Deprecated
    public static final String INBOX_TIMELINE = "default";
    @Deprecated
    public static final String INBOX_PRIVATE = "private";
    public static final String STATUS_END_POINT = "statuses";
    private static final String UNREAD_TAG = "unread";
    private long messageId = 0L;
    private String createdAt;
    private String inboxType;
    private AVObject source = null;
    private AVQuery query = null;
    static List<String> ignoreList = Arrays.asList("objectId", "updatedAt", "createdAt", "inboxType", "messageId");
    public static final transient Parcelable.Creator<AVStatus> CREATOR;

    static String userClassName() {
        return AVPowerfulUtils.getAVClassName(AVStatus.class.getSimpleName());
    }

    public static AVStatus createStatus(String imageUrl, String message) {
        AVStatus status = new AVStatus();
        status.setImageUrl(imageUrl);
        status.setMessage(message);
        return status;
    }

    public static AVStatus createStatusWithData(Map<String, Object> data) {
        AVStatus status = new AVStatus();
        status.setData(data);
        return status;
    }

    public AVStatus() {
    }

    private static boolean checkCurrentUser(AVCallback callback) {
        if (AVUser.getCurrentUser() == null) {
            if (callback != null) {
                callback.internalDone(null, AVErrorUtils.sessionMissingException());
            }
            return false;
        }
        return true;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public Date getCreatedAt() {
        return AVUtils.dateFromString(this.createdAt);
    }

    @Override
    protected void setCreatedAt(String date) {
        this.createdAt = date;
    }

    public void setImageUrl(String url) {
        if (url != null) {
            this.dataMap.put(IMAGE_TAG, url);
        }
    }

    public String getImageUrl() {
        Object obj = this.dataMap.get(IMAGE_TAG);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public AVUser getSource() {
        return (AVUser)this.source;
    }

    public void setSource(AVObject source) {
        this.source = source;
    }

    public void setInboxType(String type) {
        if (type != null) {
            this.inboxType = type;
        }
    }

    public void setQuery(AVQuery query) {
        this.query = query;
    }

    public void setMessage(String message) {
        if (message != null) {
            this.dataMap.put(MESSAGE_TAG, message);
        }
    }

    public String getMessage() {
        Object obj = this.dataMap.get(MESSAGE_TAG);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public void setData(Map<String, Object> data) {
        this.dataMap.putAll(data);
    }

    public Map<String, Object> getData() {
        return this.dataMap;
    }

    @Override
    public void put(String key, Object value) {
        this.dataMap.put(key, value);
    }

    @Override
    protected void put(String key, Object value, boolean pending) {
        if ("inboxType".equals(key)) {
            if (value instanceof String) {
                this.inboxType = (String)value;
            }
        } else if ("messageId".equals(key)) {
            if (value instanceof Number) {
                this.messageId = ((Number)value).longValue();
            }
        } else if ("source".equals(key)) {
            if (value instanceof AVObject) {
                this.source = (AVObject)value;
            }
        } else {
            this.dataMap.put(key, value);
        }
    }

    @Override
    public void remove(String key) {
        this.dataMap.remove(key);
    }

    public long getMessageId() {
        return this.messageId;
    }

    protected void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getInboxType() {
        return this.inboxType;
    }

    public void deleteStatusInBackground(DeleteCallback callback) {
        AVStatus.deleteStatusWithIDInBackgroud(this.objectId, callback);
    }

    public static void deleteStatusWithIDInBackgroud(String statusId, DeleteCallback callback) {
        AVStatus.deleteStatusWithId(false, statusId, callback);
    }

    public static void deleteStatusWithID(String statusId) throws AVException {
        AVStatus.deleteStatusWithId(true, statusId, new DeleteCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    private static void deleteStatusWithId(boolean sync, String statusId, final DeleteCallback callback) {
        if (!AVStatus.checkCurrentUser(null)) {
            if (callback != null) {
                callback.internalDone(AVErrorUtils.sessionMissingException());
            }
            return;
        }
        if (AVUtils.isBlankString(statusId)) {
            if (callback != null) {
                callback.internalDone(AVErrorUtils.invalidObjectIdException());
            }
            return;
        }
        String endPoint = String.format("statuses/%s", statusId);
        PaasClient.storageInstance().deleteObject(endPoint, sync, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (callback != null) {
                    callback.internalDone(null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(AVErrorUtils.createException(error, content));
                }
            }
        }, statusId, null);
    }

    public static void deleteInboxStatus(long messageId, String inboxType, AVUser owner) throws Exception {
        AVStatus.deleteInboxStatus(true, messageId, inboxType, owner, new DeleteCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void deleteInboxStatusInBackground(long messageId, String inboxType, AVUser owner, DeleteCallback callback) {
        AVStatus.deleteInboxStatus(false, messageId, inboxType, owner, callback);
    }

    private static void deleteInboxStatus(boolean sync, long statusId, String inboxType, AVUser owner, final DeleteCallback callback) {
        String ownerString = null;
        if (owner == null) {
            if (callback != null) {
                callback.internalDone(new AVException(211, "Owner can't be null"));
            }
            return;
        }
        String ownerId = owner.getObjectId();
        Map<String, Object> ownerMap = AVUtils.mapFromUserObjectId(ownerId);
        ownerString = JSON.toJSONString(ownerMap);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messageId", String.valueOf(statusId));
        params.put("inboxType", inboxType);
        params.put("owner", ownerString);
        String endPoint = AVUtils.getEncodeUrl("subscribe/statuses/inbox", params);
        PaasClient.storageInstance().deleteObject(endPoint, sync, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (callback != null) {
                    callback.internalDone(null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    @Deprecated
    public static void getStatuses(long skip, long limit, StatusListCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        String userId = AVUser.getCurrentUser().getObjectId();
        Map<String, String> params = AVStatus.statusQueryMap(userId, skip, limit, 0L, null, null, true, false);
        AVStatus.getStatusImpl(STATUS_END_POINT, params, callback);
    }

    @Deprecated
    static Map<String, String> sourceQueryMap(String ownerId, long skip, long count) {
        HashMap<String, Map<String, Object>> source = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            source.put("source", AVUtils.mapFromUserObjectId(ownerId));
            result.put("where", JSON.toJSONString(source));
            result.put("include", "source");
            if (skip > 0L) {
                result.put("skip", Long.toString(skip));
            }
            if (count > 0L) {
                result.put("count", Long.toString(count));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public static void getStatusesFromCurrentUserWithType(String type, long skip, long limit, StatusListCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        Map<String, String> params = AVStatus.sourceQueryMap(AVUser.getCurrentUser().getObjectId(), skip, limit);
        AVStatus.getStatusImpl(STATUS_END_POINT, params, callback);
    }

    @Deprecated
    public static void getStatusesFromUser(String userObejctId, long skip, long limit, StatusListCallback callback) {
        if (AVUtils.isBlankString(userObejctId)) {
            if (callback != null) {
                callback.internalDone(null, AVErrorUtils.invalidObjectIdException());
            }
            return;
        }
        Map<String, String> params = AVStatus.sourceQueryMap(userObejctId, skip, limit);
        AVStatus.getStatusImpl(STATUS_END_POINT, params, callback);
    }

    @Deprecated
    static Map<String, String> statusQueryMap(String ownerId, long skip, long limit, long maxId, String inboxType, Map<String, Object> where, boolean includeSource, boolean count) {
        Map<String, Object> owner = AVUtils.mapFromUserObjectId(ownerId);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("owner", JSON.toJSONString(owner));
            if (skip > 0L) {
                result.put("skip", Long.toString(skip));
            }
            if (limit > 0L) {
                result.put("limit", Long.toString(limit));
            }
            if (maxId > 0L) {
                result.put("maxId", Long.toString(maxId));
            }
            if (!AVUtils.isBlankString(inboxType)) {
                result.put("inboxType", inboxType);
            }
            if (where != null) {
                result.put("where", JSON.toJSONString(where));
            }
            if (includeSource) {
                result.put("include", "source");
            }
            if (count) {
                result.put("count", Long.toString(1L));
            }
        }
        catch (Exception exception) {
            LogUtil.log.e(exception.toString());
        }
        return result;
    }

    static Map<String, String> getStatusQueryMap(String ownerId, long sinceId, long limit, long maxId, String inboxType, Map<String, Object> where, boolean includeSource, boolean count) {
        Map<String, Object> owner = AVUtils.mapFromUserObjectId(ownerId);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("owner", JSON.toJSONString(owner));
            if (sinceId > 0L) {
                result.put("sinceId", Long.toString(sinceId));
            }
            if (limit > 0L) {
                result.put("limit", Long.toString(limit));
            }
            if (maxId > 0L) {
                result.put("maxId", Long.toString(maxId));
            }
            if (!AVUtils.isBlankString(inboxType)) {
                result.put("inboxType", inboxType);
            }
            if (where != null) {
                result.put("where", JSON.toJSONString(where));
            }
            if (includeSource) {
                result.put("include", "source");
            }
            if (count) {
                result.put("count", Long.toString(1L));
            }
        }
        catch (Exception exception) {
            LogUtil.log.e(exception.toString());
        }
        return result;
    }

    static List<AVStatus> processStatusResultList(String content) {
        if (AVUtils.isBlankContent(content)) {
            return Collections.emptyList();
        }
        com.alibaba.fastjson.JSONObject results = null;
        try {
            results = JSON.parseObject((String)content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == results) {
            return Collections.emptyList();
        }
        com.alibaba.fastjson.JSONArray array = results.getJSONArray("results");
        LinkedList<AVStatus> result = new LinkedList<AVStatus>();
        for (Object item : array) {
            AVStatus object = new AVStatus();
            AVStatus.processStatusFromObject(item, object);
            result.add(object);
        }
        return result;
    }

    static void processStatus(String content, AVStatus status) {
        try {
            com.alibaba.fastjson.JSONObject object = JSON.parseObject((String)content);
            AVStatus.processStatusFromObject(object, status);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void processStatusFromObject(Object object, AVStatus status) {
        com.alibaba.fastjson.JSONObject jsonObject = (com.alibaba.fastjson.JSONObject)object;
        status.objectId = AVUtils.getJSONString(jsonObject, "objectId", status.objectId);
        status.messageId = AVUtils.getJSONInteger(jsonObject, "messageId", status.messageId);
        status.inboxType = AVUtils.getJSONString(jsonObject, "inboxType", status.inboxType);
        status.createdAt = AVUtils.getJSONString(jsonObject, "createdAt", status.createdAt);
        status.setImageUrl(AVUtils.getJSONString(jsonObject, IMAGE_TAG, status.getImageUrl()));
        status.setMessage(AVUtils.getJSONString(jsonObject, MESSAGE_TAG, status.getMessage()));
        String sourceString = AVUtils.getJSONString(jsonObject, "source", "");
        if (!AVUtils.isBlankString(sourceString)) {
            try {
                com.alibaba.fastjson.JSONObject map = JSON.parseObject((String)sourceString);
                status.source = AVUtils.parseObjectFromMap((Map<String, Object>)map);
            }
            catch (Exception map) {
                // empty catch block
            }
        }
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            if (ignoreList.contains(entry.getKey().toString()) || entry.getValue() == null) continue;
            status.dataMap.put(entry.getKey().toString(), AVUtils.getParsedObject(entry.getValue()));
        }
    }

    static void getStatusImpl(String endPoint, Map<String, String> map, final StatusListCallback callback) {
        AVRequestParams params = null;
        if (map != null) {
            params = new AVRequestParams(map);
        }
        PaasClient.storageInstance().getObject(endPoint, params, false, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                List<AVStatus> result = AVStatus.processStatusResultList(content);
                if (callback != null) {
                    callback.internalDone(result, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    static int processStatusCount(String content) {
        try {
            com.alibaba.fastjson.JSONObject data = JSON.parseObject((String)content);
            return data.getInteger(UNREAD_TAG);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static void getStatusCountImpl(String endPoint, Map<String, String> map, final CountCallback callback) {
        PaasClient.storageInstance().getObject(endPoint, new AVRequestParams(map), false, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                int count = AVStatus.processStatusCount(content);
                if (callback != null) {
                    callback.internalDone(count, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(0, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    @Deprecated
    public static void getInboxStatusesInBackground(long skip, long limit, StatusListCallback callback) {
        AVStatus.getInboxStatusesWithInboxType(skip, limit, INBOX_TYPE.TIMELINE.toString(), callback);
    }

    @Deprecated
    public static void getInboxStatusesWithInboxType(long skip, long limit, String inboxType, StatusListCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        String userId = AVUser.getCurrentUser().getObjectId();
        Map<String, String> map = AVStatus.statusQueryMap(userId, skip, limit, 0L, inboxType, null, true, false);
        AVStatus.getStatusImpl("subscribe/statuses", map, callback);
    }

    public static void getUnreadStatusesCountInBackground(String inboxType, CountCallback callback) {
        if (!AVStatus.checkCurrentUser(null)) {
            if (callback != null) {
                callback.internalDone(0, AVErrorUtils.sessionMissingException());
            }
            return;
        }
        String userId = AVUser.getCurrentUser().getObjectId();
        Map<String, String> map = AVStatus.getStatusQueryMap(userId, 0L, 0L, 0L, inboxType, null, true, true);
        AVStatus.getStatusCountImpl("subscribe/statuses/count", map, callback);
    }

    @Deprecated
    public static void getInboxUnreadStatusesCountInBackgroud(CountCallback callback) {
        AVStatus.getInboxUnreadStatusesCountWithInboxTypeInBackgroud(0L, 0L, INBOX_TYPE.TIMELINE.toString(), callback);
    }

    @Deprecated
    public static void getInboxUnreadStatusesCountWithInboxTypeInBackgroud(long sid, long count, String inboxType, CountCallback callback) {
        if (!AVStatus.checkCurrentUser(null)) {
            if (callback != null) {
                callback.internalDone(0, AVErrorUtils.sessionMissingException());
            }
            return;
        }
        String userId = AVUser.getCurrentUser().getObjectId();
        Map<String, String> map = AVStatus.statusQueryMap(userId, sid, count, 0L, inboxType, null, true, true);
        AVStatus.getStatusCountImpl("subscribe/statuses/count", map, callback);
    }

    @Deprecated
    public static void getInboxPrivteStatuses(long sid, long count, StatusListCallback callback) {
        AVStatus.getInboxStatusesWithInboxType(sid, count, INBOX_TYPE.PRIVATE.toString(), callback);
    }

    static boolean checkStatusId(String statusId, StatusCallback callback) {
        if (AVUtils.isBlankString(statusId)) {
            if (callback != null) {
                callback.internalDone(null, AVErrorUtils.invalidObjectIdException());
            }
            return false;
        }
        return true;
    }

    public static void getStatusWithIdInBackgroud(String statusId, StatusCallback callback) {
        AVStatus.getStatusWithIdInBackground(false, statusId, callback);
    }

    public static AVStatus getStatusWithId(String statusId) throws AVException {
        final AVStatus[] result = new AVStatus[]{null};
        AVStatus.getStatusWithIdInBackground(true, statusId, new StatusCallback(){

            @Override
            public void done(AVStatus statusObject, AVException parseException) {
                if (parseException != null) {
                    AVExceptionHolder.add(parseException);
                } else {
                    result[0] = statusObject;
                }
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return result[0];
    }

    private static void getStatusWithIdInBackground(boolean sync, String statusId, final StatusCallback callback) {
        if (!AVStatus.checkStatusId(statusId, callback)) {
            return;
        }
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        String userId = AVUser.getCurrentUser().getObjectId();
        String endPoint = String.format("statuses/%s", statusId);
        Map<String, String> map = AVStatus.statusQueryMap(userId, 0L, 0L, 0L, null, null, true, false);
        AVRequestParams params = new AVRequestParams(map);
        PaasClient.storageInstance().getObject(endPoint, params, sync, null, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                AVStatus status = new AVStatus();
                AVStatus.processStatus(content, status);
                if (callback != null) {
                    callback.internalDone(status, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    static void postStatusImpl(final AVStatus status, Map<String, Object> map, final SaveCallback callback, boolean sync) {
        String postData = AVUtils.restfulServerData(map);
        PaasClient.storageInstance().postObject(STATUS_END_POINT, postData, sync, false, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                AVStatus.processStatus(content, status);
                if (callback != null) {
                    callback.internalDone(null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(AVErrorUtils.createException(error, content));
                }
            }
        }, status.getObjectId(), null);
    }

    static Map<String, Object> statusBody(AVStatus status, String inboxType, Map<String, Object> queryBody) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.putAll(status.dataMap);
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (status.source != null) {
            data.put("source", AVUtils.getParsedObject(status.source));
        } else {
            data.put("source", AVUtils.getParsedObject(AVUser.getCurrentUser()));
        }
        body.put("data", data);
        body.put("inboxType", inboxType);
        body.put("query", queryBody);
        return body;
    }

    Map<String, Object> myQueryParameters(AVQuery query) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (query.getWhere().keySet().size() > 0) {
            parameters.put("where", AVUtils.getParsedMap(query.getWhere()));
        }
        if (query.getLimit() > 0) {
            parameters.put("limit", Integer.toString(query.getLimit()));
        }
        if (query.getSkip() > 0) {
            parameters.put("skip", Integer.toString(query.getSkip()));
        }
        if (query.getOrder() != null && query.getOrder().length() > 0) {
            parameters.put("order", query.getOrder());
        }
        if (query.getInclude() != null && query.getInclude().size() > 0) {
            String value = AVUtils.joinCollection(query.getInclude(), ",");
            parameters.put("include", value);
        }
        if (query.getSelectedKeys() != null && query.getSelectedKeys().size() > 0) {
            String keys = AVUtils.joinCollection(query.getSelectedKeys(), ",");
            parameters.put("keys", keys);
        }
        return parameters;
    }

    @Deprecated
    public void sendInBackgroundWithBlock(SaveCallback callback) {
        this.sendInBackground(callback);
    }

    public void sendInBackground(SaveCallback callback) {
        this.sendInBackground(false, callback);
    }

    private void sendInBackground(boolean sync, SaveCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        if (this.query == null) {
            AVStatus.sendStatusToFollowersInBackgroud(sync, this, callback);
            return;
        }
        HashMap<String, Object> queryBody = new HashMap<String, Object>();
        Map<String, Object> parameters = this.myQueryParameters(this.query);
        queryBody.putAll(parameters);
        queryBody.put("className", this.query.getClassName());
        Map<String, Object> body = AVStatus.statusBody(this, AVUtils.isBlankString(this.inboxType) ? INBOX_TYPE.TIMELINE.toString() : this.inboxType, queryBody);
        AVStatus.postStatusImpl(this, body, callback, sync);
    }

    public void send() throws AVException {
        this.sendInBackground(true, new SaveCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void sendStatusToFollowersInBackgroud(AVStatus status, SaveCallback callback) {
        AVStatus.sendStatusToFollowersInBackgroud(false, status, callback);
    }

    private static void sendStatusToFollowersInBackgroud(boolean sync, AVStatus status, SaveCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        HashMap<String, Object> queryBody = new HashMap<String, Object>();
        queryBody.put("className", "_Follower");
        queryBody.put("keys", "follower");
        queryBody.put("where", AVStatus.currentUserBody());
        Map<String, Object> body = AVStatus.statusBody(status, AVUtils.isBlankString(status.inboxType) ? INBOX_TYPE.TIMELINE.toString() : status.inboxType, queryBody);
        AVStatus.postStatusImpl(status, body, callback, sync);
    }

    public static void sendPrivateStatusInBackgroud(AVStatus status, String receiverObjectId, SaveCallback callback) {
        AVStatus.sendPrivateStatusInBackgroud(false, status, receiverObjectId, callback);
    }

    public static void sendPrivateStatus(AVStatus status, String receiverObjectId) throws AVException {
        AVStatus.sendPrivateStatusInBackgroud(true, status, receiverObjectId, new SaveCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    private static void sendPrivateStatusInBackgroud(boolean sync, AVStatus status, String receiverObjectId, SaveCallback callback) {
        if (!AVStatus.checkCurrentUser(callback)) {
            return;
        }
        HashMap<String, Object> queryBody = new HashMap<String, Object>();
        queryBody.put("className", "_User");
        HashMap<String, String> whereBody = new HashMap<String, String>();
        whereBody.put("objectId", receiverObjectId);
        queryBody.put("where", whereBody);
        Map<String, Object> body = AVStatus.statusBody(status, INBOX_TYPE.PRIVATE.toString(), queryBody);
        AVStatus.postStatusImpl(status, body, callback, sync);
    }

    private static Map<String, Object> currentUserBody() {
        HashMap<String, Object> userBody = new HashMap<String, Object>();
        Map<String, Object> object = AVUtils.mapFromPointerObject(AVUser.getCurrentUser());
        userBody.put("user", object);
        return userBody;
    }

    public static AVStatusQuery statusQuery(AVUser owner) throws AVException {
        AVStatusQuery query = new AVStatusQuery();
        query.setSelfQuery(true);
        query.whereEqualTo("source", owner);
        query.setExternalQueryPath(STATUS_END_POINT);
        return query;
    }

    public static AVStatusQuery inboxQuery(AVUser owner, String inBoxType) {
        AVStatusQuery query = new AVStatusQuery();
        query.setInboxType(inBoxType);
        query.setOwner(owner);
        query.setExternalQueryPath("subscribe/statuses");
        return query;
    }

    @Override
    @Deprecated
    public void add(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAll(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addAllUnique(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void addUnique(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean containsKey(String k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws AVException {
        AVStatus.deleteStatusWithId(true, this.getObjectId(), new DeleteCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    @Override
    @Deprecated
    public void deleteEventually(DeleteCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void deleteEventually() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteInBackground() {
        this.deleteStatusInBackground(null);
    }

    public AVObject toObject() {
        return AVObject.createWithoutData("_Status", this.objectId);
    }

    @Override
    public boolean equals(Object obj) {
        if (AVUtils.isBlankString(this.objectId)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AVStatus other = (AVStatus)obj;
        return !(this.objectId == null ? other.objectId != null : !this.objectId.equals(other.objectId));
    }

    @Override
    @Deprecated
    public AVObject fetch() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetch(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetchIfNeeded() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVObject fetchIfNeeded(String includedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fetchIfNeededInBackground(GetCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fetchIfNeededInBackground(String includedkeys, GetCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "AVStatus [, objectId=" + this.objectId + ", createdAt=" + this.createdAt + ", data=" + this.dataMap + "]";
    }

    @Override
    @Deprecated
    public boolean isFetchWhenSave() {
        return false;
    }

    @Override
    @Deprecated
    public void setFetchWhenSave(boolean fetchWhenSave) {
    }

    @Override
    @Deprecated
    public String getUuid() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void deleteInBackground(DeleteCallback callback) {
        super.deleteInBackground(callback);
    }

    @Override
    @Deprecated
    public void fetchInBackground(GetCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void fetchInBackground(String includeKeys, GetCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(String key) {
        return this.dataMap.get(key);
    }

    @Override
    @Deprecated
    public AVACL getACL() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean getBoolean(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public byte[] getBytes(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Date getDate(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public double getDouble(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getInt(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public JSONArray getJSONArray(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public JSONObject getJSONObject(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List getList(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public long getLong(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <V> Map<String, V> getMap(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Number getNumber(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <T extends AVFile> T getAVFile(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AVGeoPoint getAVGeoPoint(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends AVObject> T getAVObject(String key) {
        return (T)((AVObject)this.get(key));
    }

    @Override
    @Deprecated
    public <T extends AVUser> T getAVUser(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <T extends AVObject> AVRelation<T> getRelation(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getString(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Date getUpdatedAt() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean has(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean hasSameId(AVObject other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void increment(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void increment(String key, Number amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh() throws AVException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refresh(String includeKeys) throws AVException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refreshInBackground(RefreshCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void refreshInBackground(String includeKeys, RefreshCallback<AVObject> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void removeAll(String key, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void save() throws AVException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveEventually() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveEventually(SaveCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveInBackground() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveInBackground(SaveCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setACL(AVACL acl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int i) {
        out.writeString(this.inboxType);
        out.writeString(this.createdAt);
        out.writeString(this.objectId);
        out.writeString(JSON.toJSONString(this.dataMap, (SerializeFilter)new ObjectValueFilter(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteClassName}));
        out.writeString(JSON.toJSONString((Object)this.source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public AVStatus(Parcel in) {
        this.inboxType = in.readString();
        this.createdAt = in.readString();
        this.objectId = in.readString();
        Map dataMap = (Map)JSON.parse((String)in.readString());
        if (dataMap != null && !dataMap.isEmpty()) {
            this.dataMap.putAll(dataMap);
        }
        this.source = (AVObject)JSON.parse((String)in.readString());
    }

    static {
        AVPowerfulUtils.createSettings(AVStatus.class.getSimpleName(), STATUS_END_POINT, "_Status");
        AVPowerfulUtils.createSettings("_Status", STATUS_END_POINT, "_Status");
        AVObject.registerSubclass(AVStatus.class);
        CREATOR = new Parcelable.Creator(){

            public AVStatus createFromParcel(Parcel parcel) {
                return new AVStatus(parcel);
            }

            public AVStatus[] newArray(int i) {
                return new AVStatus[i];
            }
        };
    }

    public static enum INBOX_TYPE {
        TIMELINE("default"),
        PRIVATE("private");

        private String type;

        private INBOX_TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

