/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.os.Parcel;
import android.os.Parcelable;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVClassName;
import com.avos.avoscloud.AVDeleteOption;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVObjectDeserializer;
import com.avos.avoscloud.AVObjectSerializer;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRelation;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVSaveOption;
import com.avos.avoscloud.AVStatus;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.ObjectValueFilter;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RefreshCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.AddOp;
import com.avos.avoscloud.ops.AddRelationOp;
import com.avos.avoscloud.ops.AddUniqueOp;
import com.avos.avoscloud.ops.CollectionOp;
import com.avos.avoscloud.ops.CompoundOp;
import com.avos.avoscloud.ops.DeleteOp;
import com.avos.avoscloud.ops.IncrementOp;
import com.avos.avoscloud.ops.RemoveOp;
import com.avos.avoscloud.ops.RemoveRelationOp;
import com.avos.avoscloud.ops.SetOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class AVObject
implements Parcelable {
    public static final String CREATED_AT = "createdAt";
    public static final String UPDATED_AT = "updatedAt";
    public static final String OBJECT_ID = "objectId";
    protected boolean requestStatistic = true;
    private static final String LOGTAG;
    static final int UUID_LEN;
    private String className;
    protected String objectId;
    protected String updatedAt;
    protected String createdAt;
    private String uuid;
    private volatile boolean fetchWhenSave = false;
    @JSONField
    private boolean isDataReady;
    protected transient AVACL acl;
    private volatile transient boolean running;
    Map<String, Object> serverData;
    Map<String, AVOp> operationQueue;
    Map<String, Object> instanceData;
    Map<String, AVOp> tempDataForServerSaving;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private Set<Hook> ignoreHooks;
    private static final Map<String, Class<? extends AVObject>> SUB_CLASSES_MAP;
    private static final Map<Class<? extends AVObject>, String> SUB_CLASSES_REVERSE_MAP;
    public static final Set<String> INVALID_KEYS;
    public static final transient Parcelable.Creator CREATOR;

    public AVObject() {
        this.serverData = new HashMap<String, Object>();
        this.operationQueue = new HashMap<String, AVOp>();
        this.instanceData = new HashMap<String, Object>();
        this.tempDataForServerSaving = new HashMap<String, AVOp>();
        this.className = AVObject.getSubClassName(this.getClass());
        this.ignoreHooks = new TreeSet<Hook>();
        this.init();
    }

    public String toString() {
        return JSON.toJSONString((Object)this, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect});
    }

    public JSONObject toJSONObject() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.instanceData.entrySet()) {
            dataMap.put(entry.getKey(), AVObject.parseObject(entry.getValue()));
        }
        dataMap.put(OBJECT_ID, this.objectId);
        dataMap.put(CREATED_AT, this.createdAt);
        dataMap.put(UPDATED_AT, this.updatedAt);
        dataMap.put("className", this.className);
        return new JSONObject(dataMap);
    }

    private static Object parseObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return AVObject.getParsedMap((Map)object);
        }
        if (object instanceof Collection) {
            return AVObject.getParsedList((Collection)object);
        }
        if (object instanceof AVObject) {
            return ((AVObject)object).toJSONObject();
        }
        if (object instanceof AVGeoPoint) {
            return AVUtils.mapFromGeoPoint((AVGeoPoint)object);
        }
        if (object instanceof Date) {
            return AVUtils.mapFromDate((Date)object);
        }
        if (object instanceof byte[]) {
            return AVUtils.mapFromByteArray((byte[])object);
        }
        if (object instanceof AVFile) {
            return ((AVFile)object).toJSONObject();
        }
        if (object instanceof JSONObject) {
            return JSON.parse((String)object.toString());
        }
        if (object instanceof JSONArray) {
            return JSON.parse((String)object.toString());
        }
        return object;
    }

    private static List getParsedList(Collection list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object o : list) {
            newList.add(AVObject.parseObject(o));
        }
        return newList;
    }

    private static Map<String, Object> getParsedMap(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            newMap.put(key, AVObject.parseObject(o));
        }
        return newMap;
    }

    Map<String, Object> getServerData() {
        return this.serverData;
    }

    void setServerData(HashMap<String, Object> serverData) {
        this.serverData = serverData;
    }

    Map<String, AVOp> getOperationQueue() {
        return this.operationQueue;
    }

    void setOperationQueue(HashMap<String, AVOp> operationQueue) {
        this.operationQueue = operationQueue;
    }

    boolean isDataReady() {
        return this.isDataReady;
    }

    void setDataReady(boolean isDataReady) {
        this.isDataReady = isDataReady;
    }

    void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isFetchWhenSave() {
        return this.fetchWhenSave;
    }

    public void setFetchWhenSave(boolean fetchWhenSave) {
        this.fetchWhenSave = fetchWhenSave;
    }

    public String getUuid() {
        if (AVUtils.isBlankString(this.uuid)) {
            this.uuid = UUID.randomUUID().toString().toLowerCase();
        }
        return this.uuid;
    }

    static Class<? extends AVObject> getSubClass(String className) {
        return SUB_CLASSES_MAP.get(className);
    }

    static String getSubClassName(Class<? extends AVObject> clazz) {
        if (AVUser.class.isAssignableFrom(clazz)) {
            return AVUser.userClassName();
        }
        if (AVRole.class.isAssignableFrom(clazz)) {
            return "_Role";
        }
        if (AVStatus.class.isAssignableFrom(clazz)) {
            return AVStatus.userClassName();
        }
        return SUB_CLASSES_REVERSE_MAP.get(clazz);
    }

    public static <T extends AVObject> void registerSubclass(Class<T> clazz) {
        AVClassName parseClassName = clazz.getAnnotation(AVClassName.class);
        if (parseClassName == null) {
            throw new IllegalArgumentException("The class is not annotated by @AVClassName");
        }
        String className = parseClassName.value();
        AVUtils.checkClassName(className);
        ParserConfig.getGlobalInstance().putDeserializer(clazz, (ObjectDeserializer)AVObjectDeserializer.instance);
        SerializeConfig.getGlobalInstance().put(clazz, (Object)AVObjectSerializer.instance);
        SUB_CLASSES_MAP.put(className, clazz);
        SUB_CLASSES_REVERSE_MAP.put(clazz, className);
    }

    public AVObject(String theClassName) {
        this();
        AVUtils.checkClassName(theClassName);
        this.className = theClassName;
    }

    private void init() {
        this.objectId = "";
        this.isDataReady = false;
        if (PaasClient.storageInstance().getDefaultACL() != null) {
            this.acl = new AVACL(PaasClient.storageInstance().getDefaultACL());
        }
        this.running = false;
    }

    public void add(String key, Object value) {
        this.addObjectToArray(key, value, false);
    }

    public void addAll(String key, Collection<?> values) {
        for (Object item : values) {
            this.addObjectToArray(key, item, false);
        }
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(AVObject.getSubClassName(clazz), clazz);
    }

    public void addAllUnique(String key, Collection<?> values) {
        for (Object item : values) {
            this.addObjectToArray(key, item, true);
        }
    }

    public void addUnique(String key, Object value) {
        this.addObjectToArray(key, value, true);
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public static AVObject create(String className) {
        return new AVObject(className);
    }

    public static AVObject parseAVObject(String avObjectString) throws Exception {
        AVObject object = (AVObject)JSON.parse((String)avObjectString);
        if (object instanceof AVObject && !AVObject.class.equals(object.getClass())) {
            object.rebuildInstanceData();
        }
        return object;
    }

    public static AVObject createWithoutData(String className, String objectId) {
        AVObject object = new AVObject(className);
        object.setObjectId(objectId);
        return object;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public static <T extends AVObject> T createWithoutData(Class<T> clazz, String objectId) throws AVException {
        try {
            AVObject result = (AVObject)clazz.newInstance();
            result.setClassName(AVObject.getSubClassName(clazz));
            result.setObjectId(objectId);
            return (T)result;
        }
        catch (Exception e) {
            throw new AVException("Create subclass instance failed.", e);
        }
    }

    public void delete() throws AVException {
        this.delete(null);
    }

    public void delete(AVDeleteOption option) throws AVException {
        this.delete(true, false, option, new DeleteCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void deleteAll(Collection<? extends AVObject> objects) throws AVException {
        AVObject.deleteAll(true, false, objects, new DeleteCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void deleteAllInBackground(Collection<? extends AVObject> objects, DeleteCallback deleteCallback) {
        AVObject.deleteAll(false, false, objects, deleteCallback);
    }

    private static void deleteAll(boolean sync, boolean isEventually, Collection<? extends AVObject> objects, final DeleteCallback callback) {
        if (objects == null || objects.isEmpty()) {
            callback.internalDone(null, null);
            return;
        }
        if (isEventually) {
            for (AVObject aVObject : objects) {
                if (aVObject == null) continue;
                aVObject.deleteEventually(callback);
            }
        } else {
            String className = null;
            for (AVObject aVObject : objects) {
                if (AVUtils.isBlankString(aVObject.getClassName()) || AVUtils.isBlankString(aVObject.objectId)) {
                    throw new IllegalArgumentException("Invalid AVObject, the class name or objectId is blank.");
                }
                if (className == null) {
                    className = aVObject.getClassName();
                    continue;
                }
                if (className.equals(aVObject.getClassName())) continue;
                throw new IllegalArgumentException("The objects class name must be the same.");
            }
            HashMap<Set<Hook>, List<AVObject>> hashMap = new HashMap<Set<Hook>, List<AVObject>>();
            for (AVObject aVObject : objects) {
                ArrayList<AVObject> objs = (ArrayList<AVObject>)hashMap.get(aVObject.ignoreHooks);
                if (objs == null) {
                    objs = new ArrayList<AVObject>();
                    hashMap.put(aVObject.ignoreHooks, objs);
                }
                objs.add(aVObject);
            }
            PaasClient.storageInstance().postBatchObject(AVObject.getBatchDeleteRequest(hashMap), sync, null, new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    AVException[] exceptions;
                    if (callback == null) {
                        return;
                    }
                    for (AVException avException : exceptions = AVErrorUtils.createExceptions(content)) {
                        if (avException == null) continue;
                        callback.internalDone(null, avException);
                        return;
                    }
                    callback.internalDone(null, null);
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    if (callback != null) {
                        callback.internalDone(null, AVErrorUtils.createException(error, content));
                    }
                }
            });
        }
    }

    private static List<Object> getBatchDeleteRequest(Map<Set<Hook>, List<AVObject>> objectGroups) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Set<Hook>, List<AVObject>> entry : objectGroups.entrySet()) {
            boolean wasFirst = true;
            Map<Object, Object> ignoreHookParams = Collections.emptyMap();
            StringBuilder sb = new StringBuilder();
            for (AVObject object : entry.getValue()) {
                if (wasFirst) {
                    sb.append(AVPowerfulUtils.getBatchEndpoint(PaasClient.storageInstance().getApiVersion(), object));
                    wasFirst = false;
                    ignoreHookParams = object.getIgnoreHookParams();
                    continue;
                }
                sb.append(",").append(object.getObjectId());
            }
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("method", "DELETE");
            request.put("path", sb.toString());
            request.put("body", ignoreHookParams);
            result.add(request);
        }
        return result;
    }

    public void deleteEventually() {
        this.deleteEventually(null);
    }

    public void deleteEventually(DeleteCallback callback) {
        this.delete(false, true, null, callback);
    }

    public void deleteInBackground() {
        this.deleteInBackground(null, null);
    }

    public void deleteInBackground(AVDeleteOption option) {
        this.deleteInBackground(option, null);
    }

    public void deleteInBackground(AVDeleteOption option, DeleteCallback callback) {
        this.delete(false, false, option, callback);
    }

    public void deleteInBackground(DeleteCallback callback) {
        this.delete(false, false, null, callback);
    }

    private void delete(boolean sync, boolean isEventually, AVDeleteOption option, DeleteCallback callback) {
        final DeleteCallback internalCallback = callback;
        String url = AVPowerfulUtils.getEndpoint(this);
        Object params = null;
        if (option != null && option.matchQuery != null) {
            if (this.getClassName() != null && !this.getClassName().equals(option.matchQuery.getClassName())) {
                callback.internalDone(new AVException(0, "AVObject class inconsistant with AVQuery in AVDeleteOption"));
                return;
            }
            Map<String, Object> whereOperationMap = null;
            whereOperationMap = option.matchQuery.conditions.compileWhereOperationMap();
            HashMap<String, Object> whereMap = new HashMap<String, Object>();
            if (whereOperationMap != null && !whereOperationMap.isEmpty()) {
                whereMap.put("where", whereOperationMap);
            }
            url = AVUtils.addQueryParams(url, whereMap);
        }
        Map<String, Object> body = this.getIgnoreHookParams();
        PaasClient.storageInstance().deleteObject(url, body, sync, isEventually, new GenericObjectCallback(){

            @Override
            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, this.getObjectId(), this.internalId());
    }

    public AVObject fetch() throws AVException {
        return this.fetch(null);
    }

    public AVObject fetch(String includeKeys) throws AVException {
        this.fetchInBackground(true, includeKeys, new GetCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return this;
    }

    public static List<AVObject> fetchAll(List<AVObject> objects) throws AVException {
        LinkedList<AVObject> results = new LinkedList<AVObject>();
        for (AVObject o : objects) {
            results.add(o.fetch());
        }
        return results;
    }

    public static List<AVObject> fetchAllIfNeeded(List<AVObject> objects) throws AVException {
        LinkedList<AVObject> results = new LinkedList<AVObject>();
        for (AVObject o : objects) {
            results.add(o.fetchIfNeeded());
        }
        return results;
    }

    public static void fetchAllIfNeededInBackground(List<AVObject> objects, FindCallback<AVObject> callback) {
        final FindCallback<AVObject> internalCallback = callback;
        final ArrayList result = new ArrayList();
        AVObject.fetchAllInBackground(true, objects, new GenericObjectCallback(){

            @Override
            public void onGroupRequestFinished(int left, int total, AVObject object) {
                if (object != null) {
                    result.add(object);
                }
                if (left <= 0 && internalCallback != null) {
                    internalCallback.internalDone(result, null);
                }
            }
        });
    }

    public static void fetchAllInBackground(List<AVObject> objects, final FindCallback<AVObject> callback) {
        final ArrayList result = new ArrayList();
        AVObject.fetchAllInBackground(false, objects, new GenericObjectCallback(){

            @Override
            public void onGroupRequestFinished(int left, int total, AVObject object) {
                if (object != null) {
                    result.add(object);
                }
                if (left <= 0 && callback != null) {
                    callback.internalDone(result, null);
                }
            }
        });
    }

    private static void fetchAllInBackground(boolean check, List<AVObject> objects, final GenericObjectCallback callback) {
        final int total = objects.size();
        final AtomicInteger counter = new AtomicInteger(objects.size());
        for (AVObject object : objects) {
            if (!check || !object.isDataAvailable()) {
                object.fetchInBackground(false, null, new GetCallback<AVObject>(){

                    @Override
                    public void done(AVObject object, AVException e) {
                        if (callback != null) {
                            callback.onGroupRequestFinished(counter.decrementAndGet(), total, object);
                        }
                    }
                });
                continue;
            }
            if (callback == null) continue;
            callback.onGroupRequestFinished(counter.decrementAndGet(), total, object);
        }
        if (objects.size() <= 0 && callback != null) {
            callback.onGroupRequestFinished(0, 0, null);
        }
    }

    public AVObject fetchIfNeeded() throws AVException {
        return this.fetchIfNeeded(null);
    }

    public AVObject fetchIfNeeded(String includeKeys) throws AVException {
        if (!this.isDataAvailable()) {
            this.fetchInBackground(true, includeKeys, new GetCallback<AVObject>(){

                @Override
                public void done(AVObject object, AVException e) {
                    if (e != null) {
                        AVExceptionHolder.add(e);
                    }
                }

                @Override
                protected boolean mustRunOnUIThread() {
                    return false;
                }
            });
        }
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return this;
    }

    public void fetchIfNeededInBackground(GetCallback<AVObject> callback) {
        this.fetchIfNeededInBackground(null, callback);
    }

    public void fetchIfNeededInBackground(String includeKeys, GetCallback<AVObject> callback) {
        if (!this.isDataAvailable()) {
            this.fetchInBackground(includeKeys, callback);
        } else if (callback != null) {
            callback.internalDone(this, null);
        }
    }

    public void fetchInBackground(GetCallback<AVObject> callback) {
        this.fetchInBackground(null, callback);
    }

    public void fetchInBackground(String includeKeys, GetCallback<AVObject> callback) {
        this.fetchInBackground(false, includeKeys, callback);
    }

    private void fetchInBackground(boolean sync, String includeKeys, GetCallback<AVObject> callback) {
        if (AVUtils.isBlankString(this.getObjectId())) {
            if (callback != null) {
                AVException exception = AVErrorUtils.createException(104, "Missing objectId");
                callback.internalDone(null, exception);
            }
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (!AVUtils.isBlankString(includeKeys)) {
            params.put("include", includeKeys);
        }
        PaasClient.storageInstance().getObject(AVPowerfulUtils.getEndpoint(this), new AVRequestParams(params), sync, this.headerMap(), new FetchObjectCallback(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        if (CREATED_AT.equals(key)) {
            return this.getCreatedAt();
        }
        if (UPDATED_AT.equals(key)) {
            return this.getUpdatedAt();
        }
        Object value = null;
        try {
            this.lock.readLock().lock();
            value = this.instanceData.get(key);
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return value;
    }

    public AVACL getACL() {
        return this.acl;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public String getClassName() {
        if (AVUtils.isBlankString(this.className)) {
            this.className = AVObject.getSubClassName(this.getClass());
        }
        return this.className;
    }

    public Date getCreatedAt() {
        return AVUtils.dateFromString(this.createdAt);
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public JSONArray getJSONArray(String key) {
        Object list = this.get(key);
        if (list == null) {
            return null;
        }
        if (list instanceof JSONArray) {
            return (JSONArray)list;
        }
        if (list instanceof Collection) {
            JSONArray array = new JSONArray((Collection)list);
            return array;
        }
        if (list instanceof Object[]) {
            JSONArray array = new JSONArray();
            for (Object obj : (Object[])list) {
                array.put(obj);
            }
            return array;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        String jsonString = JSON.toJSONString((Object)object);
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalid json string", exception);
        }
        return jsonObject;
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public <T extends AVObject> List<T> getList(String key, Class<T> clazz) {
        List list = this.getList(key);
        LinkedList<T> returnList = null;
        if (list != null) {
            returnList = new LinkedList<T>();
            try {
                for (AVObject item : list) {
                    T newItem = AVObject.cast(item, clazz);
                    returnList.add(newItem);
                }
            }
            catch (Exception e) {
                LogUtil.log.e("ClassCast Exception", e);
            }
        }
        return returnList;
    }

    public long getLong(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public <V> Map<String, V> getMap(String key) {
        return (Map)this.get(key);
    }

    public Number getNumber(String key) {
        Number number = (Number)this.get(key);
        return number;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public <T extends AVFile> T getAVFile(String key) {
        return (T)((AVFile)this.get(key));
    }

    public AVGeoPoint getAVGeoPoint(String key) {
        return (AVGeoPoint)this.get(key);
    }

    public <T extends AVObject> T getAVObject(String key) {
        return (T)((AVObject)this.get(key));
    }

    public <T extends AVObject> T getAVObject(String key, Class<T> clazz) throws Exception {
        T object = this.getAVObject(key);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        return AVObject.cast(this, clazz);
    }

    public <T extends AVUser> T getAVUser(String key) {
        return (T)((AVUser)this.get(key));
    }

    public <T extends AVUser> T getAVUser(String key, Class<T> clazz) {
        AVUser user = (AVUser)this.get(key);
        return user == null ? null : (T)AVUser.cast(user, clazz);
    }

    public <T extends AVObject> AVRelation<T> getRelation(String key) {
        if (this.checkKey(key)) {
            Object object = this.get(key);
            if (object != null && object instanceof AVRelation) {
                ((AVRelation)object).setParent(this);
                return (AVRelation)object;
            }
            AVRelation relation = new AVRelation(this, key);
            this.instanceData.put(key, relation);
            return relation;
        }
        return null;
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public Date getUpdatedAt() {
        return AVUtils.dateFromString(this.updatedAt);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public boolean hasSameId(AVObject other) {
        return other.objectId.equals(this.objectId);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(final String key, final Number amount) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new IncrementOp(key, amount);
                }
            };
            cb.execute(key);
        }
    }

    public boolean isDataAvailable() {
        return !AVUtils.isBlankString(this.objectId) && this.isDataReady;
    }

    public Set<String> keySet() {
        return this.instanceData.keySet();
    }

    private boolean checkKey(String key) {
        if (AVUtils.isBlankString(key)) {
            throw new IllegalArgumentException("Blank key");
        }
        if (key.startsWith("_")) {
            throw new IllegalArgumentException("key should not start with '_'");
        }
        if (INVALID_KEYS.contains(key)) {
            LogUtil.log.w("Internal key name:`" + key + "`,please use setter/getter for it.");
        }
        return !INVALID_KEYS.contains(key);
    }

    public void put(String key, Object value) {
        this.put(key, value, true);
    }

    protected void put(final String key, final Object value, boolean pending) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new SetOp(key, value);
                }
            };
            cb.execute(key, pending);
        }
    }

    public void refresh() throws AVException {
        this.refresh(null);
    }

    public void refresh(String includeKeys) throws AVException {
        this.refreshInBackground(true, includeKeys, new RefreshCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public void refreshInBackground(RefreshCallback<AVObject> callback) {
        this.refreshInBackground(false, null, callback);
    }

    public void refreshInBackground(String includeKeys, RefreshCallback<AVObject> callback) {
        this.refreshInBackground(false, includeKeys, callback);
    }

    private void refreshInBackground(boolean sync, String includeKeys, RefreshCallback<AVObject> callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!AVUtils.isBlankString(includeKeys)) {
            params.put("include", includeKeys);
        }
        PaasClient.storageInstance().getObject(AVPowerfulUtils.getEndpoint(this), new AVRequestParams(params), sync, this.headerMap(), new FetchObjectCallback(callback));
    }

    public void remove(String key) {
        this.removeObjectForKey(key);
    }

    public void removeAll(final String key, final Collection<?> values) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new RemoveOp(key, values);
                }
            };
            cb.execute(key);
        }
    }

    public void save() throws AVException {
        this.saveObject(true, false, new SaveCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public void save(AVSaveOption option) throws AVException {
        this.saveObject(option, true, false, new SaveCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void saveAll(List<? extends AVObject> objects) throws AVException {
        AVObject._saveAll(true, objects, new SaveCallback(){

            @Override
            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void saveAllInBackground(List<? extends AVObject> objects) {
        AVObject._saveAll(false, objects, null);
    }

    public static void saveAllInBackground(List<? extends AVObject> objects, SaveCallback callback) {
        AVObject._saveAll(false, objects, callback);
    }

    private static void _saveAll(final boolean sync, final List<? extends AVObject> objects, final SaveCallback callback) {
        block8: {
            final LinkedList list = new LinkedList();
            LinkedList<AVFile> files = new LinkedList<AVFile>();
            for (AVObject aVObject : objects) {
                List<AVFile> list2;
                if (!aVObject.checkCircleReference()) {
                    if (callback != null) {
                        callback.internalDone(AVErrorUtils.circleException());
                    }
                    return;
                }
                if (!aVObject.processOperationData() || AVUtils.isEmptyList(list2 = aVObject.getFilesToSave())) continue;
                files.addAll(list2);
            }
            final GenericObjectCallback genericObjectCallback = new GenericObjectCallback(){

                @Override
                public void onSuccess(String content, AVException e) {
                    for (AVObject o : objects) {
                        o.copyFromJson(content);
                        o.running = false;
                        o.onSaveSuccess();
                    }
                    if (callback != null) {
                        callback.done(null);
                    }
                }

                @Override
                public void onFailure(Throwable error, String content) {
                    for (AVObject o : objects) {
                        o.running = false;
                        o.rollbackDataToOperationQueue();
                        o.onSaveFailure();
                    }
                    LogUtil.log.d(content);
                    if (callback != null) {
                        callback.internalDone(null, AVErrorUtils.createException(error, content));
                    }
                }
            };
            try {
                if (files != null && files.size() > 0) {
                    AVObject.saveFileBeforeSave(files, sync, new SaveCallback(){

                        @Override
                        public void done(AVException e) {
                            for (AVObject o : objects) {
                                o.running = true;
                                o.buildParameterForNonSavedObject(list);
                            }
                            PaasClient.storageInstance().postBatchSave(list, sync, false, null, genericObjectCallback, null, null);
                        }
                    });
                } else {
                    for (AVObject aVObject : objects) {
                        aVObject.running = true;
                        aVObject.buildParameterForNonSavedObject(list);
                    }
                    PaasClient.storageInstance().postBatchSave(list, sync, false, null, genericObjectCallback, null, null);
                }
            }
            catch (AVException aVException) {
                if (callback == null) break block8;
                callback.internalDone(aVException);
            }
        }
    }

    public void saveEventually() {
        this.saveEventually(null);
    }

    public void saveEventually(SaveCallback callback) {
        if (AVUtils.isAndroid()) {
            PaasClient.registerEventuallyObject(this);
            this.saveInBackground(callback, true);
        } else {
            this.saveInBackground(callback);
        }
    }

    protected void onSaveSuccess() {
    }

    protected void onDataSynchronized() {
    }

    protected void onSaveFailure() {
    }

    protected Map<String, String> headerMap() {
        return PaasClient.storageInstance().userHeaderMap();
    }

    private void saveObject(boolean sync, boolean isEventually, SaveCallback callback) {
        this.saveObject(null, sync, isEventually, callback);
    }

    private void saveObject(final AVSaveOption option, final boolean sync, final boolean isEventually, final SaveCallback callback) {
        block9: {
            if (this.running) {
                if (callback != null) {
                    callback.internalDone(new AVException(-1, "already has one request sending"));
                }
                return;
            }
            boolean needToSave = this.processOperationData();
            if (!needToSave) {
                if (callback != null) {
                    callback.internalDone(null);
                }
                return;
            }
            if (option != null && option.matchQuery != null && this.getClassName() != null && !this.getClassName().equals(option.matchQuery.getClassName())) {
                callback.internalDone(new AVException(0, "AVObject class inconsistant with AVQuery in AVSaveOption"));
                return;
            }
            this.running = true;
            try {
                List<AVFile> files = this.getFilesToSave();
                if (files != null && files.size() > 0) {
                    AVObject.saveFileBeforeSave(files, sync, new SaveCallback(){

                        @Override
                        public void done(AVException e) {
                            AVObject.this._saveObject(option, sync, isEventually, callback);
                        }
                    });
                } else {
                    this._saveObject(option, sync, isEventually, callback);
                }
            }
            catch (AVException e) {
                if (callback == null) break block9;
                callback.internalDone(e);
            }
        }
    }

    private List<AVFile> getFilesToSave() {
        LinkedList<AVFile> fileNeedToUpload = new LinkedList<AVFile>();
        for (Map.Entry<String, AVOp> entry : this.tempDataForServerSaving.entrySet()) {
            AVFile file;
            AVOp op = entry.getValue();
            Object o = op.getValues();
            if (o != null && o instanceof AVObject) {
                List<AVFile> files = ((AVObject)o).getFilesToSave();
                if (files == null || files.size() <= 0) continue;
                fileNeedToUpload.addAll(files);
                continue;
            }
            if (o == null || !AVFile.class.isInstance(o) || (file = (AVFile)o).getObjectId() != null) continue;
            fileNeedToUpload.add(file);
        }
        return fileNeedToUpload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOperationData() {
        boolean needToSave = false;
        try {
            this.lock.writeLock().lock();
            for (Map.Entry<String, Object> entry : this.instanceData.entrySet()) {
                String key = entry.getKey();
                Object o = entry.getValue();
                if (o == null || !(o instanceof AVObject) || !((AVObject)o).processOperationData()) continue;
                this.put(key, o);
            }
            if (!this.operationQueue.isEmpty()) {
                this.tempDataForServerSaving.putAll(this.operationQueue);
                this.operationQueue.clear();
            }
            needToSave = !this.tempDataForServerSaving.isEmpty();
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return needToSave || AVUtils.isBlankString(this.objectId);
    }

    private void _saveObject(boolean sync, boolean isEventually, SaveCallback callback) {
        this._saveObject(null, sync, isEventually, callback);
    }

    private void _saveObject(AVSaveOption option, boolean sync, boolean isEventually, SaveCallback callback) {
        LinkedList<Map<String, Object>> pendingRequests = new LinkedList<Map<String, Object>>();
        this.buildParameterForNonSavedObject(pendingRequests);
        this.buildMatchQueryParams(option, pendingRequests);
        this.saveObjectToAVOSCloud(pendingRequests, sync, isEventually, callback);
    }

    private void buildMatchQueryParams(AVSaveOption option, LinkedList<Map<String, Object>> pendingRequests) {
        Map<String, Object> whereOperationMap = null;
        if (option != null && option.matchQuery != null) {
            whereOperationMap = option.matchQuery.conditions.compileWhereOperationMap();
        }
        if (pendingRequests.size() >= 1) {
            Map<String, Object> thisObjectPendingRequest = pendingRequests.get(0);
            HashMap<String, Object> whereMap = new HashMap<String, Object>();
            if (whereOperationMap != null && !whereOperationMap.isEmpty()) {
                whereMap.put("where", whereOperationMap);
            }
            if (this.fetchWhenSave || option != null && option.fetchWhenSave) {
                whereMap.put("fetchWhenSave", true);
            }
            if ("PUT".equals(thisObjectPendingRequest.get("method"))) {
                thisObjectPendingRequest.put("params", whereMap);
            }
        }
    }

    private Map<String, Object> getIgnoreHookParams() {
        if (this.ignoreHooks.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("__ignore_hooks", this.ignoreHooks);
        return result;
    }

    private void saveObjectToAVOSCloud(List<Map<String, Object>> requests, boolean sync, boolean isEventually, final SaveCallback callback) {
        for (Map<String, Object> request : requests) {
            Map body = (Map)request.get("body");
            if (((String)body.get("__internalId")).length() != UUID_LEN) continue;
            request.put("new", true);
        }
        PaasClient.storageInstance().postBatchSave(requests, sync, isEventually, this.headerMap(), new GenericObjectCallback(){

            @Override
            public boolean isRequestStatisticNeed() {
                return AVObject.this.requestStatistic;
            }

            @Override
            public void onSuccess(String content, AVException e) {
                AVObject.this.running = false;
                AVObject.this.copyFromJson(content);
                AVObject.this.onSaveSuccess();
                if (callback != null) {
                    callback.internalDone(e);
                }
            }

            @Override
            public void onFailure(Throwable error, String content) {
                AVObject.this.running = false;
                AVObject.this.rollbackDataToOperationQueue();
                if (callback != null) {
                    if (AVObject.this.shouldThrowException(error, content)) {
                        callback.internalDone(AVErrorUtils.createException(error, content));
                    } else {
                        callback.internalDone(null);
                    }
                }
                AVObject.this.onSaveFailure();
            }
        }, this.getObjectId(), this.internalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferDataToServerData() {
        try {
            this.lock.writeLock().lock();
            for (Map.Entry<String, AVOp> entry : this.tempDataForServerSaving.entrySet()) {
                Object oldValue = this.serverData.get(entry.getKey());
                Object newValue = entry.getValue().apply(oldValue);
                this.serverData.put(entry.getKey(), newValue);
            }
            this.tempDataForServerSaving.clear();
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackDataToOperationQueue() {
        try {
            this.lock.writeLock().lock();
            for (Map.Entry<String, AVOp> entry : this.operationQueue.entrySet()) {
                AVOp newOP = entry.getValue();
                AVOp op = this.tempDataForServerSaving.get(entry.getKey());
                op = op == null ? newOP : op.merge(newOP);
                this.tempDataForServerSaving.put(entry.getKey(), op);
            }
            this.operationQueue.clear();
            this.operationQueue.putAll(this.tempDataForServerSaving);
            this.tempDataForServerSaving.clear();
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private AVException copyFromJsonArray(String jsonStr) {
        try {
            ArrayList array = AVUtils.getFromJSON(jsonStr, ArrayList.class);
            for (Map map : array) {
                Map item = (Map)map.get("success");
                if (item != null) {
                    AVUtils.copyPropertiesFromMapToAVObject(item, this);
                    continue;
                }
                Map errorMap = (Map)map.get("error");
                return AVErrorUtils.createException(((Number)errorMap.get("code")).intValue(), (String)errorMap.get("error"));
            }
        }
        catch (Exception e) {
            LogUtil.log.e("parse jsonArray exception", e);
        }
        return null;
    }

    protected void copyFromJson(String jsonStr) {
        try {
            Map map = AVUtils.getFromJSON(jsonStr, Map.class);
            this.copyFromMap(map);
        }
        catch (Exception e) {
            LogUtil.log.e("AVObject parse error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFromMap(Map map) {
        try {
            this.lock.writeLock().lock();
            this.transferDataToServerData();
            Object item = map.get(this.uuid);
            if (item != null && item instanceof Map) {
                AVUtils.copyPropertiesFromMapToAVObject((Map)item, this);
            }
            if ((item = map.get(this.getObjectId())) != null && item instanceof Map) {
                AVUtils.copyPropertiesFromMapToAVObject((Map)item, this);
            }
            for (Object o : this.instanceData.values()) {
                if (!(o instanceof AVObject)) continue;
                ((AVObject)o).copyFromMap(map);
            }
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected boolean alwaysUsePost() {
        return false;
    }

    protected String internalId() {
        return AVUtils.isBlankString(this.getObjectId()) ? this.getUuid() : this.getObjectId();
    }

    protected boolean alwaysSaveAllKeyValues() {
        return false;
    }

    protected void buildBatchParameterForNonSavedObject(List<AVObject> unSavedChildren, List requestQueue) {
        if (!this.alwaysUsePost()) {
            if (!this.tempDataForServerSaving.isEmpty() || AVUtils.isBlankString(this.objectId)) {
                HashMap<String, Object> body = new HashMap<String, Object>();
                ArrayList children = new ArrayList();
                for (Map.Entry<String, AVOp> entry : this.tempDataForServerSaving.entrySet()) {
                    String key = entry.getKey();
                    AVOp op = entry.getValue();
                    this.parseOperation(body, key, op, children, unSavedChildren, requestQueue);
                }
                this.mergeRequestQueue(this.wrapperRequestBody(body, children, false), requestQueue);
                body.putAll(this.getIgnoreHookParams());
            }
        } else if (!this.instanceData.isEmpty()) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            ArrayList<Map<String, String>> children = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Object> entry : this.instanceData.entrySet()) {
                Object o = entry.getValue();
                String key = entry.getKey();
                this.parseObjectValue(unSavedChildren, body, children, o, key);
            }
            this.mergeRequestQueue(this.wrapperRequestBody(body, children, false), requestQueue);
        }
    }

    private void parseObjectValue(List<AVObject> unSavedChildren, Map<String, Object> body, List<Map<String, String>> children, Object o, String key) {
        if (o instanceof AVObject) {
            AVObject oo = (AVObject)o;
            Map<String, String> child = AVUtils.mapFromChildObject(oo, key);
            children.add(child);
            if (oo.processOperationData()) {
                unSavedChildren.add(oo);
            }
        } else if (o instanceof AVGeoPoint) {
            body.put(key, AVUtils.mapFromGeoPoint((AVGeoPoint)o));
        } else if (o instanceof Date) {
            body.put(key, AVUtils.mapFromDate((Date)o));
        } else if (o instanceof byte[]) {
            body.put(key, AVUtils.mapFromByteArray((byte[])o));
        } else if (o instanceof AVFile) {
            body.put(key, ((AVFile)o).toMap());
        } else {
            body.put(key, AVUtils.getParsedObject(o));
        }
    }

    private Map<String, Object> parseOperation(Map<String, Object> body, String key, AVOp op, List children, List unSavedChildren, List requestQueue) {
        Object o = op.getValues();
        if (!(op instanceof CollectionOp || op instanceof IncrementOp || op instanceof DeleteOp)) {
            this.parseObjectValue(unSavedChildren, body, children, o, key);
        } else if (op instanceof IncrementOp || op instanceof AddOp || op instanceof RemoveOp || op instanceof AddRelationOp || op instanceof RemoveRelationOp || op instanceof AddUniqueOp || op instanceof DeleteOp) {
            body.putAll(op.encodeOp());
        } else if (op instanceof CompoundOp) {
            Collection compoundOps = ((CompoundOp)op).getValues();
            if (!AVUtils.isEmptyList((List)compoundOps)) {
                AVOp firstOp = (AVOp)compoundOps.get(0);
                this.parseOperation(body, key, firstOp, children, unSavedChildren, requestQueue);
            }
            for (int index = 1; index < compoundOps.size(); ++index) {
                AVOp avOp = (AVOp)compoundOps.get(index);
                HashMap<String, Object> compoundChildBody = new HashMap<String, Object>();
                ArrayList compoundChildrenObjects = new ArrayList();
                this.parseOperation(compoundChildBody, key, avOp, compoundChildrenObjects, unSavedChildren, requestQueue);
                this.mergeRequestQueue(this.wrapperRequestBody(compoundChildBody, compoundChildrenObjects, true), requestQueue);
            }
        }
        return body;
    }

    private void mergeRequestQueue(Map<String, Object> requestBody, List requestQueue) {
        if (!requestBody.isEmpty()) {
            requestQueue.add(0, requestBody);
        }
    }

    private Map<String, Object> wrapperRequestBody(Map<String, Object> requestBody, List children, boolean compoundRequest) {
        boolean post;
        requestBody.put("__children", children);
        if (this.acl != null) {
            requestBody.putAll(AVUtils.getParsedMap(this.acl.getACLMap()));
        }
        requestBody.put("__internalId", this.internalId());
        String method = "PUT";
        boolean bl = post = (AVUtils.isBlankString(this.getObjectId()) || this.alwaysUsePost()) && !compoundRequest;
        if (post) {
            method = "POST";
        }
        String path = AVPowerfulUtils.getBatchEndpoint(PaasClient.storageInstance().getApiVersion(), this, post);
        return PaasClient.storageInstance().batchItemMap(method, path, requestBody, this.getBatchParams());
    }

    private Map getBatchParams() {
        if (this.fetchWhenSave) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("new", this.fetchWhenSave);
            return hashMap;
        }
        return null;
    }

    private void buildParameterForNonSavedObject(List list) {
        LinkedList<AVObject> unSavedChildren = new LinkedList<AVObject>();
        this.buildBatchParameterForNonSavedObject(unSavedChildren, list);
        for (AVObject o : unSavedChildren) {
            o.buildParameterForNonSavedObject(list);
        }
    }

    private boolean checkCircleReference() {
        return this.checkCircleReference(new HashMap<AVObject, Boolean>());
    }

    private boolean checkCircleReference(Map<AVObject, Boolean> status) {
        boolean result = true;
        if (status.get(this) != null) {
            if (!status.get(this).booleanValue()) {
                LogUtil.log.e("Found a circular dependency while saving");
                return false;
            }
            return true;
        }
        status.put(this, false);
        for (Object o : this.instanceData.values()) {
            if (!(o instanceof AVObject)) continue;
            result = result && ((AVObject)o).checkCircleReference(status);
        }
        status.put(this, true);
        return result;
    }

    public void saveInBackground() {
        this.saveInBackground(null, null);
    }

    public void saveInBackground(AVSaveOption option) {
        this.saveInBackground(option, null);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, false);
    }

    public void saveInBackground(AVSaveOption option, SaveCallback callback) {
        this.saveObject(option, false, false, callback);
    }

    private void saveInBackground(SaveCallback callback, boolean isEventually) {
        this.saveObject(false, isEventually, callback);
    }

    public void setACL(AVACL acl) {
        this.acl = acl;
    }

    public void setObjectId(String newObjectId) {
        this.objectId = newObjectId;
    }

    private List findArray(Map<String, Object> parent, String key, boolean create) {
        ArrayList array = null;
        try {
            array = (ArrayList)parent.get(key);
            if (array != null || !create) {
                return array;
            }
            array = new ArrayList();
            parent.put(key, array);
            return array;
        }
        catch (Exception exception) {
            LogUtil.log.e(LOGTAG, "find array failed.", exception);
            return array;
        }
    }

    protected String internalClassName() {
        return this.getClassName();
    }

    protected boolean shouldThrowException(Throwable error, String content) {
        return true;
    }

    void addRelationFromServer(final String key, String className, boolean submit) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new AddRelationOp(key, new AVObject[0]);
                }
            };
            cb.execute(key, submit);
        }
    }

    void addRelation(final AVObject object, final String key, boolean submit) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new AddRelationOp(key, object);
                }
            };
            cb.execute(key, submit);
        }
    }

    void removeRelation(final AVObject object, final String key, boolean submit) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new RemoveRelationOp(key, object);
                }
            };
            cb.execute(key, submit);
        }
    }

    private void addObjectToArray(final String key, final Object value, final boolean unique) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    if (unique) {
                        return new AddUniqueOp(key, value);
                    }
                    return new AddOp(key, value);
                }
            };
            cb.execute(key);
        }
    }

    private void removeObjectForKey(final String key) {
        if (this.checkKey(key)) {
            KeyValueCallback cb = new KeyValueCallback(){

                @Override
                public AVOp createOp() {
                    return new DeleteOp(key);
                }
            };
            cb.execute(key);
        }
    }

    public static void saveFileBeforeSave(List<AVFile> files, boolean sync, final SaveCallback callback) throws AVException {
        if (sync) {
            for (AVFile file : files) {
                if (file == null) continue;
                file.save();
            }
            callback.done(null);
        } else {
            final AtomicInteger lock = new AtomicInteger(AVUtils.collectionNonNullCount(files));
            final AtomicBoolean failureLock = new AtomicBoolean(false);
            for (AVFile file : files) {
                if (file == null) continue;
                file.saveInBackground(new SaveCallback(){

                    @Override
                    public void done(AVException e) {
                        if (e != null && failureLock.compareAndSet(false, true)) {
                            callback.done(e);
                        } else {
                            if (e != null) {
                                return;
                            }
                            if (lock.decrementAndGet() == 0) {
                                callback.done(null);
                            }
                        }
                    }
                });
            }
        }
    }

    public int hashCode() {
        if (AVUtils.isBlankString(this.objectId)) {
            return super.hashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getClassName() == null ? 0 : this.getClassName().hashCode());
        result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (AVUtils.isBlankString(this.objectId)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AVObject other = (AVObject)obj;
        if (this.getClassName() == null ? other.getClassName() != null : !this.getClassName().equals(other.getClassName())) {
            return false;
        }
        return !(this.objectId == null ? other.objectId != null : !this.objectId.equals(other.objectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildInstanceData() {
        try {
            this.lock.writeLock().lock();
            this.instanceData.putAll(this.serverData);
            for (Map.Entry<String, AVOp> opEntry : this.operationQueue.entrySet()) {
                Object oldValue;
                String key = opEntry.getKey();
                AVOp op = opEntry.getValue();
                Object newValue = op.apply(oldValue = this.instanceData.get(key));
                if (newValue == null) {
                    this.instanceData.remove(key);
                    continue;
                }
                this.instanceData.put(key, newValue);
            }
        }
        catch (Exception e) {
            LogUtil.log.e(LOGTAG, "", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected static <T extends AVObject> T cast(AVObject object, Class<T> clazz) throws Exception {
        if (clazz.getClass().isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        AVObject newItem = (AVObject)clazz.newInstance();
        newItem.operationQueue.putAll(object.operationQueue);
        newItem.serverData.putAll(object.serverData);
        newItem.createdAt = object.createdAt;
        newItem.updatedAt = object.updatedAt;
        newItem.objectId = object.objectId;
        newItem.rebuildInstanceData();
        return (T)newItem;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int i) {
        out.writeString(this.className);
        out.writeString(this.createdAt);
        out.writeString(this.updatedAt);
        out.writeString(this.objectId);
        out.writeString(JSON.toJSONString(this.serverData, (SerializeFilter)new ObjectValueFilter(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteClassName}));
        out.writeString(JSON.toJSONString(this.operationQueue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName}));
    }

    public AVObject(Parcel in) {
        this();
        Map operationQueueMap;
        this.className = in.readString();
        this.createdAt = in.readString();
        this.updatedAt = in.readString();
        this.objectId = in.readString();
        String serverDataStr = in.readString();
        Map serverDataMap = (Map)JSON.parse((String)serverDataStr);
        if (serverDataMap != null && !serverDataMap.isEmpty()) {
            this.serverData.putAll(serverDataMap);
        }
        if ((operationQueueMap = (Map)JSON.parse((String)in.readString())) != null && !operationQueueMap.isEmpty()) {
            this.operationQueue.putAll(operationQueueMap);
        }
        this.rebuildInstanceData();
    }

    public void disableBeforeHook() {
        Collections.addAll(this.ignoreHooks, Hook.beforeSave, Hook.beforeUpdate, Hook.beforeDelete);
    }

    public void disableAfterHook() {
        Collections.addAll(this.ignoreHooks, Hook.afterSave, Hook.afterUpdate, Hook.afterDelete);
    }

    public void ignoreHook(Hook hook) {
        this.ignoreHooks.add(hook);
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        ParserConfig.getGlobalInstance().putDeserializer(AVObject.class, (ObjectDeserializer)AVObjectDeserializer.instance);
        ParserConfig.getGlobalInstance().putDeserializer(AVUser.class, (ObjectDeserializer)AVObjectDeserializer.instance);
        SerializeConfig.getGlobalInstance().put(AVObject.class, (Object)AVObjectSerializer.instance);
        SerializeConfig.getGlobalInstance().put(AVUser.class, (Object)AVObjectSerializer.instance);
        LOGTAG = AVObject.class.getName();
        UUID_LEN = UUID.randomUUID().toString().length();
        SUB_CLASSES_MAP = new HashMap<String, Class<? extends AVObject>>();
        SUB_CLASSES_REVERSE_MAP = new HashMap<Class<? extends AVObject>, String>();
        INVALID_KEYS = new HashSet<String>();
        INVALID_KEYS.add("code");
        INVALID_KEYS.add("uuid");
        INVALID_KEYS.add("className");
        INVALID_KEYS.add("keyValues");
        INVALID_KEYS.add("fetchWhenSave");
        INVALID_KEYS.add("running");
        INVALID_KEYS.add("acl");
        INVALID_KEYS.add("ACL");
        INVALID_KEYS.add("isDataReady");
        INVALID_KEYS.add("pendingKeys");
        INVALID_KEYS.add(CREATED_AT);
        INVALID_KEYS.add(UPDATED_AT);
        INVALID_KEYS.add(OBJECT_ID);
        INVALID_KEYS.add("error");
        CREATOR = AVObjectCreator.instance;
    }

    public static class AVObjectCreator
    implements Parcelable.Creator {
        public static AVObjectCreator instance = new AVObjectCreator();

        private AVObjectCreator() {
        }

        public AVObject createFromParcel(Parcel parcel) {
            AVObject avobject = new AVObject(parcel);
            Class<? extends AVObject> subClass = AVUtils.getAVObjectClassByClassName(avobject.className);
            if (subClass != null) {
                try {
                    AVObject returnValue = AVObject.cast(avobject, subClass);
                    return returnValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return avobject;
        }

        public AVObject[] newArray(int i) {
            return new AVObject[i];
        }
    }

    private abstract class KeyValueCallback {
        private KeyValueCallback() {
        }

        public void execute(String key) {
            this.execute(key, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(String key, boolean pending) {
            try {
                AVObject.this.lock.writeLock().lock();
                AVOp op = AVObject.this.operationQueue.get(key);
                AVOp newOP = this.createOp();
                op = op == null ? newOP : op.merge(newOP);
                Object oldValue = AVObject.this.instanceData.get(key);
                Object newValue = newOP.apply(oldValue);
                if (pending) {
                    AVObject.this.operationQueue.put(key, op);
                } else {
                    AVObject.this.serverData.put(key, newValue);
                }
                if (newValue == null) {
                    AVObject.this.instanceData.remove(key);
                } else {
                    AVObject.this.instanceData.put(key, newValue);
                }
            }
            catch (Exception e) {
                LogUtil.log.e(LOGTAG, "", e);
            }
            finally {
                AVObject.this.lock.writeLock().unlock();
            }
        }

        public abstract AVOp createOp();
    }

    public static enum Hook {
        beforeSave,
        afterSave,
        beforeUpdate,
        afterUpdate,
        beforeDelete,
        afterDelete;

    }

    private final class FetchObjectCallback
    extends GenericObjectCallback {
        private final AVCallback<AVObject> internalCallback;

        private FetchObjectCallback(AVCallback<AVObject> internalCallback) {
            this.internalCallback = internalCallback;
        }

        @Override
        public void onSuccess(String content, AVException e) {
            AVException error = e;
            AVObject object = AVObject.this;
            if (!AVUtils.isBlankContent(content)) {
                AVUtils.copyPropertiesFromJsonStringToAVObject(content, object);
                AVObject.this.isDataReady = true;
                AVObject.this.onDataSynchronized();
            } else {
                object = null;
                error = new AVException(101, "The object is not Found");
            }
            if (this.internalCallback != null) {
                this.internalCallback.internalDone(object, error);
            }
        }

        @Override
        public void onFailure(Throwable error, String content) {
            if (this.internalCallback != null) {
                this.internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
            }
        }
    }
}

