/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

public class AVGeoPoint {
    static double EARTH_MEAN_RADIUS_KM = 6378.14;
    static double ONE_KM_TO_MILES = 1.609344;
    private double latitude;
    private double longitude;
    static final String LATITUDE_KEY = "latitude";
    static final String LONGTITUDE_KEY = "longitude";

    public AVGeoPoint() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public double distanceInKilometersTo(AVGeoPoint point) {
        float[] mResults = new float[2];
        AVGeoPoint.computeDistanceAndBearing(this.latitude, this.longitude, point.latitude, point.longitude, mResults);
        return mResults[0] / 1000.0f;
    }

    public double distanceInMilesTo(AVGeoPoint point) {
        return this.distanceInKilometersTo(point) / ONE_KM_TO_MILES;
    }

    public double distanceInRadiansTo(AVGeoPoint point) {
        return this.distanceInKilometersTo(point) / EARTH_MEAN_RADIUS_KM;
    }

    public AVGeoPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double l) {
        this.latitude = l;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double l) {
        this.longitude = l;
    }

    private static void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, float[] results) {
        float distance;
        int MAXITERS = 20;
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SM = 0.0;
        double cosSigma = 0.0;
        double sinSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            sinSigma = Math.sqrt(sinSqSigma);
            cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        results[0] = distance = (float)(b * A * (sigma - deltaSigma));
        if (results.length > 1) {
            float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
            results[1] = initialBearing = (float)((double)initialBearing * 57.29577951308232);
            if (results.length > 2) {
                float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
                results[2] = finalBearing = (float)((double)finalBearing * 57.29577951308232);
            }
        }
    }
}

