/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.annotation.JSONField;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.FileUploader;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.GetDataCallback;
import com.avos.avoscloud.GetFileCallback;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.Uploader;
import com.avos.avoscloud.UrlDirectlyUploader;
import com.avos.avoscloud.internal.AppConfiguration;
import com.avos.avoscloud.internal.InternalConfigurationController;
import com.avos.avoscloud.internal.InternalFileDownloader;
import com.avos.avoscloud.utils.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class AVFile {
    private static final String KEY_URL = "url";
    private static final String KEY_TYPE = "__type";
    private static final String KEY_NAME = "_name";
    private static final String KEY_METADATA_SIZE = "size";
    private static final String KEY_METADATA_OWNER = "owner";
    private static final String KEY_SOURCE = "__source";
    private static final String KEY_METADATA = "metaData";
    private static final String KEY_METADATA_CHECK_SUM = "_checksum";
    private boolean dirty;
    private String name;
    private String url;
    private String localPath;
    private String localTmpFilePath;
    private transient Uploader uploader;
    private transient InternalFileDownloader downloader;
    private final HashMap<String, Object> metaData = new HashMap();
    private static String defaultMimeType = "application/octet-stream";
    private String objectId;
    private AVObject fileObject;
    private String bucket;
    private AVACL acl;
    private byte[] data;
    private static final String THUMBNAIL_FMT = "?imageView/%d/w/%d/h/%d/q/%d/format/%s";

    public AVFile() {
        if (PaasClient.storageInstance().getDefaultACL() != null) {
            this.acl = new AVACL(PaasClient.storageInstance().getDefaultACL());
        }
    }

    AVObject getFileObject() {
        if (this.fileObject == null && !AVUtils.isBlankString(this.objectId)) {
            this.fileObject = AVObject.createWithoutData("_File", this.objectId);
        }
        return this.fileObject;
    }

    @Deprecated
    public AVFile(byte[] data) {
        this(null, data);
    }

    public AVFile(String name, String url, Map<String, Object> metaData) {
        this();
        this.name = name;
        this.url = url;
        if (metaData != null) {
            this.metaData.putAll(metaData);
        }
        this.metaData.put(KEY_SOURCE, "external");
    }

    public AVFile(String name, byte[] data) {
        this();
        this.dirty = true;
        this.name = name;
        if (null != data) {
            String md5 = AVUtils.computeMD5(data);
            String cachePath = InternalConfigurationController.globalInstance().getInternalPersistence().getAVFileCachePath();
            if (!AVUtils.isBlankString(cachePath)) {
                this.localTmpFilePath = InternalConfigurationController.globalInstance().getInternalPersistence().getAVFileCachePath() + md5;
                InternalConfigurationController.globalInstance().getInternalPersistence().saveContentToFile(data, new File(this.localTmpFilePath));
            } else {
                this.data = data;
            }
            this.metaData.put(KEY_METADATA_CHECK_SUM, md5);
            this.metaData.put(KEY_METADATA_SIZE, data.length);
        } else {
            this.metaData.put(KEY_METADATA_SIZE, 0);
        }
        AVUser currentUser = AVUser.getCurrentUser();
        this.metaData.put(KEY_METADATA_OWNER, currentUser != null ? currentUser.getObjectId() : "");
        this.metaData.put(KEY_NAME, name);
    }

    protected AVFile(String name, String url) {
        this.dirty = false;
        this.name = name;
        this.url = url;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Deprecated
    public static void parseFileWithObjectIdInBackground(String objectId, GetFileCallback<AVFile> cb) {
        AVFile.withObjectIdInBackground(objectId, cb);
    }

    public static void withObjectIdInBackground(final String objectId, final GetFileCallback<AVFile> cb) {
        AVQuery<AVObject> query = new AVQuery<AVObject>("_File");
        query.getInBackground(objectId, new GetCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    cb.internalDone(null, e);
                    return;
                }
                if (object != null && !AVUtils.isBlankString(object.getObjectId())) {
                    AVFile file = AVFile.createFileFromAVObject(object);
                    if (cb != null) {
                        cb.internalDone(file, null);
                    }
                } else {
                    cb.internalDone(null, new AVException(101, "Could not find file object by id:" + objectId));
                }
            }
        });
    }

    @Deprecated
    public static AVFile parseFileWithObjectId(String objectId) throws AVException, FileNotFoundException {
        return AVFile.withObjectId(objectId);
    }

    public static AVFile withObjectId(String objectId) throws AVException, FileNotFoundException {
        AVQuery query = new AVQuery("_File");
        Object object = query.get(objectId);
        if (object != null && !AVUtils.isBlankString(((AVObject)object).getObjectId())) {
            AVFile file = AVFile.createFileFromAVObject(object);
            return file;
        }
        throw new FileNotFoundException("Could not find file object by id:" + objectId);
    }

    @Deprecated
    public static AVFile parseFileWithAVObject(AVObject obj) {
        return AVFile.withAVObject(obj);
    }

    public static AVFile withAVObject(AVObject obj) {
        if (obj != null && !AVUtils.isBlankString(obj.getObjectId())) {
            AVFile file = AVFile.createFileFromAVObject(obj);
            return file;
        }
        throw new IllegalArgumentException("Invalid AVObject.");
    }

    private static AVFile createFileFromAVObject(AVObject object) {
        AVFile file = new AVFile(object.getObjectId(), object.getString(KEY_URL));
        if (object.getMap(KEY_METADATA) != null && !object.getMap(KEY_METADATA).isEmpty()) {
            file.metaData.putAll(object.getMap(KEY_METADATA));
        }
        if (object.getMap(KEY_METADATA) != null) {
            file.metaData.putAll(object.getMap(KEY_METADATA));
        }
        file.setObjectId(object.getObjectId());
        file.fileObject = object;
        file.setBucket((String)object.get("bucket"));
        if (!file.metaData.containsKey(KEY_NAME)) {
            file.metaData.put(KEY_NAME, object.getString("name"));
        }
        return file;
    }

    @Deprecated
    public static AVFile parseFileWithAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws Exception {
        return AVFile.withAbsoluteLocalPath(name, absoluteLocalFilePath);
    }

    public static AVFile withAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws FileNotFoundException {
        return AVFile.withFile(name, new File(absoluteLocalFilePath));
    }

    @Deprecated
    public static AVFile parseFileWithFile(String name, File file) throws FileNotFoundException {
        return AVFile.withFile(name, file);
    }

    public static AVFile withFile(String name, File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null file object.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        AVFile avFile = new AVFile();
        avFile.setLocalPath(file.getAbsolutePath());
        avFile.setName(name);
        avFile.dirty = true;
        avFile.name = name;
        byte[] data = InternalConfigurationController.globalInstance().getInternalPersistence().readContentBytesFromFile(file);
        if (null != data) {
            avFile.metaData.put(KEY_METADATA_CHECK_SUM, AVUtils.computeMD5(data));
            avFile.metaData.put(KEY_METADATA_SIZE, file.length());
        } else {
            avFile.metaData.put(KEY_METADATA_SIZE, 0);
        }
        AVUser currentUser = AVUser.getCurrentUser();
        avFile.metaData.put(KEY_METADATA_OWNER, currentUser != null ? currentUser.getObjectId() : "");
        avFile.metaData.put(KEY_NAME, name);
        return avFile;
    }

    public HashMap<String, Object> getMetaData() {
        return this.metaData;
    }

    public Object addMetaData(String key, Object val) {
        return this.metaData.put(key, val);
    }

    public Object getMetaData(String key) {
        return this.metaData.get(key);
    }

    public int getSize() {
        Number size = (Number)this.getMetaData(KEY_METADATA_SIZE);
        if (size != null) {
            return size.intValue();
        }
        return -1;
    }

    public String getOwnerObjectId() {
        return (String)this.getMetaData(KEY_METADATA_OWNER);
    }

    public Object removeMetaData(String key) {
        return this.metaData.remove(key);
    }

    public void clearMetaData() {
        this.metaData.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return (String)this.metaData.get(KEY_NAME);
    }

    void setName(String name) {
        this.name = name;
    }

    public static String getMimeType(String url) {
        String type = defaultMimeType;
        String extension = MimeTypeMap.getFileExtensionFromUrl(url);
        if (extension != null) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        if (type == null) {
            type = defaultMimeType;
        }
        return type;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Deprecated
    public boolean isDataAvailable() {
        return AVUtils.isBlankString(this.localPath) || !AVUtils.isBlankString(this.localTmpFilePath) && new File(this.localTmpFilePath).exists();
    }

    public String getUrl() {
        return this.url;
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height) {
        return this.getThumbnailUrl(scaleToFit, width, height, 100, "png");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height, int quality, String fmt) {
        if (InternalConfigurationController.globalInstance().getAppConfiguration().getStorageType() != AppConfiguration.StorageType.StorageTypeQiniu) {
            throw new UnsupportedOperationException("We only support this method for qiniu storage.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Invalid width or height.");
        }
        if (quality < 1 || quality > 100) {
            throw new IllegalArgumentException("Invalid quality,valid range is 0-100.");
        }
        if (fmt == null || AVUtils.isBlankString(fmt.trim())) {
            fmt = "png";
        }
        int mode = scaleToFit ? 2 : 1;
        String resultUrl = this.getUrl() + String.format(THUMBNAIL_FMT, mode, width, height, quality, fmt);
        return resultUrl;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void save() throws AVException {
        if (AVUtils.isBlankString(this.objectId)) {
            this.cancelUploadIfNeed();
            AVException[] avExceptions = new AVException[1];
            this.uploader = this.getUploader(null, null);
            if (null != avExceptions[0]) {
                throw avExceptions[0];
            }
            AVException exception = this.uploader.doWork();
            if (exception != null) {
                throw exception;
            }
        }
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, ProgressCallback progressCallback) {
        if (AVUtils.isBlankString(this.objectId)) {
            this.cancelUploadIfNeed();
            this.getUploader(saveCallback, progressCallback).execute();
        } else {
            if (null != saveCallback) {
                saveCallback.internalDone(null);
            }
            if (null != progressCallback) {
                progressCallback.internalDone(100, null);
            }
        }
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    @Deprecated
    @JSONField(serialize=false)
    public byte[] getData() throws AVException {
        if (!AVUtils.isBlankString(this.localPath)) {
            return this.getLocalFileData();
        }
        if (!AVUtils.isBlankString(this.localTmpFilePath)) {
            return this.getTmpFileData();
        }
        if (!AVUtils.isBlankString(this.url)) {
            byte[] data;
            if (!InternalConfigurationController.globalInstance().getAppConfiguration().isConnected() && null != (data = this.getCacheData())) {
                return data;
            }
            this.cancelDownloadIfNeed();
            this.downloader = InternalConfigurationController.globalInstance().getDownloaderInstance(null, null);
            AVException exception = this.downloader.doWork(this.getUrl());
            if (exception != null) {
                throw exception;
            }
            return this.getCacheData();
        }
        return this.data;
    }

    public void getDataInBackground(GetDataCallback dataCallback, ProgressCallback progressCallback) {
        if (!AVUtils.isBlankString(this.localPath)) {
            if (dataCallback != null) {
                dataCallback.internalDone(this.getLocalFileData(), null);
            }
        } else if (!AVUtils.isBlankString(this.localTmpFilePath)) {
            if (dataCallback != null) {
                dataCallback.internalDone(this.getTmpFileData(), null);
            }
        } else if (!AVUtils.isBlankString(this.getUrl())) {
            byte[] data;
            if (!InternalConfigurationController.globalInstance().getAppConfiguration().isConnected() && null != (data = this.getCacheData())) {
                if (dataCallback != null) {
                    dataCallback.internalDone(data, null);
                }
                return;
            }
            this.cancelDownloadIfNeed();
            this.downloader = InternalConfigurationController.globalInstance().getDownloaderInstance(progressCallback, dataCallback);
            if (this.downloader == null) {
                if (dataCallback != null) {
                    dataCallback.internalDone(new AVException(252, ""));
                }
                return;
            }
            this.downloader.execute(this.getUrl());
        } else if (dataCallback != null) {
            dataCallback.internalDone(new AVException(126, ""));
        }
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        this.cancelDownloadIfNeed();
        this.cancelUploadIfNeed();
    }

    private void cancelDownloadIfNeed() {
        if (this.downloader != null) {
            this.downloader.cancel(true);
        }
    }

    private void cancelUploadIfNeed() {
        if (this.uploader != null) {
            this.uploader.cancel(true);
        }
    }

    void handleUploadedResponse(String objectId, String uniqueName, String url) {
        this.dirty = false;
        this.objectId = objectId;
        this.fileObject = AVObject.createWithoutData("_File", objectId);
        this.name = uniqueName;
        this.url = url;
    }

    public void delete() throws AVException {
        if (this.getFileObject() == null) {
            throw AVErrorUtils.createException(153, "File object is not exists.");
        }
        this.getFileObject().delete();
    }

    public void deleteEventually() {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteEventually();
        }
    }

    public void deleteEventually(DeleteCallback callback) {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteEventually(callback);
        }
    }

    public void deleteInBackground() {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteInBackground();
        }
    }

    public void deleteInBackground(DeleteCallback callback) {
        if (this.getFileObject() != null) {
            this.getFileObject().deleteInBackground(callback);
        } else {
            callback.internalDone(null, AVErrorUtils.createException(153, "File object is not exists."));
        }
    }

    String mimeType() {
        if (!AVUtils.isBlankString(this.name)) {
            return AVFile.getMimeType(this.name);
        }
        if (!AVUtils.isBlankString(this.url)) {
            return AVFile.getMimeType(this.url);
        }
        return defaultMimeType;
    }

    static String className() {
        return "File";
    }

    public Uploader getUploader(SaveCallback saveCallback, ProgressCallback progressCallback) {
        if (AVUtils.isBlankString(this.url)) {
            return new FileUploader(this, saveCallback, progressCallback);
        }
        return new UrlDirectlyUploader(this, saveCallback, progressCallback);
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @JSONField(serialize=false)
    private byte[] getLocalFileData() {
        if (!AVUtils.isBlankString(this.localPath)) {
            return InternalConfigurationController.globalInstance().getInternalPersistence().readContentBytesFromFile(new File(this.localPath));
        }
        return null;
    }

    @JSONField(serialize=false)
    private byte[] getTmpFileData() {
        if (!AVUtils.isBlankString(this.localTmpFilePath)) {
            return InternalConfigurationController.globalInstance().getInternalPersistence().readContentBytesFromFile(new File(this.localTmpFilePath));
        }
        return null;
    }

    @JSONField(serialize=false)
    private byte[] getCacheData() {
        File file;
        if (!AVUtils.isBlankString(this.url) && null != (file = InternalConfigurationController.globalInstance().getInternalPersistence().getAVFileCacheFile(this.url)) && file.exists()) {
            return InternalConfigurationController.globalInstance().getInternalPersistence().readContentBytesFromFile(file);
        }
        return null;
    }

    protected AVACL getACL() {
        return this.acl;
    }

    public void setACL(AVACL acl) {
        this.acl = acl;
    }

    protected JSONObject toJSONObject() {
        return new JSONObject(this.toMap());
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_TYPE, AVFile.className());
        result.put(KEY_METADATA, this.getMetaData());
        if (!AVUtils.isBlankString(this.getUrl())) {
            result.put(KEY_URL, this.url);
        }
        if (!AVUtils.isBlankString(this.getObjectId())) {
            result.put("objectId", this.getObjectId());
        }
        switch (InternalConfigurationController.globalInstance().getAppConfiguration().getStorageType()) {
            case StorageTypeAV: {
                result.put("name", this.getName());
                break;
            }
            case StorageTypeQiniu: 
            case StorageTypeS3: {
                result.put("id", this.getName());
                break;
            }
            default: {
                throw new UnsupportedOperationException("storage type unsupport!");
            }
        }
        return result;
    }

    public static AVFile fileFromMap(Map<String, Object> map) {
        AVFile file = new AVFile("", "");
        AVUtils.copyPropertiesFromMapToObject(map, file);
        Object metadata = map.get(KEY_METADATA);
        if (metadata != null && metadata instanceof Map) {
            file.getMetaData().putAll((Map)metadata);
        }
        if (AVUtils.isBlankString((String)file.getMetaData(KEY_NAME))) {
            file.getMetaData().put(KEY_NAME, file.getName());
        }
        if (map.containsKey(KEY_URL)) {
            file.setUrl((String)map.get(KEY_URL));
        }
        switch (InternalConfigurationController.globalInstance().getAppConfiguration().getStorageType()) {
            case StorageTypeAV: {
                break;
            }
            case StorageTypeQiniu: 
            case StorageTypeS3: {
                file.setName((String)map.get("objectId"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("storage type unsupport!");
            }
        }
        return file;
    }
}

