/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import java.util.PriorityQueue;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;

class CompletedOffsets {
    private final PriorityQueue<Long> outOfOrderQueue;
    private long completedOffset;
    private long nextOffsetToCommit;

    CompletedOffsets(long lastCompletedOffset) {
        this.completedOffset = lastCompletedOffset;
        this.nextOffsetToCommit = lastCompletedOffset + 1L;
        this.outOfOrderQueue = new PriorityQueue();
    }

    void addCompleteOffset(long offset) {
        if (offset == this.nextOffsetToCommit) {
            ++this.nextOffsetToCommit;
            while (!this.outOfOrderQueue.isEmpty() && this.outOfOrderQueue.peek() == this.nextOffsetToCommit) {
                this.outOfOrderQueue.poll();
                ++this.nextOffsetToCommit;
            }
        } else if (offset > this.nextOffsetToCommit) {
            this.outOfOrderQueue.add(offset);
        }
    }

    boolean hasOffsetToCommit() {
        return this.completedOffset < this.nextOffsetToCommit - 1L;
    }

    OffsetAndMetadata getOffsetToCommit() {
        assert (this.hasOffsetToCommit());
        return new OffsetAndMetadata(this.nextOffsetToCommit);
    }

    void updateCommittedOffset(long committedOffset) {
        assert (committedOffset > this.completedOffset) : "old:" + this.completedOffset + " new:" + committedOffset;
        assert (committedOffset <= this.nextOffsetToCommit) : "completedOffset:" + committedOffset + " nextOffsetToCommit:" + this.nextOffsetToCommit;
        this.completedOffset = committedOffset - 1L;
    }
}

