/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractRecommitAwareCommitPolicy;
import cn.leancloud.kafka.consumer.ProcessRecordsProgress;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

final class SyncCommitPolicy<K, V>
extends AbstractRecommitAwareCommitPolicy<K, V> {
    SyncCommitPolicy(Consumer<K, V> consumer, Duration syncCommitRetryInterval, int maxAttemptsForEachSyncCommit, Duration recommitInterval) {
        super(consumer, syncCommitRetryInterval, maxAttemptsForEachSyncCommit, recommitInterval);
    }

    @Override
    Set<TopicPartition> tryCommit0(boolean noPendingRecords, ProcessRecordsProgress progress) {
        if (!noPendingRecords || progress.noOffsetsToCommit()) {
            return Collections.emptySet();
        }
        Set<TopicPartition> completePartitions = this.fullCommitSync(progress);
        this.updateNextRecommitTime();
        return completePartitions;
    }
}

