/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractRecommitAwareCommitPolicy;
import cn.leancloud.kafka.consumer.ProcessRecordsProgress;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

final class PartialSyncCommitPolicy<K, V>
extends AbstractRecommitAwareCommitPolicy<K, V> {
    PartialSyncCommitPolicy(Consumer<K, V> consumer, Duration syncCommitRetryInterval, int maxAttemptsForEachSyncCommit, Duration forceWholeCommitInterval) {
        super(consumer, syncCommitRetryInterval, maxAttemptsForEachSyncCommit, forceWholeCommitInterval);
    }

    @Override
    Set<TopicPartition> tryCommit0(boolean noPendingRecords, ProcessRecordsProgress progress) {
        if (progress.noOffsetsToCommit()) {
            return Collections.emptySet();
        }
        if (noPendingRecords) {
            Set<TopicPartition> completePartitions = this.fullCommitSync(progress);
            this.updateNextRecommitTime();
            return completePartitions;
        }
        return this.partialCommitSync(progress);
    }
}

