/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import java.util.PriorityQueue;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;

class CompletedOffsets {
    private final PriorityQueue<Long> outOfOrderQueue;
    private long committedOffset;
    private long nextOffsetToCommit;

    CompletedOffsets(long lastCommittedOffset) {
        this.committedOffset = lastCommittedOffset;
        this.nextOffsetToCommit = lastCommittedOffset + 1L;
        this.outOfOrderQueue = new PriorityQueue();
    }

    long nextOffsetToCommit() {
        return this.nextOffsetToCommit;
    }

    void addCompleteOffset(long offset) {
        if (offset == this.nextOffsetToCommit) {
            ++this.nextOffsetToCommit;
            while (!this.outOfOrderQueue.isEmpty() && this.outOfOrderQueue.peek() == this.nextOffsetToCommit) {
                this.outOfOrderQueue.poll();
                ++this.nextOffsetToCommit;
            }
        } else if (offset > this.nextOffsetToCommit) {
            this.outOfOrderQueue.add(offset);
        }
    }

    boolean hasOffsetToCommit() {
        return this.committedOffset < this.nextOffsetToCommit - 1L;
    }

    OffsetAndMetadata getOffsetToCommit() {
        return new OffsetAndMetadata(this.nextOffsetToCommit);
    }

    void updateCommittedOffset(long committedOffset) {
        assert (committedOffset > this.committedOffset) : "old:" + this.committedOffset + " new:" + committedOffset;
        this.committedOffset = committedOffset;
    }
}

