/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractCommitPolicy;
import cn.leancloud.kafka.consumer.ProcessRecordsProgress;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

final class AutoCommitPolicy<K, V>
extends AbstractCommitPolicy<K, V> {
    AutoCommitPolicy(Consumer<K, V> consumer) {
        super(consumer, Duration.ZERO, 1);
    }

    @Override
    public Set<TopicPartition> tryCommit(boolean noPendingRecords, ProcessRecordsProgress progress) {
        Set<TopicPartition> partitions;
        if (progress.noOffsetsToCommit()) {
            return Collections.emptySet();
        }
        if (noPendingRecords) {
            partitions = progress.allPartitions();
            progress.clearAll();
        } else {
            partitions = progress.completedPartitions();
            progress.clearFor(partitions);
        }
        return partitions;
    }
}

