/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractCommitPolicy;
import cn.leancloud.kafka.consumer.ProcessRecordsProgress;
import cn.leancloud.kafka.consumer.VisibleForTesting;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

abstract class AbstractRecommitAwareCommitPolicy<K, V>
extends AbstractCommitPolicy<K, V> {
    private final Duration recommitInterval;
    private long nextRecommitNanos;

    AbstractRecommitAwareCommitPolicy(Consumer<K, V> consumer, Duration syncCommitRetryInterval, int maxAttemptsForEachSyncCommit, Duration recommitInterval) {
        super(consumer, syncCommitRetryInterval, maxAttemptsForEachSyncCommit);
        this.recommitInterval = recommitInterval;
        this.updateNextRecommitTime(System.nanoTime());
    }

    @Override
    public final Set<TopicPartition> tryCommit(boolean noPendingRecords, ProcessRecordsProgress progress) {
        if (this.needRecommit()) {
            this.commitSyncWithRetry(this.offsetsForRecommit());
            this.updateNextRecommitTime();
        }
        return this.tryCommit0(noPendingRecords, progress);
    }

    abstract Set<TopicPartition> tryCommit0(boolean var1, ProcessRecordsProgress var2);

    void updateNextRecommitTime() {
        this.updateNextRecommitTime(System.nanoTime());
    }

    @VisibleForTesting
    void updateNextRecommitTime(long currentNanos) {
        this.nextRecommitNanos = currentNanos + this.recommitInterval.toNanos();
    }

    @VisibleForTesting
    long nextRecommitNanos() {
        return this.nextRecommitNanos;
    }

    private boolean needRecommit() {
        return System.nanoTime() >= this.nextRecommitNanos;
    }

    private Map<TopicPartition, OffsetAndMetadata> offsetsForRecommit() {
        assert (this.needRecommit()) : "current nanos: " + System.nanoTime() + " nextRecommitNanos:" + this.nextRecommitNanos;
        HashMap<TopicPartition, OffsetAndMetadata> ret = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (TopicPartition partition : this.consumer.assignment()) {
            OffsetAndMetadata offset = this.consumer.committed(partition);
            if (offset == null) continue;
            ret.putIfAbsent(partition, offset);
        }
        return ret;
    }
}

