/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractRecommitAwareCommitPolicy;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

final class PartialSyncCommitPolicy<K, V>
extends AbstractRecommitAwareCommitPolicy<K, V> {
    PartialSyncCommitPolicy(Consumer<K, V> consumer, Duration syncCommitRetryInterval, int maxAttemptsForEachSyncCommit, Duration forceWholeCommitInterval) {
        super(consumer, syncCommitRetryInterval, maxAttemptsForEachSyncCommit, forceWholeCommitInterval);
    }

    @Override
    public Set<TopicPartition> tryCommit(boolean noPendingRecords) {
        Map<TopicPartition, OffsetAndMetadata> offsets = this.offsetsForPartialCommit();
        if (!offsets.isEmpty()) {
            this.commitSync(offsets);
        }
        if (this.completedTopicOffsets.isEmpty()) {
            return Collections.emptySet();
        }
        Set<TopicPartition> partitions = this.getCompletedPartitions(noPendingRecords);
        this.clearCachedCompletedPartitionsRecords(partitions, noPendingRecords);
        return partitions;
    }

    private Map<TopicPartition, OffsetAndMetadata> offsetsForPartialCommit() {
        if (this.needRecommit()) {
            Map<TopicPartition, OffsetAndMetadata> offsets = this.offsetsForRecommit();
            this.updateNextRecommitTime();
            return offsets;
        }
        return this.completedTopicOffsets;
    }
}

