/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.ConsumerRecordHandler;
import cn.leancloud.kafka.consumer.HandleMessageFailedException;
import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public final class RetriableConsumerRecordHandler<K, V>
implements ConsumerRecordHandler<K, V> {
    private final int maxRetryTimes;
    private final Duration retryInterval;
    private final ConsumerRecordHandler<K, V> wrappedHandler;

    public RetriableConsumerRecordHandler(ConsumerRecordHandler<K, V> wrappedHandler, int maxRetryTimes) {
        this(wrappedHandler, maxRetryTimes, Duration.ZERO);
    }

    public RetriableConsumerRecordHandler(ConsumerRecordHandler<K, V> wrappedHandler, int maxRetryTimes, Duration retryInterval) {
        Objects.requireNonNull(wrappedHandler, "wrappedHandler");
        if (maxRetryTimes <= 0) {
            throw new IllegalArgumentException("maxRetryTimes: " + maxRetryTimes + " (expect > 0)");
        }
        Objects.requireNonNull(retryInterval, "retryInterval");
        if (retryInterval.isNegative()) {
            throw new IllegalArgumentException("retryInterval: " + retryInterval + " (expect positive duration)");
        }
        this.maxRetryTimes = maxRetryTimes;
        this.wrappedHandler = wrappedHandler;
        this.retryInterval = retryInterval;
    }

    @Override
    public void handleRecord(ConsumerRecord<K, V> record) {
        Exception lastException = null;
        for (int retried = 0; retried <= this.maxRetryTimes; ++retried) {
            try {
                this.wrappedHandler.handleRecord(record);
                return;
            }
            catch (Exception ex) {
                lastException = ex;
                try {
                    Thread.sleep(this.retryInterval.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (lastException != null) {
            throw new HandleMessageFailedException(lastException);
        }
    }
}

