/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.AbstractRecommitAwareCommitPolicy;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

final class SyncCommitPolicy<K, V>
extends AbstractRecommitAwareCommitPolicy<K, V> {
    SyncCommitPolicy(Consumer<K, V> consumer, Duration recommitInterval) {
        super(consumer, recommitInterval);
    }

    @Override
    public Set<TopicPartition> tryCommit(boolean noPendingRecords) {
        if (noPendingRecords && !this.completedTopicOffsets.isEmpty()) {
            this.consumer.commitSync();
            HashSet<TopicPartition> completePartitions = new HashSet<TopicPartition>(this.completedTopicOffsets.keySet());
            this.completedTopicOffsets.clear();
            this.topicOffsetHighWaterMark.clear();
            this.updateNextRecommitTime();
            return completePartitions;
        }
        if (this.needRecommit()) {
            this.consumer.commitSync(this.offsetsForRecommit());
            this.updateNextRecommitTime();
        }
        return Collections.emptySet();
    }
}

