/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.ConsumerRecordHandler;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatchAllExceptionConsumerRecordHandler<K, V>
implements ConsumerRecordHandler<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CatchAllExceptionConsumerRecordHandler.class);
    private final ConsumerRecordHandler<K, V> wrappedHandler;
    private final BiConsumer<ConsumerRecord<K, V>, Throwable> errorConsumer;

    public CatchAllExceptionConsumerRecordHandler(ConsumerRecordHandler<K, V> wrappedHandler) {
        this(wrappedHandler, (record, throwable) -> logger.error("Handle kafka consumer record: " + record + " failed.", throwable));
    }

    public CatchAllExceptionConsumerRecordHandler(ConsumerRecordHandler<K, V> wrappedHandler, BiConsumer<ConsumerRecord<K, V>, Throwable> errorConsumer) {
        this.wrappedHandler = wrappedHandler;
        this.errorConsumer = errorConsumer;
    }

    @Override
    public void handleRecord(ConsumerRecord<K, V> record) {
        try {
            this.wrappedHandler.handleRecord(record);
        }
        catch (Exception ex) {
            this.errorConsumer.accept(record, ex);
        }
    }
}

