/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.kafka.consumer;

import cn.leancloud.kafka.consumer.CommitPolicy;
import cn.leancloud.kafka.consumer.Fetcher;
import cn.leancloud.kafka.consumer.LcKafkaConsumerBuilder;
import cn.leancloud.kafka.consumer.RebalanceListener;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public final class LcKafkaConsumer<K, V>
implements Closeable {
    private final Consumer<K, V> consumer;
    private final Thread fetcherThread;
    private final Fetcher<K, V> fetcher;
    private final ExecutorService workerPool;
    private final CommitPolicy<K, V> policy;
    private final boolean shutdownWorkerPoolOnStop;
    private volatile State state = State.INIT;

    LcKafkaConsumer(LcKafkaConsumerBuilder<K, V> builder) {
        this.consumer = builder.getConsumer();
        this.workerPool = builder.getWorkerPool();
        this.shutdownWorkerPoolOnStop = builder.isShutdownWorkerPoolOnStop();
        this.policy = builder.getPolicy();
        this.fetcher = new Fetcher<K, V>(builder);
        this.fetcherThread = new Thread(this.fetcher);
    }

    public synchronized void subscribe(Collection<String> topics) {
        if (topics.isEmpty()) {
            throw new IllegalArgumentException("subscribe empty topics");
        }
        if (this.subscribed() || this.closed()) {
            throw new IllegalStateException("client is in " + (Object)((Object)this.state) + " state. expect: " + (Object)((Object)State.INIT));
        }
        this.consumer.subscribe(topics, new RebalanceListener<K, V>(this.consumer, this.policy));
        String firstTopic = topics.iterator().next();
        this.fetcherThread.setName("kafka-fetcher-for-" + firstTopic + (topics.size() > 1 ? "..." : ""));
        this.fetcherThread.start();
        this.state = State.SUBSCRIBED;
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        LcKafkaConsumer lcKafkaConsumer = this;
        synchronized (lcKafkaConsumer) {
            if (this.closed()) {
                return;
            }
            this.state = State.CLOSED;
        }
        this.fetcher.close();
        try {
            this.fetcherThread.join();
            this.consumer.close();
            if (this.shutdownWorkerPoolOnStop) {
                this.workerPool.shutdown();
                this.workerPool.awaitTermination(1L, TimeUnit.DAYS);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    boolean subscribed() {
        return this.state.code() > State.INIT.code();
    }

    boolean closed() {
        return this.state == State.CLOSED;
    }

    CommitPolicy<K, V> policy() {
        return this.policy;
    }

    static enum State {
        INIT(0),
        SUBSCRIBED(1),
        CLOSED(2);

        private int code;

        private State(int code) {
            this.code = code;
        }

        int code() {
            return this.code;
        }
    }
}

