/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.EngineRequestContext;
import cn.leancloud.LCLogger;
import cn.leancloud.LCUser;
import cn.leancloud.LCUserCookieSign;
import cn.leancloud.impl.DefaultLCUserCookieSign;
import cn.leancloud.utils.LogUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EngineSessionCookie {
    private static LCLogger LOGGER = LogUtil.getLogger(EngineSessionCookie.class);
    boolean fetchUser;
    ThreadLocal<HttpServletResponse> responseHolder = new ThreadLocal();
    ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    LCUserCookieSign sign;

    public EngineSessionCookie(String secret, int maxAge, boolean fetchUser) {
        this(new DefaultLCUserCookieSign(secret, maxAge), fetchUser);
    }

    public EngineSessionCookie(String secret, String sessionKey, int maxAge, boolean fetchUser) {
        this(new DefaultLCUserCookieSign(secret, sessionKey, maxAge), fetchUser);
    }

    public EngineSessionCookie(LCUserCookieSign sign, boolean fetchUser) {
        this.fetchUser = fetchUser;
        this.sign = sign;
    }

    protected LCUser parseCookie(HttpServletRequest req, HttpServletResponse response) {
        this.responseHolder.set(response);
        this.requestHolder.set(req);
        LCUser user = null;
        if (this.sign.validateCookieSign(req)) {
            user = this.sign.decodeUser(req);
            if (this.fetchUser && user != null && !user.isDataAvailable()) {
                try {
                    user.fetch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return user;
    }

    public void wrapCookie(boolean inResponse) {
        if (inResponse) {
            HttpServletResponse resp = this.responseHolder.get();
            HttpServletRequest req = this.requestHolder.get();
            if (resp != null) {
                LCUser u = EngineRequestContext.getAuthenticatedUser();
                EngineSessionCookie.addCookie(req, resp, this.sign.encodeUser(u));
                EngineSessionCookie.addCookie(req, resp, this.sign.getCookieSign(u));
            }
        } else {
            this.responseHolder.set(null);
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        Cookie[] cookies = request.getCookies();
        boolean contains = false;
        if (cookies != null && cookies.length > 0) {
            for (Cookie existingCookie : cookies) {
                if (!cookie.getName().equals(existingCookie.getName())) continue;
                String cookieValue = cookie.getValue();
                contains = cookieValue == null ? existingCookie.getValue() == null : cookieValue.equals(existingCookie.getValue());
            }
        }
        if (!contains) {
            response.addCookie(cookie);
        }
    }
}

