/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.EngineRequestContext;
import cn.leancloud.LeanEngine;
import cn.leancloud.UnauthException;
import cn.leancloud.core.GeneralRequestSignature;
import cn.leancloud.utils.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PlatformRequestAuthentication {
    private static final Logger logger = LogManager.getLogger(PlatformRequestAuthentication.class);
    static final String ANDROID_AFFILIATED_SUFFIX = "ax-sig-1";
    static final String SIGN_MASTERKEY_SUFFIX = "master";
    private String appId;
    private String appKey;
    private String masterKey;
    private String prod;
    private String sessionToken;
    private String sign;
    private String remoteAddress;

    public static void validate(HttpServletRequest req) throws UnauthException {
        PlatformRequestAuthentication info = PlatformRequestAuthentication.parse(req);
        logger.debug("request auth: {}", (Object)info);
        if (null == info || info.getAppId() == null) {
            throw new UnauthException();
        }
        if (LeanEngine.getAppId().equals(info.getAppId()) && (LeanEngine.getAppKey().equals(info.getAppKey()) || LeanEngine.getMasterKey().equals(info.getAppKey()) || LeanEngine.getMasterKey().equals(info.getMasterKey()))) {
            if (LeanEngine.getMasterKey().equals(info.getMasterKey())) {
                req.setAttribute("authMasterKey", (Object)true);
            }
            req.setAttribute("requestAuth", (Object)info);
            return;
        }
        if (info.getSign() != null) {
            String[] split = info.getSign().split(",");
            String sign = split[0];
            String ts = split[1];
            String master = null;
            if (split.length > 2) {
                master = split[2];
            }
            if (ANDROID_AFFILIATED_SUFFIX.equals(master)) {
                String androidKey = LeanEngine.getAndroidKey();
                if (!StringUtil.isEmpty((String)androidKey)) {
                    String computedSign = GeneralRequestSignature.requestSign((String)androidKey, (long)Long.parseLong(ts), (String)ANDROID_AFFILIATED_SUFFIX);
                    if (info.getSign().equals(computedSign)) {
                        req.setAttribute("requestAuth", (Object)info);
                        return;
                    }
                }
            } else {
                boolean useMasterKey = SIGN_MASTERKEY_SUFFIX.equals(master);
                String computedSign = GeneralRequestSignature.requestSign((long)Long.parseLong(ts), (boolean)useMasterKey);
                if (info.getSign().equals(computedSign)) {
                    req.setAttribute("requestAuth", (Object)info);
                    return;
                }
            }
        }
        throw new UnauthException();
    }

    public static PlatformRequestAuthentication getInstance(HttpServletRequest req) {
        if (null == req) {
            return null;
        }
        return (PlatformRequestAuthentication)req.getAttribute("requestAuth");
    }

    private static PlatformRequestAuthentication parse(HttpServletRequest req) {
        String prod;
        if (null == req) {
            return null;
        }
        if (req.getContentType() != null && req.getContentType().startsWith("text/plain")) {
            return null;
        }
        String appId = PlatformRequestAuthentication.getHeaders(req, "x-lc-id", "x-avoscloud-application-id", "x-uluru-application-id");
        String appKey = PlatformRequestAuthentication.getHeaders(req, "x-lc-key", "x-avoscloud-application-key", "x-uluru-application-key");
        String masterKey = PlatformRequestAuthentication.getHeaders(req, "x-avoscloud-master-key", "x-uluru-master-key");
        if (appKey != null && appKey.indexOf(",master") > 0) {
            masterKey = appKey.substring(0, appKey.indexOf(",master"));
            appKey = null;
        }
        if ("false".equals(prod = PlatformRequestAuthentication.getHeaders(req, "x-lc-prod", "x-avoscloud-application-production", "x-uluru-application-production"))) {
            prod = "0";
        }
        String sessionToken = PlatformRequestAuthentication.getHeaders(req, "x-lc-session", "x-uluru-session-token", "x-avoscloud-session-token");
        String sign = PlatformRequestAuthentication.getHeaders(req, "x-lc-sign", "x-avoscloud-request-sign");
        String remoteAddress = PlatformRequestAuthentication.getHeaders(req, "x-real-ip", "x-forwarded-for");
        if (StringUtil.isEmpty((String)remoteAddress)) {
            remoteAddress = req.getRemoteAddr();
        }
        PlatformRequestAuthentication requestAuthentication = new PlatformRequestAuthentication(appId, appKey, masterKey, prod, sessionToken, sign, remoteAddress);
        EngineRequestContext.setSessionToken(sessionToken);
        EngineRequestContext.setRemoteAddress(remoteAddress);
        return requestAuthentication;
    }

    private static String getHeaders(HttpServletRequest req, String ... headers) {
        for (String header : headers) {
            String result = req.getHeader(header);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public PlatformRequestAuthentication(String appId, String appKey, String masterKey, String prod, String sessionToken, String sign, String remoteAddress) {
        this.appId = appId;
        this.appKey = appKey;
        this.masterKey = masterKey;
        this.prod = prod;
        this.sessionToken = sessionToken;
        this.sign = sign;
        this.remoteAddress = remoteAddress;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public String getProd() {
        return this.prod;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getSign() {
        return this.sign;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        return "RequestAuth [appId=" + this.appId + ", appKey=" + (this.appKey != null ? this.appKey.substring(0, 2) + "..." : null) + ", masterKey=" + (this.masterKey != null ? this.masterKey.substring(0, 2) + "..." : null) + ", prod=" + this.prod + ", sessionToken=" + this.sessionToken + ", sign=" + this.sign + "]";
    }
}

