/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.AVUser;
import cn.leancloud.AVUserCookieSign;
import cn.leancloud.EngineRequestContext;
import cn.leancloud.impl.DefaultAVUserCookieSign;
import cn.leancloud.utils.LogUtil;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EngineSessionCookie {
    private static AVLogger LOGGER = LogUtil.getLogger(EngineSessionCookie.class);
    boolean fetchUser;
    ThreadLocal<HttpServletResponse> responseHolder = new ThreadLocal();
    ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    AVUserCookieSign sign;

    public EngineSessionCookie(String secret, int maxAge, boolean fetchUser) {
        this(new DefaultAVUserCookieSign(secret, maxAge), fetchUser);
    }

    public EngineSessionCookie(String secret, String sessionKey, int maxAge, boolean fetchUser) {
        this(new DefaultAVUserCookieSign(secret, sessionKey, maxAge), fetchUser);
    }

    public EngineSessionCookie(AVUserCookieSign sign, boolean fetchUser) {
        this.fetchUser = fetchUser;
        this.sign = sign;
    }

    protected AVUser parseCookie(HttpServletRequest req, HttpServletResponse response) {
        this.responseHolder.set(response);
        this.requestHolder.set(req);
        AVUser user = null;
        if (this.sign.validateCookieSign(req)) {
            user = this.sign.decodeUser(req);
            if (this.fetchUser && user != null && !user.isDataAvailable()) {
                try {
                    user.fetch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return user;
    }

    public void wrapCookie(boolean inResponse) {
        if (inResponse) {
            HttpServletResponse resp = this.responseHolder.get();
            HttpServletRequest req = this.requestHolder.get();
            if (resp != null) {
                AVUser u = EngineRequestContext.getAuthenticatedUser();
                String host = null;
                try {
                    URL requestURL = new URL(req.getRequestURL().toString());
                    host = requestURL.getHost();
                }
                catch (Exception e) {
                    LOGGER.w((Throwable)e);
                }
                EngineSessionCookie.addCookie(req, resp, this.sign.encodeUser(u));
                EngineSessionCookie.addCookie(req, resp, this.sign.getCookieSign(u));
            }
        } else {
            this.responseHolder.set(null);
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        Cookie[] cookies = request.getCookies();
        boolean contains = false;
        if (cookies != null && cookies.length > 0) {
            for (Cookie existingCookie : cookies) {
                if (!cookie.getName().equals(existingCookie.getName())) continue;
                String cookieValue = cookie.getValue();
                contains = cookieValue == null ? existingCookie.getValue() == null : cookieValue.equals(existingCookie.getValue());
            }
        }
        if (!contains) {
            response.addCookie(cookie);
        }
    }
}

