/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVLogger;
import cn.leancloud.EndpointParser;
import cn.leancloud.InvalidParameterException;
import cn.leancloud.LeanEngine;
import cn.leancloud.PlatformRequestAuthentication;
import cn.leancloud.UnauthException;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONObject;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="CloudCodeServlet", urlPatterns={"/1/functions/*", "/1.1/functions/*", "/1/call/*", "/1.1/call/*"}, loadOnStartup=0)
public class CloudCodeServlet
extends HttpServlet {
    private static final long serialVersionUID = -5828358153354045625L;
    private static final AVLogger LOGGER = LogUtil.getLogger(CloudCodeServlet.class);

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setAllowOriginHeader(req, resp);
        resp.setHeader("Access-Control-Max-Age", "86400");
        resp.setHeader("Access-Control-Allow-Methods", "PUT, GET, POST, DELETE, OPTIONS");
        resp.setHeader("Access-Control-Allow-Headers", "X-LC-Id, X-LC-Key, X-LC-Session, X-LC-Sign, X-LC-Prod, X-LC-UA, X-Uluru-Application-Key, X-Uluru-Application-Id, X-Uluru-Application-Production, X-Uluru-Client-Version, X-Uluru-Session-Token, X-AVOSCloud-Application-Key, X-AVOSCloud-Application-Id, X-AVOSCloud-Application-Production, X-AVOSCloud-Client-Version, X-AVOSCloud-Session-Token, X-AVOSCloud-Super-Key, X-Requested-With, Content-Type, X-AVOSCloud-Request-sign");
        resp.setHeader("Content-Length", "0");
        resp.setStatus(200);
        resp.getWriter().println();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block10: {
            this.setAllowOriginHeader(req, resp);
            try {
                PlatformRequestAuthentication.validate(req);
            }
            catch (UnauthException e) {
                e.resp(resp);
                return;
            }
            EndpointParser.EndpointInfo internalEndpoint = EndpointParser.getInternalEndpoint(req);
            LOGGER.d("endpoint info: " + internalEndpoint);
            if (internalEndpoint == null || StringUtil.isEmpty((String)internalEndpoint.getInternalEndpoint()) || LeanEngine.getHandler(internalEndpoint.getInternalEndpoint()) == null) {
                resp.setStatus(400);
                resp.setContentType("application/json; charset=UTF-8");
                resp.getWriter().println("{\"code\":\"400\",\"error\":\"Unsupported operation.\"}");
                return;
            }
            try {
                Object returnValue = LeanEngine.getHandler(internalEndpoint.getInternalEndpoint()).execute(req, internalEndpoint.isRPCcall());
                if (internalEndpoint.isNeedResponse()) {
                    String respJSONStr = JSON.toJSONString((Object)returnValue);
                    resp.setContentType("application/json; charset=UTF-8");
                    resp.getWriter().write(respJSONStr);
                    LOGGER.d("resp json string: " + respJSONStr);
                }
            }
            catch (IllegalArgumentException e) {
                if (internalEndpoint.isNeedResponse()) {
                    InvalidParameterException ex = new InvalidParameterException();
                    ex.resp(resp);
                }
                LOGGER.w((Throwable)e);
            }
            catch (Exception e) {
                if (!internalEndpoint.isNeedResponse()) break block10;
                resp.setContentType("application/json; charset=UTF-8");
                JSONObject result = JSONObject.Builder.create(null);
                if (e.getCause() instanceof AVException) {
                    AVException ave = (AVException)e.getCause();
                    result.put((Object)"code", (Object)ave.getCode());
                    result.put((Object)"error", (Object)ave.getMessage());
                    resp.setStatus(400);
                } else {
                    e.printStackTrace();
                    result.put((Object)"code", (Object)1);
                    result.put((Object)"error", (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
                    resp.setStatus(500);
                }
                resp.getWriter().write(result.toJSONString());
            }
        }
    }

    private void setAllowOriginHeader(HttpServletRequest req, HttpServletResponse resp) {
        String allowOrigin = req.getHeader("origin");
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        resp.setHeader("Access-Control-Allow-Origin", allowOrigin);
    }
}

