/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVFile;
import cn.leancloud.AVObject;
import cn.leancloud.json.JSON;
import cn.leancloud.json.JSONArray;
import cn.leancloud.json.JSONObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.AVGeoPoint;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ResponseUtil {
    private static final String TYPE = "__type";

    public static String filterResponse(String response) {
        JSONObject resp = (JSONObject)JSON.parseObject((String)response, JSONObject.class);
        Object result = resp.get((Object)"result");
        if (result instanceof JSONObject) {
            ResponseUtil.removeType((JSONObject)result);
        } else if (result instanceof JSONArray) {
            for (Object o : ((JSONArray)result).toArray()) {
                if (!(o instanceof JSONObject)) continue;
                ResponseUtil.removeType((JSONObject)o);
            }
        }
        return ResponseUtil.restfulCloudData(resp);
    }

    private static void removeType(JSONObject object) {
        if (object.containsKey((Object)"className") && object.containsKey((Object)TYPE)) {
            object.remove((Object)"className");
            object.remove((Object)TYPE);
        }
    }

    static String restfulCloudData(Object object) {
        if (object == null) {
            return "{}";
        }
        if (object instanceof Map) {
            return ResponseUtil.jsonStringFromMapWithNull(Utils.getParsedMap((Map)((Map)object), (boolean)true));
        }
        if (object instanceof Collection) {
            return ResponseUtil.jsonStringFromObjectWithNull(Utils.getParsedList((Collection)((Collection)object), (boolean)true));
        }
        if (object instanceof AVObject) {
            return ResponseUtil.jsonStringFromMapWithNull(Utils.mapFromAVObject((AVObject)((AVObject)object), (boolean)true));
        }
        if (object instanceof AVGeoPoint) {
            return ResponseUtil.jsonStringFromMapWithNull(Utils.mapFromGeoPoint((AVGeoPoint)((AVGeoPoint)object)));
        }
        if (object instanceof Date) {
            return ResponseUtil.jsonStringFromObjectWithNull(Utils.mapFromDate((Date)((Date)object)));
        }
        if (object instanceof byte[]) {
            return ResponseUtil.jsonStringFromMapWithNull(Utils.mapFromByteArray((byte[])((byte[])object)));
        }
        if (object instanceof AVFile) {
            return ResponseUtil.jsonStringFromMapWithNull(((AVFile)object).toMap());
        }
        if (object instanceof JSONObject) {
            return ResponseUtil.jsonStringFromObjectWithNull(JSON.parse((String)object.toString()));
        }
        if (object instanceof JSONArray) {
            return ResponseUtil.jsonStringFromObjectWithNull(JSON.parse((String)object.toString()));
        }
        return ResponseUtil.jsonStringFromObjectWithNull(object);
    }

    static String jsonStringFromMapWithNull(Object map) {
        return JSON.toJSONString((Object)map);
    }

    static String jsonStringFromObjectWithNull(Object map) {
        return JSON.toJSONString((Object)map);
    }
}

