/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

public enum IMHookType {
    rtmClientSign(true),
    clientOnline(false),
    clientOffline(false),
    messageReceived(true),
    receiversOffline(true),
    messageSent(false),
    conversationStart(true),
    conversationStarted(false),
    conversationAdd(true),
    conversationRemove(true),
    conversationAdded(true),
    conversationRemoved(true),
    conversationUpdate(true);

    boolean isResponseNeed;

    private IMHookType(boolean response) {
        this.isResponseNeed = response;
    }

    public String toString() {
        return "_" + this.name();
    }

    public static IMHookType parse(String functionName) {
        if (functionName != null && functionName.startsWith("_")) {
            String hookName = functionName.substring(1);
            if ("messageReceived".equals(hookName)) {
                return messageReceived;
            }
            if ("receiversOffline".equals(hookName)) {
                return receiversOffline;
            }
            if ("messageSent".equals(hookName)) {
                return messageSent;
            }
            if ("conversationStart".equals(hookName)) {
                return conversationStart;
            }
            if ("conversationStarted".equals(hookName)) {
                return conversationStarted;
            }
            if ("conversationAdd".equals(hookName)) {
                return conversationAdd;
            }
            if ("conversationRemove".equals(hookName)) {
                return conversationRemove;
            }
            if ("conversationAdded".equals(hookName)) {
                return conversationAdded;
            }
            if ("conversationRemoved".equals(hookName)) {
                return conversationRemoved;
            }
            if ("conversationUpdate".equals(hookName)) {
                return conversationUpdate;
            }
            if ("clientOnline".equals(hookName)) {
                return clientOnline;
            }
            if ("clientOffline".equals(hookName)) {
                return clientOffline;
            }
            if ("rtmClientSign".equals(hookName)) {
                return rtmClientSign;
            }
        }
        return null;
    }
}

