/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.EngineAppConfiguration;
import cn.leancloud.EngineFunction;
import cn.leancloud.EngineHandlerInfo;
import cn.leancloud.EngineHook;
import cn.leancloud.EngineSessionCookie;
import cn.leancloud.IMHook;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.GeneralRequestSignature;
import cn.leancloud.impl.EnvFirstAppRouter;
import cn.leancloud.logging.InternalLoggerAdapter;
import cn.leancloud.logging.Log4jAdapter;
import cn.leancloud.utils.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class LeanEngine {
    static volatile boolean httpsRedirectionEnabled = false;
    static EngineAppConfiguration appConf;
    private static EnvFirstAppRouter appRouter;
    static final String JSON_CONTENT_TYPE = "application/json; charset=UTF-8";
    private static Map<String, EngineHandlerInfo> funcs;
    private static EngineSessionCookie sessionCookie;

    public static void initialize(String applicationId, String clientKey, String masterKey) {
        String androidKey = EngineAppConfiguration.getEnvOrProperty("LEANCLOUD_APP_ANDX_KEY");
        LeanEngine.initialize(applicationId, clientKey, masterKey, androidKey);
    }

    protected static void initialize(String applicationId, String clientKey, String masterKey, String androidxKey) {
        AVOSCloud.setLogLevel((AVLogger.Level)AVLogger.Level.ALL);
        AppConfiguration.setLogAdapter((InternalLoggerAdapter)new Log4jAdapter());
        AVOSCloud.initialize((String)applicationId, (String)clientKey);
        HashMap<String, String> affiliatedKeys = null;
        if (!StringUtil.isEmpty((String)androidxKey)) {
            affiliatedKeys = new HashMap<String, String>();
            affiliatedKeys.put("ax-sig-1", androidxKey);
        }
        appConf = EngineAppConfiguration.instance(applicationId, clientKey, masterKey, affiliatedKeys);
        appRouter = new EnvFirstAppRouter();
        appRouter.fetchServerHostsInBackground(applicationId).blockingSingle();
    }

    public static void register(Class<?> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            EngineHandlerInfo info;
            IMHook imHook;
            EngineHandlerInfo info2;
            EngineFunction func = m.getAnnotation(EngineFunction.class);
            if (func != null) {
                EngineHandlerInfo info3 = EngineHandlerInfo.getEngineHandlerInfo(m, func);
                if (info3 == null) continue;
                funcs.put(info3.getEndPoint(), info3);
                continue;
            }
            EngineHook hook = m.getAnnotation(EngineHook.class);
            if (hook != null && (info2 = EngineHandlerInfo.getEngineHandlerInfo(m, hook)) != null) {
                funcs.put(info2.getEndPoint(), info2);
            }
            if ((imHook = m.getAnnotation(IMHook.class)) == null || (info = EngineHandlerInfo.getEngineHandlerInfo(m, imHook)) == null) continue;
            funcs.put(info.getEndPoint(), info);
        }
    }

    static EngineHandlerInfo getHandler(String key) {
        return funcs.get(key);
    }

    public static void addSessionCookie(EngineSessionCookie sessionCookie) {
        LeanEngine.sessionCookie = sessionCookie;
    }

    public static EngineSessionCookie getSessionCookie() {
        return sessionCookie;
    }

    public static void setLocalEngineCallEnabled(boolean enabled) {
        appRouter.setLocalEngineCallEnabled(enabled);
    }

    public static void setHttpsRedirectEnabled(boolean enabled) {
        httpsRedirectionEnabled = enabled;
    }

    public static String hmacSha1(String value, String key) {
        try {
            byte[] keyBytes = key.getBytes("UTF-8");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(value.getBytes());
            byte[] hexBytes = new Hex().encode(rawHmac);
            return new String(hexBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setUseMasterKey(boolean useMasterKey) {
        if (useMasterKey) {
            GeneralRequestSignature.setMasterKey((String)appConf.getMasterKey());
        } else {
            GeneralRequestSignature.setMasterKey(null);
        }
    }

    protected static Set<String> getMetaData() {
        return funcs.keySet();
    }

    public static String getAppId() {
        return appConf.getApplicationId();
    }

    public static String getAppKey() {
        return appConf.getClientKey();
    }

    public static String getMasterKey() {
        return appConf.getMasterKey();
    }

    public static String getAndroidKey() {
        Map<String, String> affiliatedKeys = appConf.getAffiliatedKeys();
        if (null == affiliatedKeys) {
            return null;
        }
        if (affiliatedKeys.containsKey("ax-sig-1")) {
            return affiliatedKeys.get("ax-sig-1");
        }
        return null;
    }

    public static String getAppEnv() {
        return appConf.getAppEnv();
    }

    static {
        funcs = new HashMap<String, EngineHandlerInfo>();
    }
}

