/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.session.PeerBasedCommandPacket;
import java.util.Collection;
import java.util.List;

public class SessionControlPacket
extends PeerBasedCommandPacket {
    public static final String USERAGENT = "android/4.7.15";
    private static final long PATCH_FLAG = 1L;
    private static final long PATCH_FLAG_TEMPORARY_CONV = 2L;
    private static final long PATCH_FLAG_BIND_INSTALLATION_TO_SESSION = 4L;
    private static final long PATCH_FLAG_ACK_4_TRANSIENT_MSG = 8L;
    private static final long PATCH_FLAG_SUPPORT_CONVMEMBER_INFO = 32L;
    private String op;
    private Collection<String> sessionPeerIds;
    private String signature;
    private long timestamp;
    private String nonce;
    private boolean reconnectionRequest = false;
    private long lastUnreadNotifyTime = 0L;
    private long lastPatchTime = 0L;
    private long sessionConfig = 0L;
    String tag;
    String sessionToken;

    public SessionControlPacket() {
        this.setCmd("session");
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public boolean isReconnectionRequest() {
        return this.reconnectionRequest;
    }

    public void setReconnectionRequest(boolean reconnectionRequest) {
        this.reconnectionRequest = reconnectionRequest;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setOp(Messages.OpType.valueOf(this.op));
        builder.setSessionMessage(this.getSessionCommand());
        return builder;
    }

    private Messages.SessionCommand getSessionCommand() {
        Messages.SessionCommand.Builder builder = Messages.SessionCommand.newBuilder();
        if (this.sessionPeerIds != null && !this.sessionPeerIds.isEmpty()) {
            builder.addAllSessionPeerIds(this.sessionPeerIds);
        }
        if (this.op.equals("open")) {
            builder.setUa(USERAGENT);
            if (!AVUtils.isBlankString((String)this.tag)) {
                builder.setTag(this.tag);
            }
        }
        if (this.op.equals("open") || this.op.equals("close")) {
            builder.setDeviceId(AVInstallation.getCurrentInstallation().getInstallationId());
        }
        if (!AVUtils.isBlankString((String)this.signature)) {
            builder.setS(this.signature);
            builder.setT(this.timestamp);
            builder.setN(this.nonce);
        }
        if (this.reconnectionRequest) {
            builder.setR(true);
        }
        if (this.lastUnreadNotifyTime > 0L) {
            builder.setLastUnreadNotifTime(this.lastUnreadNotifyTime);
        }
        if (this.lastPatchTime > 0L) {
            builder.setLastPatchTime(this.lastPatchTime);
        }
        if (!AVUtils.isBlankString((String)this.sessionToken)) {
            builder.setSt(this.sessionToken);
        }
        if (0L != this.sessionConfig) {
            builder.setConfigBitmap(this.sessionConfig);
        }
        return builder.build();
    }

    public static SessionControlPacket genSessionCommand(String selfId, List<String> peers, String op, Signature signature, Integer requestId) {
        return SessionControlPacket.genSessionCommand(selfId, peers, op, signature, 0L, 0L, requestId);
    }

    public static SessionControlPacket genSessionCommand(String selfId, List<String> peers, String op, Signature signature, long lastUnreadNotifyTime, long lastPatchTime, Integer requestId) {
        SessionControlPacket scp = new SessionControlPacket();
        if (signature != null && (op.equals("open") || op.equals("add"))) {
            scp.signature = signature.getSignature();
            scp.nonce = signature.getNonce();
            scp.timestamp = signature.getTimestamp();
        }
        scp.op = op;
        scp.sessionPeerIds = peers;
        scp.lastUnreadNotifyTime = lastUnreadNotifyTime;
        scp.lastPatchTime = lastPatchTime;
        scp.sessionConfig |= 0xBL;
        scp.sessionConfig |= 0x20L;
        if (op.equals("refresh")) {
            scp.setPeerId(selfId);
        } else if (op.equals("open")) {
            scp.sessionConfig |= 4L;
            scp.setPeerId(selfId);
        } else if (AVIMClient.getClientsCount() > 1) {
            scp.setPeerId(selfId);
        }
        if (null == requestId) {
            scp.setRequestId(-65537);
        } else {
            scp.setRequestId(requestId);
        }
        return scp;
    }

    public static class SessionControlOp {
        public static final String OPEN = "open";
        public static final String ADD = "add";
        public static final String REMOVE = "remove";
        public static final String CLOSE = "close";
        public static final String QUERY = "query";
        public static final String OPENED = "opened";
        public static final String ADDED = "added";
        public static final String QUERY_RESULT = "query_result";
        public static final String REMOVED = "removed";
        public static final String CLOSED = "closed";
        public static final String RENEW_RTMTOKEN = "refresh";
        public static final String RENEWED_RTMTOKEN = "refreshed";
        public static final String SESSION_TOKEN = "st";
        public static final String SESSION_TOKEN_TTL = "stTtl";
    }
}

