/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.session.PeerBasedCommandPacket;
import java.util.Map;

public class ConversationQueryPacket
extends PeerBasedCommandPacket {
    Map<String, Object> queryParams;

    public ConversationQueryPacket() {
        this.setCmd("conv");
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setConvMessage(this.getConvCommand());
        builder.setOp(Messages.OpType.valueOf("query"));
        return builder;
    }

    protected Messages.ConvCommand getConvCommand() {
        Messages.ConvCommand.Builder builder = Messages.ConvCommand.newBuilder();
        if (null != this.queryParams && !this.queryParams.isEmpty()) {
            Object compact;
            Object whereParam;
            Object limitParam;
            Object skipParam;
            Object sortParam;
            Object tempConvId = this.queryParams.get("temp_id");
            if (null != tempConvId && !AVUtils.isBlankString((String)tempConvId.toString())) {
                builder.addTempConvIds(tempConvId.toString());
            }
            if (null != (sortParam = this.queryParams.get("order")) && !AVUtils.isBlankString((String)sortParam.toString())) {
                builder.setSort(sortParam.toString());
            }
            if (null != (skipParam = this.queryParams.get("skip")) && !AVUtils.isBlankString((String)skipParam.toString())) {
                builder.setSkip(Integer.parseInt(skipParam.toString()));
            }
            if (null != (limitParam = this.queryParams.get("limit")) && !AVUtils.isBlankString((String)limitParam.toString())) {
                builder.setLimit(Integer.parseInt(limitParam.toString()));
            }
            if (null != (whereParam = this.queryParams.get("where")) && !AVUtils.isBlankString((String)whereParam.toString())) {
                Messages.JsonObjectMessage.Builder messageBuild = Messages.JsonObjectMessage.newBuilder();
                messageBuild.setData(whereParam.toString());
                builder.setWhere(messageBuild);
            }
            int flag = 0;
            Object lastMessage = this.queryParams.get("last_message");
            if (null != lastMessage && !AVUtils.isBlankString((String)lastMessage.toString()) && Boolean.parseBoolean(lastMessage.toString())) {
                flag |= 2;
            }
            if (null != (compact = this.queryParams.get("compact")) && !AVUtils.isBlankString((String)compact.toString()) && Boolean.parseBoolean(compact.toString())) {
                flag |= 1;
            }
            if (flag > 0) {
                builder.setFlag(flag);
            }
        }
        return builder.build();
    }

    public static ConversationQueryPacket getConversationQueryPacket(String peerId, Map<String, Object> queryParams, int requestId) {
        ConversationQueryPacket cqp = new ConversationQueryPacket();
        if (AVIMClient.getClientsCount() > 1) {
            cqp.setPeerId(peerId);
        }
        cqp.queryParams = queryParams;
        cqp.setRequestId(requestId);
        return cqp;
    }
}

