/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import android.text.TextUtils;
import com.avos.avoscloud.Messages;
import com.avos.avospush.session.PeerBasedCommandPacket;

public class ConversationAckPacket
extends PeerBasedCommandPacket {
    String conversationId;
    String messageId;
    Long largestTimeStamp;

    public ConversationAckPacket() {
        super.setCmd("ack");
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setTimestamp(long largestTimeStamp) {
        this.largestTimeStamp = largestTimeStamp;
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setAckMessage(this.getAckCommand());
        return builder;
    }

    protected Messages.AckCommand getAckCommand() {
        Messages.AckCommand.Builder builder = Messages.AckCommand.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.messageId)) {
            builder.setMid(this.messageId);
        }
        if (null != this.largestTimeStamp) {
            builder.setTots(this.largestTimeStamp);
        }
        if (!TextUtils.isEmpty((CharSequence)this.conversationId)) {
            builder.setCid(this.conversationId);
        }
        return builder.build();
    }

    public static ConversationAckPacket getConversationAckPacket(String peerId, String conversationId, String messageId) {
        ConversationAckPacket cap = new ConversationAckPacket();
        cap.setPeerId(peerId);
        cap.setConversationId(conversationId);
        cap.setMessageId(messageId);
        return cap;
    }

    public static ConversationAckPacket getConversationAckPacket(String peerId, String conversationId, Long timestamp) {
        ConversationAckPacket cap = new ConversationAckPacket();
        cap.setPeerId(peerId);
        cap.setConversationId(conversationId);
        cap.setTimestamp(timestamp);
        return cap;
    }
}

