/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.im.v2.AVIMBinaryMessage;
import com.avos.avoscloud.im.v2.AVIMChatRoom;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMMessageManager;
import com.avos.avoscloud.im.v2.AVIMServiceConversation;
import com.avos.avoscloud.im.v2.AVIMTemporaryConversation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=8)
class AVIMMessageStorage {
    static final int MESSAGE_INNERTYPE_BIN = 1;
    static final int MESSAGE_INNERTYPE_PLAIN = 0;
    static final String DB_NAME_PREFIX = "com.avos.avoscloud.im.v2.";
    static final String MESSAGE_TABLE = "messages";
    static final String MESSAGE_INDEX = "message_index";
    static final int DB_VERSION = 10;
    static final String COLUMN_MESSAGE_ID = "message_id";
    static final String COLUMN_TIMESTAMP = "timestamp";
    static final String COLUMN_CONVERSATION_ID = "conversation_id";
    static final String COLUMN_FROM_PEER_ID = "from_peer_id";
    static final String COLUMN_MESSAGE_DELIVEREDAT = "receipt_timestamp";
    static final String COLUMN_MESSAGE_READAT = "readAt";
    static final String COLUMN_MESSAGE_UPDATEAT = "updateAt";
    static final String COLUMN_PAYLOAD = "payload";
    static final String COLUMN_STATUS = "status";
    static final String COLUMN_BREAKPOINT = "breakpoint";
    static final String COLUMN_DEDUPLICATED_TOKEN = "dtoken";
    static final String COLUMN_MSG_MENTION_ALL = "mentionAll";
    static final String COLUMN_MSG_MENTION_LIST = "mentionList";
    static final String COLUMN_MSG_INNERTYPE = "iType";
    static final String CONVERSATION_TABLE = "conversations";
    static final String COLUMN_EXPIREAT = "expireAt";
    static final String COLUMN_ATTRIBUTE = "attr";
    static final String COLUMN_INSTANCEDATA = "instanceData";
    static final String COLUMN_UPDATEDAT = "updatedAt";
    static final String COLUMN_CREATEDAT = "createdAt";
    static final String COLUMN_CREATOR = "creator";
    static final String COLUMN_MEMBERS = "members";
    static final String COLUMN_LM = "lm";
    static final String COLUMN_LASTMESSAGE = "last_message";
    static final String COLUMN_TRANSIENT = "isTransient";
    static final String COLUMN_UNREAD_COUNT = "unread_count";
    static final String COLUMN_CONV_MENTIONED = "mentioned";
    static final String COLUMN_CONVERSATION_READAT = "readAt";
    static final String COLUMN_CONVRESATION_DELIVEREDAT = "deliveredAt";
    static final String COLUMN_CONV_LASTMESSAGE_INNERTYPE = "last_msg_iType";
    static final String COLUMN_CONV_TEMP = "temp";
    static final String COLUMN_CONV_TEMP_TTL = "temp_ttl";
    static final String COLUMN_CONV_SYSTEM = "sys";
    static final String NUMBERIC = "NUMBERIC";
    static final String INTEGER = "INTEGER";
    static final String BLOB = "BLOB";
    static final String TEXT = "TEXT";
    static final String VARCHAR32 = "VARCHAR(32)";
    private DBHelper dbHelper;
    private static ConcurrentHashMap<String, AVIMMessageStorage> storages = new ConcurrentHashMap();
    String clientId;

    private AVIMMessageStorage(Context context, String clientId) {
        this.dbHelper = new DBHelper(context, clientId);
        this.dbHelper.onUpgrade(this.dbHelper.getWritableDatabase(), this.dbHelper.getWritableDatabase().getVersion(), 10);
        this.clientId = clientId;
    }

    public static synchronized AVIMMessageStorage getInstance(String clientId) {
        AVIMMessageStorage storage = storages.get(clientId);
        if (storage != null) {
            return storage;
        }
        storage = new AVIMMessageStorage(AVOSCloud.applicationContext, clientId);
        AVIMMessageStorage elderStorage = storages.putIfAbsent(clientId, storage);
        return elderStorage == null ? storage : elderStorage;
    }

    private static String getWhereClause(String ... columns) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (String column : columns) {
            conditions.add(column + " = ? ");
        }
        return TextUtils.join((CharSequence)" and ", conditions);
    }

    public void insertMessage(AVIMMessage message, boolean breakpoint) {
        if (null == message) {
            return;
        }
        this.insertMessages(Arrays.asList(message), breakpoint);
    }

    public synchronized boolean insertLocalMessage(AVIMMessage message) {
        if (null == message || !AVUtils.isBlankString((String)message.getMessageId()) || AVUtils.isBlankString((String)message.conversationId) || AVUtils.isBlankString((String)message.uniqueToken)) {
            if (null == message) {
                LogUtil.avlog.e((String)"message is null");
            } else {
                LogUtil.avlog.e((String)String.format("invalid state. msgId=%s, convId=%s, uniToken=%s", message.getMessageId(), message.conversationId, message.uniqueToken));
            }
            return false;
        }
        String internalMessageId = this.generateInternalMessageId(message.uniqueToken);
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put(COLUMN_CONVERSATION_ID, message.conversationId);
            values.put(COLUMN_MESSAGE_ID, internalMessageId);
            values.put(COLUMN_TIMESTAMP, Long.valueOf(message.getTimestamp()));
            values.put(COLUMN_FROM_PEER_ID, message.getFrom());
            if (message instanceof AVIMBinaryMessage) {
                values.put(COLUMN_PAYLOAD, ((AVIMBinaryMessage)message).getBytes());
                values.put(COLUMN_MSG_INNERTYPE, Integer.valueOf(1));
            } else {
                values.put(COLUMN_PAYLOAD, message.getContent().getBytes());
            }
            values.put(COLUMN_MESSAGE_DELIVEREDAT, Long.valueOf(message.getDeliveredAt()));
            values.put("readAt", Long.valueOf(message.getReadAt()));
            values.put(COLUMN_MESSAGE_UPDATEAT, Long.valueOf(message.getUpdateAt()));
            values.put(COLUMN_STATUS, Integer.valueOf(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusFailed.getStatusCode()));
            values.put(COLUMN_BREAKPOINT, Integer.valueOf(0));
            values.put(COLUMN_DEDUPLICATED_TOKEN, message.uniqueToken);
            values.put(COLUMN_MSG_MENTION_ALL, Integer.valueOf(message.isMentionAll() ? 1 : 0));
            values.put(COLUMN_MSG_MENTION_LIST, message.getMentionListString());
            long ret = db.insertWithOnConflict(MESSAGE_TABLE, null, values, 4);
            if (ret < 0L) {
                LogUtil.avlog.e((String)("failed to insert Message table. values=" + values.toString()));
            }
            return ret != -1L;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public synchronized boolean removeLocalMessage(AVIMMessage message) {
        if (null == message || AVUtils.isBlankString((String)message.conversationId) || AVUtils.isBlankString((String)message.uniqueToken)) {
            return false;
        }
        String internalMessageId = this.generateInternalMessageId(message.uniqueToken);
        String status = String.valueOf(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusFailed.getStatusCode());
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            int ret = db.delete(MESSAGE_TABLE, "conversation_id = ? and message_id = ? and status = ? and dtoken = ? ", new String[]{message.conversationId, internalMessageId, status, message.uniqueToken});
            return ret > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String generateInternalMessageId(String uniqueToken) {
        if (AVUtils.isBlankString((String)uniqueToken)) {
            return "";
        }
        return uniqueToken;
    }

    private synchronized int insertMessages(List<AVIMMessage> messages, boolean breakpoint) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.beginTransaction();
        int insertCount = 0;
        for (AVIMMessage message : messages) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_CONVERSATION_ID, message.getConversationId());
            values.put(COLUMN_MESSAGE_ID, message.getMessageId());
            values.put(COLUMN_TIMESTAMP, Long.valueOf(message.getTimestamp()));
            values.put(COLUMN_FROM_PEER_ID, message.getFrom());
            if (message instanceof AVIMBinaryMessage) {
                values.put(COLUMN_PAYLOAD, ((AVIMBinaryMessage)message).getBytes());
                values.put(COLUMN_MSG_INNERTYPE, Integer.valueOf(1));
            } else {
                values.put(COLUMN_PAYLOAD, message.getContent().getBytes());
                values.put(COLUMN_MSG_INNERTYPE, Integer.valueOf(0));
            }
            values.put(COLUMN_MESSAGE_DELIVEREDAT, Long.valueOf(message.getDeliveredAt()));
            values.put("readAt", Long.valueOf(message.getReadAt()));
            values.put(COLUMN_MESSAGE_UPDATEAT, Long.valueOf(message.getUpdateAt()));
            values.put(COLUMN_STATUS, Integer.valueOf(message.getMessageStatus().getStatusCode()));
            values.put(COLUMN_BREAKPOINT, Integer.valueOf(breakpoint ? 1 : 0));
            values.put(COLUMN_MSG_MENTION_ALL, Integer.valueOf(message.isMentionAll() ? 1 : 0));
            values.put(COLUMN_MSG_MENTION_LIST, message.getMentionListString());
            try {
                long itemId = db.insertWithOnConflict(MESSAGE_TABLE, null, values, 5);
                boolean insert = itemId > -1L;
                if (!insert) continue;
                ++insertCount;
            }
            catch (SQLException e) {
                if (!AVOSCloud.isDebugLogEnabled()) continue;
                e.printStackTrace();
            }
        }
        db.setTransactionSuccessful();
        db.endTransaction();
        return insertCount;
    }

    public void insertContinuousMessages(List<AVIMMessage> messages, String conversationId) {
        AVIMMessage eldestMessage;
        if (null == messages || messages.isEmpty() || AVUtils.isBlankString((String)conversationId)) {
            return;
        }
        AVIMMessage firstMessage = messages.get(0);
        List<AVIMMessage> tailMessages = messages.subList(1, messages.size());
        AVIMMessage lastMessage = messages.get(messages.size() - 1);
        if (!this.containMessage(lastMessage) && (eldestMessage = this.getNextMessage(lastMessage)) != null) {
            this.updateBreakpoints(Arrays.asList(eldestMessage), true, conversationId);
        }
        if (!tailMessages.isEmpty()) {
            this.insertMessages(tailMessages, false);
            this.updateBreakpoints(tailMessages, false, conversationId);
        }
        this.insertMessage(firstMessage, true);
    }

    public boolean containMessage(AVIMMessage message) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(MESSAGE_TABLE, new String[0], AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID, COLUMN_MESSAGE_ID), new String[]{message.conversationId, message.getMessageId()}, null, null, null);
        boolean contained = cursor.getCount() > 0;
        cursor.close();
        return contained;
    }

    protected synchronized void updateBreakpoints(List<AVIMMessage> messages, boolean breakpoint, String conversationId) {
        int batchSize = 900;
        if (messages.size() > batchSize) {
            this.updateBreakpointsForBatch(messages.subList(0, batchSize), breakpoint, conversationId);
            this.updateBreakpoints(messages.subList(batchSize, messages.size()), breakpoint, conversationId);
        } else {
            this.updateBreakpointsForBatch(messages, breakpoint, conversationId);
        }
    }

    private synchronized int updateBreakpointsForBatch(List<AVIMMessage> messages, boolean breakpoint, String conversationId) {
        String[] arguments = new String[messages.size()];
        ArrayList<String> placeholders = new ArrayList<String>();
        for (int i = 0; i < messages.size(); ++i) {
            AVIMMessage message = messages.get(i);
            arguments[i] = message.getMessageId();
            placeholders.add("?");
        }
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_BREAKPOINT, Integer.valueOf(breakpoint ? 1 : 0));
        String joinedPlaceholders = TextUtils.join((CharSequence)",", placeholders);
        int updateCount = db.update(MESSAGE_TABLE, cv, "message_id in (" + joinedPlaceholders + ") ", arguments);
        return updateCount;
    }

    public synchronized boolean updateMessage(AVIMMessage message, String originalId) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(COLUMN_TIMESTAMP, Long.valueOf(message.getTimestamp()));
        values.put(COLUMN_STATUS, Integer.valueOf(message.getMessageStatus().getStatusCode()));
        values.put(COLUMN_MESSAGE_DELIVEREDAT, Long.valueOf(message.getDeliveredAt()));
        values.put("readAt", Long.valueOf(message.getReadAt()));
        values.put(COLUMN_MESSAGE_UPDATEAT, Long.valueOf(message.getUpdateAt()));
        values.put(COLUMN_MESSAGE_ID, message.getMessageId());
        values.put(COLUMN_MSG_MENTION_ALL, Integer.valueOf(message.isMentionAll() ? 1 : 0));
        values.put(COLUMN_MSG_MENTION_LIST, message.getMentionListString());
        long itemId = db.update(MESSAGE_TABLE, values, AVIMMessageStorage.getWhereClause(COLUMN_MESSAGE_ID), new String[]{originalId});
        return itemId > -1L;
    }

    synchronized boolean updateMessageForPatch(AVIMMessage message) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        if (message instanceof AVIMBinaryMessage) {
            values.put(COLUMN_PAYLOAD, ((AVIMBinaryMessage)message).getBytes());
            values.put(COLUMN_MSG_INNERTYPE, Integer.valueOf(1));
        } else {
            values.put(COLUMN_PAYLOAD, message.getContent());
            values.put(COLUMN_MSG_INNERTYPE, Integer.valueOf(0));
        }
        values.put(COLUMN_STATUS, Integer.valueOf(message.getMessageStatus().getStatusCode()));
        values.put(COLUMN_MESSAGE_UPDATEAT, Long.valueOf(message.getUpdateAt()));
        long itemId = db.update(MESSAGE_TABLE, values, AVIMMessageStorage.getWhereClause(COLUMN_MESSAGE_ID), new String[]{message.getMessageId()});
        return itemId > -1L;
    }

    public synchronized void deleteMessages(List<AVIMMessage> messages, String conversationId) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        for (AVIMMessage message : messages) {
            String messageId = message.getMessageId();
            AVIMMessage nextMessage = this.getNextMessage(message);
            if (nextMessage != null) {
                this.updateBreakpoints(Arrays.asList(message), true, conversationId);
            }
            db.delete(MESSAGE_TABLE, AVIMMessageStorage.getWhereClause(COLUMN_MESSAGE_ID), new String[]{messageId});
        }
    }

    public synchronized void deleteConversationData(String conversationId) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete(MESSAGE_TABLE, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversationId});
        db.delete(CONVERSATION_TABLE, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversationId});
    }

    public synchronized void deleteClientData() {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete(MESSAGE_TABLE, null, null);
        db.delete(CONVERSATION_TABLE, null, null);
    }

    void getMessage(String msgId, long timestamp, String conversationId, StorageMessageCallback callback) {
        if (timestamp == 0L) {
            callback.done(null, false);
        } else {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = msgId == null ? db.query(MESSAGE_TABLE, null, AVIMMessageStorage.getWhereClause(COLUMN_TIMESTAMP, COLUMN_CONVERSATION_ID), new String[]{Long.toString(timestamp), conversationId}, null, null, null, "1") : db.query(MESSAGE_TABLE, null, AVIMMessageStorage.getWhereClause(COLUMN_MESSAGE_ID), new String[]{msgId}, null, null, null, "1");
            AVIMMessage message = null;
            boolean breakpoint = false;
            if (cursor.moveToFirst()) {
                message = this.createMessageFromCursor(cursor);
                breakpoint = cursor.getInt(cursor.getColumnIndex(COLUMN_BREAKPOINT)) != 0;
            }
            cursor.close();
            callback.done(message, breakpoint);
        }
    }

    void dumpMessages(String conversationId) {
        String[] conditionArgs;
        String condition;
        long curTs = System.currentTimeMillis();
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(MESSAGE_TABLE, null, condition = "timestamp < ? and conversation_id = ? ", conditionArgs = new String[]{Long.toString(curTs), conversationId}, null, null, "timestamp desc, message_id desc");
        if (cursor.moveToFirst()) {
            while (!cursor.isAfterLast()) {
                AVIMMessage message = this.createMessageFromCursor(cursor);
                boolean breakpoint = cursor.getInt(cursor.getColumnIndex(COLUMN_BREAKPOINT)) != 0;
                System.out.println("msg: {id=" + message.getMessageId() + ", ts=" + message.getTimestamp() + ", breakpoint=" + breakpoint + "}");
                cursor.moveToNext();
            }
        }
    }

    public void getMessages(String msgId, long timestamp, int limit, String conversationId, StorageQueryCallback callback) {
        String[] selectionArgs;
        String selection;
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        if (timestamp > 0L) {
            if (msgId == null) {
                selection = "timestamp < ? and conversation_id = ? ";
                selectionArgs = new String[]{Long.toString(timestamp), conversationId};
            } else {
                selection = " ( timestamp < ? or (timestamp = ? and message_id < ? )) and conversation_id = ? ";
                selectionArgs = new String[]{Long.toString(timestamp), Long.toString(timestamp), msgId, conversationId};
            }
        } else {
            selection = AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID);
            selectionArgs = new String[]{conversationId};
        }
        Cursor cursor = db.query(MESSAGE_TABLE, null, selection, selectionArgs, null, null, "timestamp desc, message_id desc", limit + "");
        this.processMessages(cursor, callback);
    }

    public long getMessageCount(String conversationId) {
        AVIMMessage lastBreakPointMessage = this.getLatestMessageWithBreakpoint(conversationId, true);
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        long messageCount = 0L;
        messageCount = lastBreakPointMessage == null ? DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)"select count(*) from messages where conversation_id = ?", (String[])new String[]{conversationId}) : DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)"select count(*) from messages where conversation_id = ? and (timestamp > ? or ( timestamp = ? and message_id >= ? )) order by timestamp desc, message_id desc", (String[])new String[]{conversationId, String.valueOf(lastBreakPointMessage.timestamp), String.valueOf(lastBreakPointMessage.timestamp), lastBreakPointMessage.messageId});
        return messageCount;
    }

    private AVIMMessage createMessageFromCursor(Cursor cursor) {
        String mid = cursor.getString(cursor.getColumnIndex(COLUMN_MESSAGE_ID));
        long timestamp = cursor.getLong(cursor.getColumnIndex(COLUMN_TIMESTAMP));
        String cid = cursor.getString(cursor.getColumnIndex(COLUMN_CONVERSATION_ID));
        String from = cursor.getString(cursor.getColumnIndex(COLUMN_FROM_PEER_ID));
        long deliveredAt = cursor.getLong(cursor.getColumnIndex(COLUMN_MESSAGE_DELIVEREDAT));
        long readAt = cursor.getLong(cursor.getColumnIndex("readAt"));
        long updateAt = cursor.getLong(cursor.getColumnIndex(COLUMN_MESSAGE_UPDATEAT));
        byte[] payload = cursor.getBlob(cursor.getColumnIndex(COLUMN_PAYLOAD));
        String uniqueToken = cursor.getString(cursor.getColumnIndex(COLUMN_DEDUPLICATED_TOKEN));
        int status = cursor.getInt(cursor.getColumnIndex(COLUMN_STATUS));
        int mentionAll = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_MENTION_ALL));
        String mentionListStr = cursor.getString(cursor.getColumnIndex(COLUMN_MSG_MENTION_LIST));
        int innerType = cursor.getInt(cursor.getColumnIndex(COLUMN_MSG_INNERTYPE));
        AVIMMessage message = null;
        if (innerType == 1) {
            message = new AVIMBinaryMessage(cid, from, timestamp, deliveredAt, readAt);
            ((AVIMBinaryMessage)message).setBytes(payload);
        } else {
            message = new AVIMMessage(cid, from, timestamp, deliveredAt, readAt);
            message.setContent(new String(payload));
        }
        message.setMessageId(mid);
        message.setUniqueToken(uniqueToken);
        message.setMessageStatus(AVIMMessage.AVIMMessageStatus.getMessageStatus(status));
        message.setUpdateAt(updateAt);
        message.setMentionAll(mentionAll == 1);
        message.setCurrentClient(this.clientId);
        if (!AVUtils.isBlankString((String)mentionListStr)) {
            message.setMentionListString(mentionListStr);
        }
        return AVIMMessageManager.parseTypedMessage(message);
    }

    private void processMessages(Cursor cursor, StorageQueryCallback callback) {
        ArrayList<AVIMMessage> messages = Collections.EMPTY_LIST;
        ArrayList<Boolean> breakpoints = Collections.EMPTY_LIST;
        if (cursor.moveToFirst()) {
            messages = new ArrayList<AVIMMessage>();
            breakpoints = new ArrayList<Boolean>();
            while (!cursor.isAfterLast()) {
                AVIMMessage message = this.createMessageFromCursor(cursor);
                messages.add(message);
                boolean breakpoint = cursor.getInt(cursor.getColumnIndex(COLUMN_BREAKPOINT)) != 0;
                breakpoints.add(breakpoint);
                cursor.moveToNext();
            }
        }
        cursor.close();
        callback.done(messages, (List<Boolean>)breakpoints);
    }

    protected AVIMMessage getNextMessage(AVIMMessage currentMessage) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(MESSAGE_TABLE, null, " ( timestamp > ? or (timestamp = ? and message_id > ? )) and conversation_id = ? ", new String[]{Long.toString(currentMessage.getTimestamp()), Long.toString(currentMessage.getTimestamp()), currentMessage.getMessageId(), currentMessage.getConversationId()}, null, null, "timestamp , message_id", "1");
        AVIMMessage message = null;
        if (cursor.moveToFirst()) {
            message = this.createMessageFromCursor(cursor);
        }
        cursor.close();
        return message;
    }

    AVIMMessage getLatestMessage(String conversationId) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(MESSAGE_TABLE, null, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversationId}, null, null, "timestamp desc, message_id desc", "1");
        AVIMMessage message = null;
        if (cursor.moveToFirst()) {
            message = this.createMessageFromCursor(cursor);
        }
        cursor.close();
        return message;
    }

    AVIMMessage getLatestMessageWithBreakpoint(String conversationId, boolean breakpoint) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(MESSAGE_TABLE, null, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID, COLUMN_BREAKPOINT), new String[]{conversationId, breakpoint ? "1" : "0"}, null, null, "timestamp desc, message_id desc", "1");
        AVIMMessage message = null;
        if (cursor.moveToFirst()) {
            message = this.createMessageFromCursor(cursor);
        }
        cursor.close();
        return message;
    }

    public void insertConversations(List<AVIMConversation> conversations) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.beginTransaction();
        for (AVIMConversation conversation : conversations) {
            AVIMMessage message;
            ContentValues values = new ContentValues();
            values.put(COLUMN_ATTRIBUTE, JSON.toJSONString(conversation.attributes));
            values.put(COLUMN_INSTANCEDATA, JSON.toJSONString(conversation.instanceData));
            values.put(COLUMN_CREATEDAT, conversation.createdAt);
            values.put(COLUMN_UPDATEDAT, conversation.updatedAt);
            values.put(COLUMN_CREATOR, conversation.creator);
            values.put(COLUMN_EXPIREAT, Long.valueOf(System.currentTimeMillis() + 3600000L));
            if (conversation.lastMessageAt != null) {
                values.put(COLUMN_LM, Long.valueOf(conversation.lastMessageAt.getTime()));
            }
            if (null != (message = conversation.getLastMessage())) {
                if (message instanceof AVIMBinaryMessage) {
                    byte[] bytes = ((AVIMBinaryMessage)message).getBytes();
                    String base64Msg = AVUtils.base64Encode((byte[])bytes);
                    values.put(COLUMN_LASTMESSAGE, base64Msg);
                    values.put(COLUMN_CONV_LASTMESSAGE_INNERTYPE, Integer.valueOf(1));
                } else {
                    String lastMessage = JSON.toJSONString((Object)message);
                    values.put(COLUMN_LASTMESSAGE, lastMessage);
                    values.put(COLUMN_CONV_LASTMESSAGE_INNERTYPE, Integer.valueOf(0));
                }
            }
            values.put(COLUMN_MEMBERS, JSON.toJSONString(conversation.getMembers()));
            values.put(COLUMN_TRANSIENT, Integer.valueOf(conversation.isTransient ? 1 : 0));
            values.put(COLUMN_UNREAD_COUNT, Integer.valueOf(conversation.getUnreadMessagesCount()));
            values.put(COLUMN_CONV_MENTIONED, Integer.valueOf(conversation.unreadMessagesMentioned() ? 1 : 0));
            values.put("readAt", Long.valueOf(conversation.getLastReadAt()));
            values.put(COLUMN_CONVRESATION_DELIVEREDAT, Long.valueOf(conversation.getLastDeliveredAt()));
            values.put(COLUMN_CONVERSATION_ID, conversation.getConversationId());
            values.put(COLUMN_CONV_SYSTEM, Integer.valueOf(conversation.isSystem() ? 1 : 0));
            values.put(COLUMN_CONV_TEMP, Integer.valueOf(conversation.isTemporary() ? 1 : 0));
            values.put(COLUMN_CONV_TEMP_TTL, Long.valueOf(conversation.getTemporaryExpiredat()));
            db.insertWithOnConflict(CONVERSATION_TABLE, null, values, 5);
        }
        db.setTransactionSuccessful();
        db.endTransaction();
    }

    boolean updateConversationTimes(AVIMConversation conversation) {
        if (this.getConversation(conversation.getConversationId()) != null) {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("readAt", Long.valueOf(conversation.getLastReadAt()));
            values.put(COLUMN_CONVRESATION_DELIVEREDAT, Long.valueOf(conversation.getLastDeliveredAt()));
            long dbId = db.update(CONVERSATION_TABLE, values, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversation.getConversationId()});
            return dbId != -1L;
        }
        return false;
    }

    boolean updateConversationUreadCount(String conversationId, long unreadCount, boolean mentioned) {
        if (this.getConversation(conversationId) != null) {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put(COLUMN_UNREAD_COUNT, Long.valueOf(unreadCount));
            values.put(COLUMN_CONV_MENTIONED, Integer.valueOf(mentioned ? 1 : 0));
            long dbId = db.update(CONVERSATION_TABLE, values, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversationId});
            return dbId != -1L;
        }
        return false;
    }

    public boolean updateConversationLastMessageAt(AVIMConversation conversation) {
        if (this.getConversation(conversation.getConversationId()) != null && conversation.getLastMessageAt() != null) {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put(COLUMN_LM, Long.valueOf(conversation.getLastMessageAt().getTime()));
            long dbId = db.update(CONVERSATION_TABLE, values, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversation.getConversationId()});
            return dbId != -1L;
        }
        return false;
    }

    public List<AVIMConversation> getAllCachedConversations() {
        LinkedList<AVIMConversation> conversations = new LinkedList<AVIMConversation>();
        long currentTs = System.currentTimeMillis();
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(CONVERSATION_TABLE, null, "(temp < 1 and expireAt > ?) or (temp> 0 and temp_ttl > ?)", new String[]{String.valueOf(currentTs), String.valueOf(currentTs / 1000L)}, null, null, null, null);
        if (cursor.moveToFirst()) {
            while (!cursor.isAfterLast()) {
                conversations.add(this.parseConversationFromCursor(cursor));
                cursor.moveToNext();
            }
        }
        cursor.close();
        return conversations;
    }

    private AVIMConversation parseConversationFromCursor(Cursor cursor) {
        AVIMConversation conversation;
        long deliveredAt;
        long readAt;
        int mentioned;
        int unreadCount;
        long lastMessageTS;
        String creator;
        block9: {
            String conversationId = cursor.getString(cursor.getColumnIndex(COLUMN_CONVERSATION_ID));
            String createdAt = cursor.getString(cursor.getColumnIndex(COLUMN_CREATEDAT));
            String updatedAt = cursor.getString(cursor.getColumnIndex(COLUMN_UPDATEDAT));
            String membersStr = cursor.getString(cursor.getColumnIndex(COLUMN_MEMBERS));
            String attrsStr = cursor.getString(cursor.getColumnIndex(COLUMN_ATTRIBUTE));
            String instanceData = cursor.getString(cursor.getColumnIndex(COLUMN_INSTANCEDATA));
            creator = cursor.getString(cursor.getColumnIndex(COLUMN_CREATOR));
            lastMessageTS = cursor.getLong(cursor.getColumnIndex(COLUMN_LM));
            int transientValue = cursor.getInt(cursor.getColumnIndex(COLUMN_TRANSIENT));
            unreadCount = cursor.getInt(cursor.getColumnIndex(COLUMN_UNREAD_COUNT));
            mentioned = cursor.getInt(cursor.getColumnIndex(COLUMN_CONV_MENTIONED));
            readAt = cursor.getLong(cursor.getColumnIndex("readAt"));
            deliveredAt = cursor.getLong(cursor.getColumnIndex(COLUMN_CONVRESATION_DELIVEREDAT));
            String lastMessage = cursor.getString(cursor.getColumnIndex(COLUMN_LASTMESSAGE));
            int lastMessageInnerType = cursor.getInt(cursor.getColumnIndex(COLUMN_CONV_LASTMESSAGE_INNERTYPE));
            int system = cursor.getInt(cursor.getColumnIndex(COLUMN_CONV_SYSTEM));
            int temporary = cursor.getInt(cursor.getColumnIndex(COLUMN_CONV_TEMP));
            conversation = null;
            if (temporary > 0) {
                conversation = new AVIMTemporaryConversation(AVIMClient.getInstance(this.clientId), conversationId);
                long tempExpiredAt = cursor.getLong(cursor.getColumnIndex(COLUMN_CONV_TEMP_TTL));
                conversation.setTemporaryExpiredat(tempExpiredAt);
            } else {
                conversation = system > 0 ? new AVIMServiceConversation(AVIMClient.getInstance(this.clientId), conversationId) : (transientValue > 0 ? new AVIMChatRoom(AVIMClient.getInstance(this.clientId), conversationId) : new AVIMConversation(AVIMClient.getInstance(this.clientId), conversationId));
            }
            conversation.createdAt = createdAt;
            conversation.updatedAt = updatedAt;
            try {
                conversation.members.clear();
                if (!AVUtils.isBlankContent((String)membersStr)) {
                    conversation.members.addAll((Collection)JSON.parseObject((String)membersStr, Set.class));
                }
                conversation.attributes.clear();
                if (!AVUtils.isBlankContent((String)attrsStr)) {
                    conversation.attributes.putAll((Map)JSON.parseObject((String)attrsStr, HashMap.class));
                }
                conversation.instanceData.clear();
                if (!AVUtils.isBlankContent((String)instanceData)) {
                    conversation.instanceData.putAll((Map)JSON.parseObject((String)instanceData, HashMap.class));
                }
                if (lastMessageInnerType != 1) {
                    AVIMMessage msg;
                    conversation.lastMessage = msg = (AVIMMessage)JSON.parseObject((String)lastMessage, AVIMMessage.class);
                } else {
                    AVIMBinaryMessage binaryMsg = new AVIMBinaryMessage(conversationId, null);
                    binaryMsg.setBytes(AVUtils.base64Decode((String)lastMessage));
                    conversation.lastMessage = binaryMsg;
                }
            }
            catch (Exception e) {
                if (!AVOSCloud.isDebugLogEnabled()) break block9;
                LogUtil.avlog.e((String)("error during conversation cache parse:" + e.getMessage()));
            }
        }
        conversation.creator = creator;
        conversation.lastMessageAt = new Date(lastMessageTS);
        conversation.unreadMessagesCount = unreadCount;
        conversation.unreadMessagesMentioned = mentioned == 1;
        conversation.lastReadAt = readAt;
        conversation.lastDeliveredAt = deliveredAt;
        return conversation;
    }

    public AVIMConversation getConversation(String conversationId) {
        AVIMConversation conversation = null;
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query(CONVERSATION_TABLE, null, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID) + " and " + COLUMN_EXPIREAT + " > ?", new String[]{conversationId, String.valueOf(System.currentTimeMillis())}, null, null, null, null);
        if (cursor.moveToFirst() && !cursor.isAfterLast()) {
            conversation = this.parseConversationFromCursor(cursor);
        }
        cursor.close();
        return conversation;
    }

    public List<AVIMConversation> getCachedConversations(List<String> conversationIds) {
        LinkedList<AVIMConversation> conversations = new LinkedList<AVIMConversation>();
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("SELECT * FROM conversations WHERE conversation_id in ('" + AVUtils.joinCollection(conversationIds, (String)"','") + "')", null);
        if (cursor.moveToFirst()) {
            while (!cursor.isAfterLast()) {
                conversations.add(this.parseConversationFromCursor(cursor));
                cursor.moveToNext();
            }
        }
        cursor.close();
        return conversations;
    }

    public void deleteConversation(String conversationId) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete(CONVERSATION_TABLE, AVIMMessageStorage.getWhereClause(COLUMN_CONVERSATION_ID), new String[]{conversationId});
    }

    public static interface StorageMessageCallback {
        public void done(AVIMMessage var1, boolean var2);
    }

    public static interface StorageQueryCallback {
        public void done(List<AVIMMessage> var1, List<Boolean> var2);
    }

    static class DBHelper
    extends SQLiteOpenHelper {
        static final String MESSAGE_CREATE_SQL = "CREATE TABLE IF NOT EXISTS messages (conversation_id VARCHAR(32) NOT NULL, message_id VARCHAR(32) NOT NULL, timestamp NUMBERIC, from_peer_id TEXT NOT NULL, receipt_timestamp NUMBERIC, readAt NUMBERIC, updateAt NUMBERIC, payload BLOB, status INTEGER, breakpoint INTEGER, dtoken VARCHAR(32), mentionAll INTEGER default 0, mentionList TEXT NULL, iType INTEGER default 0, PRIMARY KEY(conversation_id,message_id)) ";
        static final String MESSAGE_UNIQUE_INDEX_SQL = "CREATE UNIQUE INDEX IF NOT EXISTS message_index on messages (conversation_id, timestamp, message_id) ";
        static final String CONVERSATION_CREATE_SQL = "CREATE TABLE IF NOT EXISTS conversations (conversation_id VARCHAR(32) NOT NULL,expireAt NUMBERIC,attr BLOB,instanceData BLOB,updatedAt VARCHAR(32),createdAt VARCHAR(32),creator TEXT,members TEXT,isTransient INTEGER,unread_count INTEGER,readAt NUMBERIC,deliveredAt NUMBERIC,lm NUMBERIC,last_message TEXT,mentioned INTEGER default 0,last_msg_iType INTEGER default 0, sys INTEGER default 0, temp INTEGER default 0, temp_ttl NUMBERIC, PRIMARY KEY(conversation_id))";

        public DBHelper(Context context, String clientId) {
            super(context, DBHelper.getDatabasePath(clientId), null, 10);
        }

        private static String getDatabasePath(String clientId) {
            return AVIMMessageStorage.DB_NAME_PREFIX + clientId;
        }

        private static String getAddColumnSql(String table, String column, String type) {
            return String.format("ALTER TABLE %s ADD COLUMN %s %s;", table, column, type);
        }

        private static String getAddColumnSql(String table, String column, String type, String defaultV) {
            return String.format("ALTER TABLE %s ADD COLUMN %s %s default %s;", table, column, type, defaultV);
        }

        public void onCreate(SQLiteDatabase sqLiteDatabase) {
            sqLiteDatabase.execSQL(MESSAGE_CREATE_SQL);
            sqLiteDatabase.execSQL(MESSAGE_UNIQUE_INDEX_SQL);
            sqLiteDatabase.execSQL(CONVERSATION_CREATE_SQL);
        }

        public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            if (oldVersion == 1) {
                this.upgradeToVersion2(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 2) {
                this.upgradeToVersion3(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 3) {
                this.upgradeToVersion4(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 4) {
                this.upgradeToVersion5(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 5) {
                this.upgradeToVersion6(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 6) {
                this.upgradeToVersion7(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 7) {
                this.upgradeToVersion8(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 8) {
                this.upgradeToVersion9(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 9) {
                this.upgradeToVersion10(sqLiteDatabase);
                ++oldVersion;
            }
        }

        private void upgradeToVersion2(SQLiteDatabase db) {
            db.execSQL(CONVERSATION_CREATE_SQL);
        }

        private void upgradeToVersion3(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_DEDUPLICATED_TOKEN)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_DEDUPLICATED_TOKEN, AVIMMessageStorage.VARCHAR32));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion4(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_LASTMESSAGE)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_LASTMESSAGE, AVIMMessageStorage.TEXT));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion5(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_INSTANCEDATA)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_INSTANCEDATA, AVIMMessageStorage.BLOB));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion6(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_UNREAD_COUNT)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_UNREAD_COUNT, AVIMMessageStorage.INTEGER));
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, "readAt", AVIMMessageStorage.NUMBERIC));
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONVRESATION_DELIVEREDAT, AVIMMessageStorage.NUMBERIC));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, "readAt")) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, "readAt", AVIMMessageStorage.NUMBERIC));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion7(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MESSAGE_UPDATEAT)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MESSAGE_UPDATEAT, AVIMMessageStorage.NUMBERIC));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion8(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_MENTION_ALL)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_MENTION_ALL, AVIMMessageStorage.INTEGER, "0"));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_MENTION_LIST)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_MENTION_LIST, AVIMMessageStorage.TEXT));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_MENTIONED)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_MENTIONED, AVIMMessageStorage.INTEGER, "0"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion9(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_INNERTYPE)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.MESSAGE_TABLE, AVIMMessageStorage.COLUMN_MSG_INNERTYPE, AVIMMessageStorage.INTEGER, "0"));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_LASTMESSAGE_INNERTYPE)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_LASTMESSAGE_INNERTYPE, AVIMMessageStorage.INTEGER, "0"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void upgradeToVersion10(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_SYSTEM)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_SYSTEM, AVIMMessageStorage.INTEGER, "0"));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_TEMP)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_TEMP, AVIMMessageStorage.INTEGER, "0"));
                }
                if (!DBHelper.columnExists(db, AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_TEMP_TTL)) {
                    db.execSQL(DBHelper.getAddColumnSql(AVIMMessageStorage.CONVERSATION_TABLE, AVIMMessageStorage.COLUMN_CONV_TEMP_TTL, AVIMMessageStorage.NUMBERIC));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static boolean columnExists(SQLiteDatabase db, String table, String column) {
            try {
                Cursor cursor = db.query(table, null, null, null, null, null, null);
                return cursor.getColumnIndex(column) != -1;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    static class SQL {
        static final String TIMESTAMP_MORE_OR_TIMESTAMP_EQUAL_BUT_MESSAGE_ID_MORE_AND_CONVERSATION_ID = " ( timestamp > ? or (timestamp = ? and message_id > ? )) and conversation_id = ? ";
        static final String TIMESTAMP_LESS_AND_CONVERSATION_ID = "timestamp < ? and conversation_id = ? ";
        static final String TIMESTAMP_LESS_OR_TIMESTAMP_EQUAL_BUT_MESSAGE_ID_LESS_AND_CONVERSATION_ID = " ( timestamp < ? or (timestamp = ? and message_id < ? )) and conversation_id = ? ";
        static final String ORDER_BY_TIMESTAMP_DESC_THEN_MESSAGE_ID_DESC = "timestamp desc, message_id desc";
        static final String ORDER_BY_TIMESTAMP_ASC_THEN_MESSAGE_ID_ASC = "timestamp , message_id";
        static final String DELETE_LOCAL_MESSAGE = "conversation_id = ? and message_id = ? and status = ? and dtoken = ? ";
        static final String SELECT_VALID_CONVS = "(temp < 1 and expireAt > ?) or (temp> 0 and temp_ttl > ?)";

        SQL() {
        }
    }
}

