/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.annotation.TargetApi;
import android.util.Pair;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVIMEventHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.conversation.AVIMConversationMemberInfo;
import com.avos.avoscloud.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public abstract class AVIMConversationEventHandler
extends AVIMEventHandler {
    public abstract void onMemberLeft(AVIMClient var1, AVIMConversation var2, List<String> var3, String var4);

    public abstract void onMemberJoined(AVIMClient var1, AVIMConversation var2, List<String> var3, String var4);

    public abstract void onKicked(AVIMClient var1, AVIMConversation var2, String var3);

    public abstract void onInvited(AVIMClient var1, AVIMConversation var2, String var3);

    public void onMuted(AVIMClient client, AVIMConversation conversation, String operator) {
        LogUtil.log.d((String)("Notification ---  you are muted by " + operator));
    }

    public void onUnmuted(AVIMClient client, AVIMConversation conversation, String operator) {
        LogUtil.log.d((String)("Notification ---  you are unmuted by " + operator));
    }

    public void onMemberMuted(AVIMClient client, AVIMConversation conversation, List<String> members, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " muted members: " + StringUtils.join((CharSequence)", ", members)));
    }

    public void onMemberUnmuted(AVIMClient client, AVIMConversation conversation, List<String> members, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " unmuted members: " + StringUtils.join((CharSequence)", ", members)));
    }

    public void onBlocked(AVIMClient client, AVIMConversation conversation, String operator) {
        LogUtil.log.d((String)("Notification ---  you are blocked by " + operator));
    }

    public void onUnblocked(AVIMClient client, AVIMConversation conversation, String operator) {
        LogUtil.log.d((String)("Notification ---  you are unblocked by " + operator));
    }

    public void onMemberBlocked(AVIMClient client, AVIMConversation conversation, List<String> members, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " blocked members: " + StringUtils.join((CharSequence)", ", members)));
    }

    public void onMemberUnblocked(AVIMClient client, AVIMConversation conversation, List<String> members, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " unblocked members: " + StringUtils.join((CharSequence)", ", members)));
    }

    public void onUnreadMessagesCountUpdated(AVIMClient client, AVIMConversation conversation) {
    }

    public void onLastDeliveredAtUpdated(AVIMClient client, AVIMConversation conversation) {
    }

    public void onLastReadAtUpdated(AVIMClient client, AVIMConversation conversation) {
    }

    public void onMessageUpdated(AVIMClient client, AVIMConversation conversation, AVIMMessage message) {
    }

    public void onMessageRecalled(AVIMClient client, AVIMConversation conversation, AVIMMessage message) {
    }

    public void onMemberInfoUpdated(AVIMClient client, AVIMConversation conversation, AVIMConversationMemberInfo memberInfo, List<String> updatedProperties, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " updated memberInfo: " + memberInfo.toString()));
    }

    public void onInfoChanged(AVIMClient client, AVIMConversation conversation, JSONObject attr, String operator) {
        LogUtil.log.d((String)("Notification --- " + operator + " by member: " + operator + ", changedTo: " + attr.toJSONString()));
    }

    @Override
    protected final void processEvent0(int operation, Object operator, Object operand, Object eventScene) {
        AVIMConversation conversation = (AVIMConversation)eventScene;
        this.processConversationEvent(operation, operator, operand, conversation);
    }

    private void processConversationEvent(int operation, Object operator, Object operand, AVIMConversation conversation) {
        switch (operation) {
            case 50004: {
                this.onMemberLeft(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50005: {
                this.onMemberJoined(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50008: {
                this.onInvited(conversation.client, conversation, (String)operator);
                break;
            }
            case 50009: {
                this.onKicked(conversation.client, conversation, (String)operator);
                break;
            }
            case 50012: {
                Pair unreadInfo = (Pair)operand;
                conversation.updateUnreadCountAndMessage((AVIMMessage)operator, (Integer)unreadInfo.first, (Boolean)unreadInfo.second);
                this.onUnreadMessagesCountUpdated(conversation.client, conversation);
                break;
            }
            case 50013: {
                conversation.setLastReadAt((Long)operator, true);
                this.onLastReadAtUpdated(conversation.client, conversation);
                break;
            }
            case 50014: {
                conversation.setLastDeliveredAt((Long)operator, true);
                this.onLastDeliveredAtUpdated(conversation.client, conversation);
                break;
            }
            case 50015: {
                AVIMMessage message = (AVIMMessage)operator;
                conversation.updateLocalMessage(message);
                this.onMessageUpdated(conversation.client, conversation, message);
                break;
            }
            case 50016: {
                AVIMMessage recalledMessage = (AVIMMessage)operator;
                conversation.updateLocalMessage(recalledMessage);
                this.onMessageRecalled(conversation.client, conversation, recalledMessage);
                break;
            }
            case 50017: {
                ArrayList<String> attr = new ArrayList<String>();
                attr.add(AVIMConversationMemberInfo.ATTR_ROLE);
                this.onMemberInfoUpdated(conversation.client, conversation, (AVIMConversationMemberInfo)operand, attr, (String)operator);
                break;
            }
            case 50018: {
                this.onMuted(conversation.client, conversation, (String)operator);
                break;
            }
            case 50019: {
                this.onUnmuted(conversation.client, conversation, (String)operator);
                break;
            }
            case 50022: {
                this.onBlocked(conversation.client, conversation, (String)operator);
                break;
            }
            case 50023: {
                this.onUnblocked(conversation.client, conversation, (String)operator);
                break;
            }
            case 50020: {
                this.onMemberMuted(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50021: {
                this.onMemberUnmuted(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50024: {
                this.onMemberBlocked(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50025: {
                this.onMemberUnblocked(conversation.client, conversation, (List)operand, (String)operator);
                break;
            }
            case 50026: {
                this.onInfoChanged(conversation.client, conversation, (JSONObject)operand, (String)operator);
            }
        }
    }
}

