/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVConversationHolder;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVIMClientParcel;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVNotificationManager;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPushConnectionManager;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.NotifyUtil;
import com.avos.avoscloud.PushServiceParcel;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMMessageOption;
import com.avos.avoscloud.im.v2.AVIMOptions;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avospush.push.AVConnectivityListener;
import com.avos.avospush.push.AVConnectivityReceiver;
import com.avos.avospush.push.AVShutdownListener;
import com.avos.avospush.push.AVShutdownReceiver;
import com.avos.avospush.session.CommandPacket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class PushService
extends Service {
    private static final String LOGTAG = PushService.class.getName();
    private static AVPushConnectionManager sPushConnectionManager;
    private static Object connecting;
    private static volatile boolean isStarted;
    private static boolean isNeedNotifyApplication;
    private static boolean isAutoWakeUp;
    static String DefaultChannelId;
    AVConnectivityReceiver connectivityReceiver;
    AVShutdownReceiver shutdownReceiver;
    private Timer cleanupTimer = new Timer();
    private static Handler _installationSaveHandler;

    public void onCreate() {
        LogUtil.log.d((String)LOGTAG, (String)"On Create");
        super.onCreate();
        sPushConnectionManager = AVPushConnectionManager.getInstance((Context)this);
        this.connectivityReceiver = new AVConnectivityReceiver(new AVConnectivityListener(){
            private volatile boolean connectEstablished = false;

            @Override
            public void onMobile(Context context) {
                LogUtil.log.d((String)LOGTAG, (String)"Connectivity resumed with Mobile");
                this.connectEstablished = true;
                sPushConnectionManager.initConnection();
            }

            @Override
            public void onWifi(Context context) {
                LogUtil.log.d((String)LOGTAG, (String)"Connectivity resumed with Wifi");
                this.connectEstablished = true;
                sPushConnectionManager.initConnection();
            }

            @Override
            public void onOtherConnected(Context context) {
                LogUtil.log.d((String)LOGTAG, (String)"Connectivity resumed with Others");
                this.connectEstablished = true;
                sPushConnectionManager.initConnection();
            }

            @Override
            public void onNotConnected(Context context) {
                if (!this.connectEstablished) {
                    LogUtil.log.d((String)LOGTAG, (String)"Connectivity isn't established yet.");
                    return;
                }
                LogUtil.log.d((String)LOGTAG, (String)"Connectivity broken");
                this.connectEstablished = false;
                if (AVIMOptions.getGlobalOptions().isResetConnectionWhileBroken()) {
                    PushService.this.cleanupTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!connectEstablished) {
                                LogUtil.log.d((String)LOGTAG, (String)"Connection cleanup now.");
                                sPushConnectionManager.cleanupSocketConnection(1006, "Connectivity broken");
                            } else {
                                LogUtil.log.d((String)LOGTAG, (String)"Connection has been resumed");
                            }
                        }
                    }, 3000L);
                }
            }
        });
        this.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.shutdownReceiver = new AVShutdownReceiver(new AVShutdownListener(){

            @Override
            public void onShutdown(Context context) {
                sPushConnectionManager.cleanupSocketConnection();
            }
        });
        this.registerReceiver(this.shutdownReceiver, new IntentFilter("android.intent.action.ACTION_SHUTDOWN"));
        isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=5)
    public int onStartCommand(final Intent intent, int flags, int startId) {
        this.notifyOtherApplication(null != intent ? intent.getAction() : null);
        if (AVUtils.isConnected((Context)this) && PushService.isPushConnectionBroken()) {
            Object object = connecting;
            synchronized (object) {
                try {
                    AVInstallation installation = AVInstallation.getCurrentInstallation();
                    String installationId = installation.getInstallationId();
                    if (installation.isDirty()) {
                        installation.saveInBackground();
                    }
                    LogUtil.log.d((String)LOGTAG, (String)("Start to connect to push server with installationId " + installationId));
                    sPushConnectionManager.initConnection(new AVCallback(){

                        protected void internalDone0(Object o, AVException exception) {
                            if (exception == null) {
                                PushService.this.processIMRequests(intent);
                            } else {
                                PushService.this.reportRouterConnectionException(intent, exception);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LogUtil.log.e((String)LOGTAG, (String)"Exception when init connection, looks like you have not called AVOSCloud.initialized yet", (Exception)e);
                    e.printStackTrace();
                }
            }
        }
        this.processIMRequests(intent);
        return 1;
    }

    private void reportRouterConnectionException(Intent intent, AVException e) {
        if (intent != null && "com.avoscloud.im.v2.action".equalsIgnoreCase(intent.getAction())) {
            int operationCode = intent.getExtras().getInt("conversation.operation");
            String clientId = intent.getExtras().getString("conversation.client");
            String conversationId = intent.getExtras().getString("convesration.id");
            int requestId = intent.getExtras().getInt("conversation.requestId");
            BroadcastUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, (Throwable)e, Conversation.AVIMOperation.getAVIMOperation(operationCode));
        }
    }

    private void processLiveQueryEventFromClient(Intent intent) {
        String subscribeId = intent.getExtras().getString("id");
        int requestId = intent.getExtras().getInt("conversation.requestId");
        sPushConnectionManager.sendLiveQueryLoginCmd(subscribeId, requestId);
    }

    private void processIMRequests(Intent intent) {
        if (null != intent) {
            if ("com.avoscloud.im.v2.action".equalsIgnoreCase(intent.getAction())) {
                this.processConversationEventsFromClient(intent);
            }
            if ("action_live_query_login".equalsIgnoreCase(intent.getAction())) {
                this.processLiveQueryEventFromClient(intent);
            }
            if ("com.avoscloud.im.v2.parcel.action".equalsIgnoreCase(intent.getAction())) {
                this.processConversationParcelEventFromClient(intent);
            }
        }
    }

    public void onDestroy() {
        LogUtil.log.d((String)LOGTAG, (String)"On Destroy");
        if (sPushConnectionManager != null) {
            sPushConnectionManager.stop();
        }
        this.unregisterReceiver(this.connectivityReceiver);
        this.unregisterReceiver(this.shutdownReceiver);
        isStarted = false;
        if (isAutoWakeUp && Build.VERSION.SDK_INT <= 25) {
            try {
                Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
                i.addFlags(0x10000000);
                this.startService(i);
            }
            catch (Exception ex) {
                LogUtil.log.e((String)("failed to start PushService. cause: " + ex.getMessage()));
            }
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        LogUtil.log.d((String)LOGTAG, (String)"On bind");
        return null;
    }

    private static void startServiceIfRequired(Context context, Class<? extends Activity> cls) {
        if (isStarted) {
            return;
        }
        if (context == null) {
            LogUtil.log.d((String)LOGTAG, (String)"context is null");
            return;
        }
        if (!AVUtils.checkPermission((Context)context, (String)"android.permission.INTERNET")) {
            LogUtil.log.e((String)LOGTAG, (String)"Please add <uses-permission android:name=\"android.permission.INTERNET\"/> in your AndroidManifest file");
            return;
        }
        if (!AVUtils.isConnected((Context)context)) {
            LogUtil.log.d((String)LOGTAG, (String)"No network available now");
            return;
        }
        if (!AVUtils.isPushServiceAvailable((Context)context, PushService.class)) {
            LogUtil.log.e((String)LOGTAG, (String)"Please add <service android:name=\"com.avos.avoscloud.PushService\"/> in your AndroidManifest file");
            return;
        }
        PushService.startService(context, cls);
    }

    private static synchronized void startService(Context context, final Class cls) {
        final Context finalContext = context;
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogUtil.log.d((String)LOGTAG, (String)"Start service");
                try {
                    Intent intent = new Intent(finalContext, PushService.class);
                    intent.putExtra("AV_APPLICATION_ID", AVOSCloud.applicationId);
                    if (cls != null) {
                        intent.putExtra("AV_DEFAULT_CALLBACK", cls.getName());
                    }
                    finalContext.startService(intent);
                }
                catch (Exception ex) {
                    LogUtil.log.e((String)("failed to start PushService. cause: " + ex.getMessage()));
                }
            }
        }).start();
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        PushService.startServiceIfRequired(context, cls);
        String finalChannel = channel;
        AVInstallation.getCurrentInstallation().addUnique("channels", finalChannel);
        _installationSaveHandler.sendMessage(Message.obtain());
        if (cls != null) {
            AVNotificationManager manager = AVNotificationManager.getInstance();
            manager.addDefaultPushCallback(channel, cls.getName());
            if (manager.getDefaultPushCallback(AVOSCloud.applicationId) == null) {
                manager.addDefaultPushCallback(AVOSCloud.applicationId, cls.getName());
            }
        }
    }

    public static void setNotificationIcon(int icon) {
        AVNotificationManager.getInstance().setNotificationIcon(icon);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        PushService.startServiceIfRequired(context, cls);
        AVNotificationManager.getInstance().addDefaultPushCallback(AVOSCloud.applicationId, cls.getName());
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        if (channel == null) {
            return;
        }
        AVNotificationManager.getInstance().removeDefaultPushCallback(channel);
        final String finalChannel = channel;
        if (AVUtils.isBlankString((String)AVInstallation.getCurrentInstallation().getObjectId())) {
            AVInstallation.getCurrentInstallation().saveInBackground(new SaveCallback(){

                public void done(AVException e) {
                    if (e == null) {
                        AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
                        _installationSaveHandler.sendMessage(Message.obtain());
                    } else if (AVOSCloud.showInternalDebugLog()) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
            _installationSaveHandler.sendMessage(Message.obtain());
        }
    }

    static synchronized void sendData(CommandPacket packet) {
        if (sPushConnectionManager != null) {
            sPushConnectionManager.sendData(packet);
        }
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.log.d((String)"try to restart service on task Removed");
        }
        if (isAutoWakeUp) {
            Intent restartServiceIntent = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
            restartServiceIntent.setPackage(this.getPackageName());
            PendingIntent restartServicePendingIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartServiceIntent, (int)0x8000000);
            AlarmManager alarmService = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
            alarmService.set(3, SystemClock.elapsedRealtime() + 500L, restartServicePendingIntent);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            super.onTaskRemoved(rootIntent);
        }
    }

    protected static boolean isPushConnectionBroken() {
        return sPushConnectionManager == null || sPushConnectionManager != null && !sPushConnectionManager.isConnectedToPushServer();
    }

    private void processConversationParcelEventFromClient(Intent intent) {
        int operationCode = intent.getExtras().getInt("conversation.operation");
        String clientId = intent.getExtras().getString("conversation.client");
        String conversationId = intent.getExtras().getString("convesration.id");
        int convType = intent.getExtras().getInt("conversation.type", 1);
        int requestId = intent.getExtras().getInt("conversation.requestId");
        Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation(operationCode);
        AVSession session = sPushConnectionManager.getOrCreateSession(clientId);
        PushServiceParcel parcel = (PushServiceParcel)intent.getExtras().getParcelable("conversation.data");
        switch (operation) {
            case CONVERSATION_RECALL_MESSAGE: 
            case CONVERSATION_UPDATE_MESSAGE: {
                if (!AVUtils.isBlankString((String)conversationId)) {
                    AVConversationHolder conversation = session.getConversationHolder(conversationId, convType);
                    if (null != conversation) {
                        conversation.patchMessage(parcel, operation, requestId);
                        break;
                    }
                    LogUtil.log.d((String)("can't find out conversation with id:" + conversationId));
                    break;
                }
                LogUtil.log.d((String)"conversationId is mandatory for MessageRecall or MessageUpdate.");
            }
        }
    }

    private void processConversationEventsFromClient(Intent intent) {
        AVException connectionException;
        String intentData;
        int operationCode = intent.getExtras().getInt("conversation.operation");
        String clientId = intent.getExtras().getString("conversation.client");
        String conversationId = intent.getExtras().getString("convesration.id");
        int convType = intent.getExtras().getInt("conversation.type", 1);
        int requestId = intent.getExtras().getInt("conversation.requestId");
        AVSession session = sPushConnectionManager.getOrCreateSession(clientId);
        Map params = null;
        Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation(operationCode);
        if (operation != Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE && !AVUtils.isBlankString((String)(intentData = intent.getExtras().getString("conversation.data")))) {
            params = (Map)JSON.parseObject((String)intentData, Map.class);
        }
        if (operation != Conversation.AVIMOperation.CLIENT_OPEN && operation != Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY && operation != Conversation.AVIMOperation.CONVERSATION_QUERY && operation != Conversation.AVIMOperation.CLIENT_REFRESH_TOKEN && (connectionException = session.checkSessionStatus()) != null) {
            BroadcastUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, (Throwable)connectionException, operation);
            return;
        }
        switch (operation) {
            case CLIENT_OPEN: {
                AVIMClientParcel parcel = (AVIMClientParcel)intent.getExtras().getParcelable("conversation.client.parcel");
                session.open(parcel, requestId);
                break;
            }
            case CLIENT_REFRESH_TOKEN: {
                session.renewRealtimeSesionToken(requestId);
                break;
            }
            case CLIENT_DISCONNECT: {
                session.close(requestId);
                break;
            }
            case CLIENT_ONLINE_QUERY: {
                List idList = (List)params.get("client.oneline");
                session.queryOnlinePeers(idList, requestId);
                break;
            }
            case CONVERSATION_CREATION: {
                List memberList = (List)params.get("conversation.member");
                Map attribute = null;
                if (params.containsKey("conversation.attributes")) {
                    attribute = (Map)params.get("conversation.attributes");
                }
                boolean isTransient = false;
                if (params.containsKey("conversation.transient")) {
                    isTransient = (Boolean)params.get("conversation.transient");
                }
                boolean isUnique = (Boolean)params.get("conversation.unique");
                boolean isSystem = false;
                if (params.containsKey("conversation.sys")) {
                    isSystem = (Boolean)params.get("conversation.sys");
                }
                boolean isTemp = false;
                if (params.containsKey("conversation.temp")) {
                    isTemp = (Boolean)params.get("conversation.temp");
                }
                int tempTTL = 259200;
                if (params.containsKey("conversation.tempTTL")) {
                    tempTTL = (Integer)params.get("conversation.tempTTL");
                }
                session.createConversation(memberList, attribute, isTransient, isUnique, isTemp, tempTTL, isSystem, requestId);
                break;
            }
            case CONVERSATION_QUERY: {
                session.conversationQuery(params, requestId);
                break;
            }
            case CONVERSATION_SEND_MESSAGE: {
                AVConversationHolder conversation;
                if (AVUtils.isBlankString((String)conversationId) || null == (conversation = session.getConversationHolder(conversationId, convType))) break;
                AVIMMessage message = (AVIMMessage)intent.getExtras().getParcelable("conversation.data");
                AVIMMessageOption messageOption = null;
                messageOption = intent.getExtras().containsKey("conversation.messageoption") ? (AVIMMessageOption)intent.getExtras().getParcelable("conversation.messageoption") : new AVIMMessageOption();
                message.setFrom(clientId);
                conversation.sendMessage(message, requestId, messageOption);
                break;
            }
            case CLIENT_STATUS: {
                this.processSessionConnectionStatus(session, requestId);
                break;
            }
            default: {
                if (AVUtils.isBlankString((String)conversationId)) {
                    LogUtil.log.e((String)"conversation id is null during promoting MemberInfo");
                    break;
                }
                AVConversationHolder internalConversation = session.getConversationHolder(conversationId, convType);
                if (null == internalConversation) {
                    LogUtil.log.w((String)("not found target conversation with id=" + conversationId));
                    break;
                }
                internalConversation.processConversationCommandFromClient(operation, params, requestId);
            }
        }
    }

    private void processSessionConnectionStatus(AVSession session, int requestId) {
        AVIMClient.AVIMClientStatus status = AVIMClient.AVIMClientStatus.AVIMClientStatusNone;
        if (session.sessionOpened.get() && session.sessionPaused.get()) {
            status = AVIMClient.AVIMClientStatus.AVIMClientStatusPaused;
        } else if (session.sessionOpened.get()) {
            status = AVIMClient.AVIMClientStatus.AVIMClientStatusOpened;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("callbackClientStatus", status.getCode());
        BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, bundle, Conversation.AVIMOperation.CLIENT_STATUS);
    }

    private void notifyOtherApplication(String action) {
        if (isNeedNotifyApplication && !"com.avos.avoscloud.notify.action".equals(action)) {
            isNeedNotifyApplication = false;
            try {
                ServiceInfo info = this.getApplicationContext().getPackageManager().getServiceInfo(new ComponentName(this.getApplicationContext(), PushService.class), 0);
                if (info.exported) {
                    NotifyUtil.notifyHandler.sendEmptyMessage(1024);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void setAutoWakeUp(boolean isAutoWakeUp) {
        PushService.isAutoWakeUp = isAutoWakeUp;
    }

    @TargetApi(value=26)
    public static void setDefaultChannelId(Context context, String channelId) {
        DefaultChannelId = channelId;
        if (Build.VERSION.SDK_INT <= 25) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            String name = context.getPackageName();
            String description = "PushNotification";
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)name, importance);
            channel.setDescription(description);
            notificationManager.createNotificationChannel(channel);
        }
        catch (Exception ex) {
            LogUtil.log.w((String)"failed to create NotificationChannel, then perhaps PushNotification doesn't work well on Android O and newer version.");
        }
    }

    static {
        connecting = new Object();
        isStarted = false;
        isNeedNotifyApplication = true;
        isAutoWakeUp = true;
        DefaultChannelId = "";
        _installationSaveHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message m) {
                AVInstallation.getCurrentInstallation().saveInBackground(new SaveCallback(){

                    public void done(AVException e) {
                        if (e != null && "already has one request sending".equals(e.getMessage())) {
                            _installationSaveHandler.removeMessages(0);
                            Message m = Message.obtain();
                            m.what = 0;
                            _installationSaveHandler.sendMessageDelayed(m, 2000L);
                        }
                    }
                });
            }
        };
    }
}

