/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.utils.StringUtils;
import com.avos.avospush.session.StaleMessageDepot;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class AVNotificationManager {
    private static final String PUSH_INTENT_KEY = "com.avoscloud.push";
    private static final String PUSH_MESSAGE_DEPOT = "com.avos.push.message";
    private static final String LOGTAG = "AVNotificationManager";
    private static final String AV_PUSH_SERVICE_APP_DATA = "AV_PUSH_SERVICE_APP_DATA";
    private static final String ICON_KEY = "_notification_icon";
    private static final Random random = new Random();
    private final ConcurrentHashMap<String, String> defaultPushCallback = new ConcurrentHashMap();
    private int notificationIcon;
    private final StaleMessageDepot depot;
    private Context context;
    private static AVNotificationManager notificationManager;

    public static synchronized AVNotificationManager getInstance() {
        if (null == notificationManager) {
            notificationManager = new AVNotificationManager(AVOSCloud.applicationContext);
        }
        return notificationManager;
    }

    private AVNotificationManager(Context context) {
        this.context = context;
        this.notificationIcon = context.getApplicationInfo().icon;
        this.depot = new StaleMessageDepot(PUSH_MESSAGE_DEPOT);
        this.readDataFromCache();
        if (AVOSCloud.isDebugLogEnabled()) {
            Log.d((String)LOGTAG, (String)("Init AppManager Done, read data from cache: " + this.defaultPushCallback.size()));
        }
    }

    private void sendNotification(String from, String msg) throws IllegalArgumentException {
        Intent resultIntent = this.buildUpdateIntent(from, msg, null);
        this.sendNotification(from, msg, resultIntent);
    }

    private Intent buildUpdateIntent(String channel, String msg, String action) {
        Intent updateIntent = new Intent();
        if (action != null) {
            updateIntent.setAction(action);
        }
        updateIntent.putExtra(PUSH_INTENT_KEY, 1);
        updateIntent.putExtra("com.avos.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avos.avoscloud.Data", msg);
        updateIntent.putExtra("com.avoscloud.Data", msg);
        updateIntent.setPackage(this.context.getPackageName());
        return updateIntent;
    }

    private void sendBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.d((String)("action: " + updateIntent.getAction()));
        }
        this.context.sendBroadcast(updateIntent);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.d((String)"sent broadcast");
        }
    }

    private void sendNotificationBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.d((String)("action: " + updateIntent.getAction()));
        }
        this.context.sendBroadcast(updateIntent);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.d((String)"sent broadcast");
        }
    }

    private String getChannel(String msg) {
        return AVUtils.getJSONValue((String)msg, (String)"_channel");
    }

    private String getAction(String msg) {
        return AVUtils.getJSONValue((String)msg, (String)"action");
    }

    private boolean getSilent(String message) {
        block3: {
            if (!AVUtils.isBlankString((String)message)) {
                try {
                    JSONObject object = new JSONObject(message);
                    return object.optBoolean("silent", false);
                }
                catch (JSONException e) {
                    if (!AVOSCloud.isDebugLogEnabled()) break block3;
                    LogUtil.avlog.e((String)"getSilent failed.", (Exception)((Object)e));
                }
            }
        }
        return false;
    }

    private Date getExpiration(String msg) {
        String result = "";
        try {
            JSONObject object = new JSONObject(msg);
            result = object.getString("_expiration_time");
        }
        catch (JSONException object) {
            // empty catch block
        }
        if (AVUtils.isBlankString((String)result)) {
            return null;
        }
        Date date = AVUtils.dateFromString((String)result);
        return date;
    }

    void processGcmMessage(String channel, String action, String message) {
        if (channel == null || !this.containsDefaultPushCallback(channel)) {
            channel = AVOSCloud.applicationId;
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else {
                this.sendNotification(channel, message);
            }
        }
    }

    void processMixPushMessage(String message) {
        if (!AVUtils.isBlankString((String)message)) {
            String channel = this.getChannel(message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.applicationId;
            }
            String action = this.getAction(message);
            boolean slient = this.getSilent(message);
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else if (!slient) {
                this.sendNotification(channel, message);
            } else {
                LogUtil.avlog.e((String)("ignore push silent message: " + message));
            }
        }
    }

    void processMixNotification(String message, String defaultAction) {
        if (StringUtils.isBlankString((String)message)) {
            LogUtil.log.e((String)LOGTAG, (String)"message is empty, ignore.");
        } else {
            String action;
            String channel = this.getChannel(message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.applicationId;
            }
            if (null != (action = this.getAction(message))) {
                this.sendNotificationBroadcast(channel, message, defaultAction);
            } else {
                String clsName = this.getDefaultPushCallback(channel);
                if (StringUtils.isBlankString((String)clsName)) {
                    LogUtil.log.e((String)LOGTAG, (String)"className is empty, ignore.");
                } else {
                    Intent intent = this.buildUpdateIntent(channel, message, null);
                    ComponentName cn = new ComponentName(this.context, clsName);
                    intent.setComponent(cn);
                    intent.setFlags(0x20000000);
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
                    try {
                        pendingIntent.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        LogUtil.log.e((String)LOGTAG, (String)"Ocurred PendingIntent.CanceledException", (Exception)((Object)e));
                    }
                }
            }
        }
    }

    void processPushMessage(String message, String messageId) {
        try {
            Date expiration;
            String channel = this.getChannel(message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.applicationId;
            }
            if ((expiration = this.getExpiration(message)) != null && expiration.before(new Date())) {
                LogUtil.avlog.d((String)("message expired:" + message));
                return;
            }
            if (this.depot.putStableMessage(messageId)) {
                String action = this.getAction(message);
                if (action != null) {
                    this.sendBroadcast(channel, message, action);
                } else {
                    this.sendNotification(channel, message);
                }
            }
        }
        catch (Exception e) {
            LogUtil.avlog.e((String)"Process notification failed.", (Exception)e);
        }
    }

    void porcessMixNotificationArrived(String message, String action) {
        if (!AVUtils.isBlankString((String)message) && !AVUtils.isBlankString((String)action)) {
            String channel = this.getChannel(message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.applicationId;
            }
            this.sendNotificationBroadcast(channel, message, action);
        }
    }

    private void readDataFromCache() {
        SharedPreferences appData = this.context.getSharedPreferences(AV_PUSH_SERVICE_APP_DATA, 0);
        for (Map.Entry entry : appData.getAll().entrySet()) {
            String channel = (String)entry.getKey();
            if (channel.equals(ICON_KEY)) {
                try {
                    this.notificationIcon = Integer.valueOf((String)entry.getValue());
                }
                catch (Exception exception) {}
                continue;
            }
            String defaultCls = String.valueOf(entry.getValue());
            this.defaultPushCallback.put(channel, defaultCls);
        }
    }

    private int getNotificationIcon() {
        return this.notificationIcon;
    }

    void setNotificationIcon(int icon) {
        this.notificationIcon = icon;
        AVPersistenceUtils.sharedInstance().savePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, ICON_KEY, String.valueOf(icon));
    }

    void addDefaultPushCallback(String channel, String clsName) {
        this.defaultPushCallback.put(channel, clsName);
        AVPersistenceUtils.sharedInstance().savePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, channel, String.valueOf(clsName));
    }

    void removeDefaultPushCallback(String channel) {
        this.defaultPushCallback.remove(channel);
        AVPersistenceUtils.sharedInstance().removePersistentSettingString(AV_PUSH_SERVICE_APP_DATA, channel);
    }

    private boolean containsDefaultPushCallback(String channel) {
        return this.defaultPushCallback.containsKey(channel);
    }

    String getDefaultPushCallback(String channel) {
        return AVUtils.isBlankString((String)channel) ? null : this.defaultPushCallback.get(channel);
    }

    public int size() {
        return this.defaultPushCallback.size();
    }

    @TargetApi(value=26)
    private void sendNotification(String from, String msg, Intent resultIntent) {
        String clsName = this.getDefaultPushCallback(from);
        if (AVUtils.isBlankString((String)clsName)) {
            throw new IllegalArgumentException("No default callback found, did you forget to invoke setDefaultPushCallback?");
        }
        int lastIndex = clsName.lastIndexOf(".");
        if (lastIndex != -1) {
            int notificationId = random.nextInt();
            ComponentName cn = new ComponentName(this.context, clsName);
            resultIntent.setComponent(cn);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)notificationId, (Intent)resultIntent, (int)0);
            String sound = this.getSound(msg);
            Notification notification = null;
            if (Build.VERSION.SDK_INT <= 25) {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)this.getText(msg));
                notification = mBuilder.build();
            } else {
                Notification.Builder builder = new Notification.Builder(this.context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)this.getText(msg)).setChannelId(PushService.DefaultChannelId);
                notification = builder.build();
            }
            if (sound != null && sound.trim().length() > 0) {
                notification.sound = Uri.parse((String)("android.resource://" + sound));
            }
            NotificationManager manager = (NotificationManager)this.context.getSystemService("notification");
            manager.notify(notificationId, notification);
        } else {
            Log.e((String)LOGTAG, (String)("Class name is invalid, which must contain '.': " + clsName));
        }
    }

    private String getTitle(String msg) {
        return this.getValue(msg, "title");
    }

    private String getSound(String msg) {
        return this.getValue(msg, "sound");
    }

    private String getValue(String msg, String key) {
        String title = AVUtils.getJSONValue((String)msg, (String)key);
        if (title != null && title.trim().length() > 0) {
            return title;
        }
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return this.getApplicationName();
        }
        Map data = (Map)jsonMap.get("data");
        if (data == null || data.isEmpty()) {
            return this.getApplicationName();
        }
        Object val = data.get(key);
        if (val != null) {
            return val.toString();
        }
        return this.getApplicationName();
    }

    private String getApplicationName() {
        ApplicationInfo ai;
        PackageManager pm = this.context.getPackageManager();
        try {
            ai = pm.getApplicationInfo(this.context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "Notification";
        return applicationName;
    }

    private String getText(String msg) {
        String text = AVUtils.getJSONValue((String)msg, (String)"alert");
        if (text != null && text.trim().length() > 0) {
            return text;
        }
        Map jsonMap = (Map)JSON.parseObject((String)msg, HashMap.class);
        if (jsonMap == null || jsonMap.isEmpty()) {
            return null;
        }
        Map data = (Map)jsonMap.get("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        Object val = data.get("message");
        if (val != null) {
            return val.toString();
        }
        return null;
    }
}

