/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.push;

import android.content.Context;
import android.content.SharedPreferences;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVHttpClient;
import com.avos.avoscloud.AVInstallation;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AppRouterManager;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.im.v2.AVIMOptions;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Callback;
import okhttp3.Request;

public class AVPushRouter {
    public static final String SERVER = "server";
    private static final String EXPIRE_AT = "expireAt";
    private static final String SECONDARY = "secondary";
    private static String ROUTER_QUERY_SRTING = "/v1/route?appId=%s&installationId=%s&secure=1";
    private static final String PUSH_SERVER_CACHE_KEY_FMT = "com.avos.push.router.server.cache%s";
    private final Context context;
    private final String installationId;
    private int ttlInSecs = -1;
    private static final int ROUTER_REQUEST_TIME_OUT = 5000;
    private AVHttpClient routerHttpClient;
    private RouterResponseListener listener;
    private volatile boolean isRequesting = false;
    private AtomicInteger socketLostNum = new AtomicInteger(0);
    private volatile boolean isPrimarySever = true;

    public AVPushRouter(Context context, RouterResponseListener listener) {
        this.context = context;
        this.listener = listener;
        this.installationId = AVInstallation.getCurrentInstallation(context).getInstallationId();
    }

    private String getRouterUrl() {
        String routerUrl = AppRouterManager.getInstance().getRtmRouterServer() + ROUTER_QUERY_SRTING;
        return String.format(routerUrl, AVOSCloud.applicationId, this.installationId);
    }

    private synchronized AVHttpClient getRouterHttpClient() {
        if (null == this.routerHttpClient) {
            this.routerHttpClient = AVHttpClient.newClientInstance((int)5000);
        }
        return this.routerHttpClient;
    }

    public void processSocketConnectionResult(AVException e) {
        if (null == e) {
            this.socketLostNum.set(0);
        } else {
            String errorMessage = e.getMessage();
            if (AVUtils.isConnected((Context)this.context) && (AVUtils.isBlankContent((String)errorMessage) || !errorMessage.contains("Permission"))) {
                this.socketLostNum.incrementAndGet();
                if (this.socketLostNum.get() > 1) {
                    this.isPrimarySever = false;
                }
            }
        }
    }

    public void fetchPushServer() {
        if (AVUtils.isBlankString((String)AVOSCloud.applicationId)) {
            LogUtil.avlog.e((String)"Please initialize Application first");
            return;
        }
        String specifiedServer = AVIMOptions.getGlobalOptions().getRTMServer();
        if (!AVUtils.isBlankString((String)specifiedServer)) {
            this.listener.onServerAddress(specifiedServer);
        } else if (!AVUtils.isConnected((Context)this.context)) {
            HashMap<String, Object> pushServerCache = this.getPushServerFromCache();
            if (pushServerCache != null) {
                this.listener.onServerAddress((String)pushServerCache.get(SERVER));
            } else {
                this.listener.onServerAddress(null);
            }
        } else {
            HashMap<String, Object> pushServerCache = this.getPushServerFromCache();
            if (pushServerCache != null && (Long)pushServerCache.get(EXPIRE_AT) > System.currentTimeMillis() && this.socketLostNum.get() <= 3) {
                String secondaryAddress;
                String serverAddress = (String)pushServerCache.get(SERVER);
                if (!this.isPrimarySever && !AVUtils.isBlankContent((String)(secondaryAddress = (String)pushServerCache.get(SECONDARY)))) {
                    serverAddress = secondaryAddress;
                }
                this.listener.onServerAddress(serverAddress);
                if (AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d((String)("get push server from cache:" + serverAddress));
                }
            } else {
                this.fetchPushServerFromServer();
            }
        }
    }

    private void fetchPushServerFromServer() {
        if (this.isRequesting) {
            return;
        }
        this.isRequesting = true;
        String routerUrlStr = this.getRouterUrl();
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.avlog.d((String)("try to fetch push server from :" + routerUrlStr));
        }
        GenericObjectCallback callback = new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (e == null) {
                    try {
                        AVPushRouter.this.socketLostNum.set(0);
                        HashMap response = (HashMap)JSON.parseObject((String)content, HashMap.class);
                        AVPushRouter.this.ttlInSecs = (Integer)response.get("ttl");
                        HashMap result = new HashMap();
                        result.put(AVPushRouter.SERVER, response.get(AVPushRouter.SERVER));
                        result.put(AVPushRouter.EXPIRE_AT, (long)AVPushRouter.this.ttlInSecs * 1000L + System.currentTimeMillis());
                        result.put(AVPushRouter.SECONDARY, response.get(AVPushRouter.SECONDARY));
                        if (response.containsKey("groupUrl")) {
                            AppRouterManager.getInstance().updateRtmRouterServer((String)response.get("groupUrl"), true);
                        }
                        AVPushRouter.this.cachePushServer(result);
                        AVPushRouter.this.listener.onServerAddress((String)result.get(AVPushRouter.SERVER));
                        AVPushRouter.this.isPrimarySever = true;
                    }
                    catch (Exception e1) {
                        this.onFailure(e1, content);
                    }
                }
                AVPushRouter.this.isRequesting = false;
            }

            public void onFailure(Throwable error, String content) {
                if (AVOSCloud.showInternalDebugLog()) {
                    LogUtil.avlog.d((String)("failed to fetch push server:" + error));
                }
                AVPushRouter.this.listener.onServerAddress(null);
                AVPushRouter.this.isRequesting = false;
            }

            public boolean isRequestStatisticNeed() {
                return false;
            }
        };
        Request.Builder builder = new Request.Builder();
        builder.url(routerUrlStr).get();
        if (AVOSCloud.isDebugLogEnabled()) {
            LogUtil.avlog.d((String)("get router url: " + routerUrlStr));
        }
        this.getRouterHttpClient().execute(builder.build(), false, (Callback)new GetHttpResponseHandler(callback));
    }

    private HashMap<String, Object> getPushServerFromCache() {
        HashMap<String, Object> pushServerMap = new HashMap<String, Object>();
        SharedPreferences pushServerData = this.context.getSharedPreferences(String.format(PUSH_SERVER_CACHE_KEY_FMT, AVOSCloud.applicationId), 0);
        pushServerMap.put(SERVER, pushServerData.getString(SERVER, null));
        pushServerMap.put(EXPIRE_AT, pushServerData.getLong(EXPIRE_AT, 0L));
        pushServerMap.put(SECONDARY, pushServerData.getString(SECONDARY, null));
        return pushServerMap;
    }

    private void cachePushServer(HashMap<String, Object> pushServerMap) {
        SharedPreferences pushServerData = this.context.getSharedPreferences(String.format(PUSH_SERVER_CACHE_KEY_FMT, AVOSCloud.applicationId), 0);
        SharedPreferences.Editor editor = pushServerData.edit();
        editor.putString(SERVER, (String)pushServerMap.get(SERVER));
        editor.putLong(EXPIRE_AT, ((Long)pushServerMap.get(EXPIRE_AT)).longValue());
        editor.putString(SECONDARY, (String)pushServerMap.get(SECONDARY));
        editor.commit();
    }

    public static interface RouterResponseListener {
        public void onServerAddress(String var1);
    }
}

