/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.util.SparseArray;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMConversationEventHandler;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMMessageHandler;
import com.avos.avoscloud.im.v2.AVIMMessageType;
import com.avos.avoscloud.im.v2.AVIMTypedMessage;
import com.avos.avoscloud.im.v2.MessageHandler;
import com.avos.avoscloud.im.v2.messages.AVIMAudioMessage;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessage;
import com.avos.avoscloud.im.v2.messages.AVIMImageMessage;
import com.avos.avoscloud.im.v2.messages.AVIMLocationMessage;
import com.avos.avoscloud.im.v2.messages.AVIMRecalledMessage;
import com.avos.avoscloud.im.v2.messages.AVIMTextMessage;
import com.avos.avoscloud.im.v2.messages.AVIMVideoMessage;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class AVIMMessageManager {
    static SparseArray<Class<? extends AVIMTypedMessage>> messageTypesRepository = new SparseArray();
    static AVIMMessageHandler defaultMessageHandler;
    static ConcurrentHashMap<Class<? extends AVIMMessage>, Set<MessageHandler>> messageHandlerRepository;
    static AVIMConversationEventHandler conversationEventHandler;

    public static void registerAVIMMessageType(Class<? extends AVIMTypedMessage> messageType) {
        block3: {
            AVIMMessageType type = messageType.getAnnotation(AVIMMessageType.class);
            if (type == null) {
                throw new IncompleteAnnotationException(AVIMMessageType.class, "type");
            }
            int messageTypeValue = type.type();
            messageTypesRepository.put(messageTypeValue, messageType);
            try {
                Method initializeMethod = messageType.getDeclaredMethod("computeFieldAttribute", Class.class);
                initializeMethod.setAccessible(true);
                initializeMethod.invoke(null, messageType);
            }
            catch (Exception e) {
                if (!AVOSCloud.showInternalDebugLog()) break block3;
                LogUtil.avlog.d((String)"failed to initialize message Fields");
            }
        }
    }

    public static void registerDefaultMessageHandler(AVIMMessageHandler handler) {
        defaultMessageHandler = handler;
    }

    public static void registerMessageHandler(Class<? extends AVIMMessage> clazz, MessageHandler<?> handler) {
        Set<MessageHandler<Object>> handlerSet = new CopyOnWriteArraySet();
        Set set = messageHandlerRepository.putIfAbsent(clazz, handlerSet);
        if (set != null) {
            handlerSet = set;
        }
        handlerSet.add(handler);
    }

    public static void unregisterMessageHandler(Class<? extends AVIMMessage> clazz, MessageHandler<?> handler) {
        Set<MessageHandler> handlerSet = messageHandlerRepository.get(clazz);
        if (handlerSet != null) {
            handlerSet.remove(handler);
        }
    }

    public static void setConversationEventHandler(AVIMConversationEventHandler handler) {
        conversationEventHandler = handler;
    }

    protected static AVIMConversationEventHandler getConversationEventHandler() {
        return conversationEventHandler;
    }

    protected static void processMessage(AVIMMessage message, int convType, AVIMClient client, boolean hasMore, boolean isTransient) {
        if (client.storage.containMessage(message)) {
            return;
        }
        if (!isTransient && AVIMClient.messageQueryCacheEnabled) {
            client.storage.insertMessage(message, hasMore);
        }
        message = AVIMMessageManager.parseTypedMessage(message);
        AVIMConversation conversation = client.getConversation(message.getConversationId(), convType);
        conversation.setLastMessage(message);
        if (!isTransient) {
            conversation.increaseUnreadCount(1, message.mentioned());
        }
        conversation.setLastMessageAt(new Date(message.getTimestamp()));
        AVIMMessageManager.retrieveAllMessageHandlers(message, conversation, false);
    }

    protected static void processMessageReceipt(AVIMMessage message, AVIMClient client) {
        client.storage.updateMessage(message, message.getMessageId());
        AVIMMessage finalMessageObject = message = AVIMMessageManager.parseTypedMessage(message);
        AVIMConversation conversation = client.getConversation(message.getConversationId());
        AVIMMessageManager.retrieveAllMessageHandlers(message, conversation, true);
    }

    private static void retrieveAllMessageHandlers(AVIMMessage message, AVIMConversation conversation, boolean receipt) {
        boolean messageProcessed = false;
        for (Class clazzKey : messageHandlerRepository.keySet()) {
            if (!clazzKey.isAssignableFrom(message.getClass())) continue;
            Set<MessageHandler> handlers = messageHandlerRepository.get(clazzKey);
            if (handlers.size() > 0) {
                messageProcessed = true;
            }
            for (MessageHandler handler : handlers) {
                if (receipt) {
                    handler.processEvent(50001, null, message, conversation);
                    continue;
                }
                handler.processEvent(50000, null, message, conversation);
            }
        }
        if (!messageProcessed && defaultMessageHandler != null) {
            if (receipt) {
                defaultMessageHandler.processEvent(50001, null, message, conversation);
            } else {
                defaultMessageHandler.processEvent(50000, null, message, conversation);
            }
        }
    }

    protected static AVIMMessage parseTypedMessage(AVIMMessage message) {
        Class clazz;
        int messageType = AVIMMessageManager.getMessageType(message.getContent());
        if (messageType != 0 && (clazz = (Class)messageTypesRepository.get(messageType)) != null) {
            try {
                AVIMMessage typedMessage = (AVIMMessage)clazz.newInstance();
                typedMessage.setConversationId(message.getConversationId());
                typedMessage.setFrom(message.getFrom());
                typedMessage.setReceiptTimestamp(message.getReceiptTimestamp());
                typedMessage.setTimestamp(message.getTimestamp());
                typedMessage.setContent(message.getContent());
                typedMessage.setMessageId(message.getMessageId());
                typedMessage.setMessageStatus(message.getMessageStatus());
                typedMessage.setMessageIOType(message.getMessageIOType());
                typedMessage.uniqueToken = message.uniqueToken;
                typedMessage.currentClient = message.currentClient;
                typedMessage.mentionAll = message.mentionAll;
                typedMessage.mentionList = message.mentionList;
                message = typedMessage;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    private static int getMessageType(String messageContent) {
        if (!AVUtils.isBlankContent((String)messageContent)) {
            try {
                JSONObject object = JSON.parseObject((String)messageContent);
                int type = object.getInteger("_lctype");
                return type;
            }
            catch (Exception e) {
                LogUtil.avlog.e((String)("Parsing json data error, " + messageContent), (Exception)e);
            }
        }
        return 0;
    }

    static {
        messageHandlerRepository = new ConcurrentHashMap();
        AVIMMessageManager.registerAVIMMessageType(AVIMTextMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMFileMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMImageMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMAudioMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMVideoMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMLocationMessage.class);
        AVIMMessageManager.registerAVIMMessageType(AVIMRecalledMessage.class);
    }
}

