/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.ObjectValueFilter;
import com.avos.avoscloud.QueryOperation;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMConversationQueryConditions;
import com.avos.avoscloud.im.v2.AVIMMessageStorage;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avoscloud.im.v2.callback.AVIMConversationQueryCallback;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AVIMConversationsQuery {
    private AVIMClient client;
    AVIMConversationQueryConditions conditions;
    AVQuery.CachePolicy policy = AVQuery.CachePolicy.CACHE_ELSE_NETWORK;
    private static final long MAX_CONVERSATION_CACHE_TIME = 3600000L;
    private long maxAge = 3600000L;

    protected AVIMConversationsQuery(AVIMClient client) {
        this.client = client;
        this.conditions = new AVIMConversationQueryConditions();
    }

    public AVIMConversationsQuery withMembers(List<String> peerIds) {
        return this.withMembers(peerIds, false);
    }

    public AVIMConversationsQuery withMembers(List<String> peerIds, boolean includeSelf) {
        HashSet<String> targetPeerIds = new HashSet<String>(peerIds);
        if (includeSelf) {
            targetPeerIds.add(this.client.clientId);
        }
        this.containsMembers(new LinkedList<String>(targetPeerIds));
        this.whereSizeEqual("m", targetPeerIds.size());
        return this;
    }

    public AVIMConversationsQuery containsMembers(List<String> peerIds) {
        this.conditions.addWhereItem("m", "$all", peerIds);
        return this;
    }

    public AVIMConversationsQuery whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(key, value);
        return this;
    }

    public AVIMConversationsQuery whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public AVIMConversationsQuery whereLessThanOrEqualsTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public AVIMConversationsQuery whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public AVIMConversationsQuery whereGreaterThanOrEqualsTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public AVIMConversationsQuery whereNotEqualsTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public AVIMConversationsQuery whereContainsIn(String key, Collection<?> value) {
        this.conditions.whereContainedIn(key, value);
        return this;
    }

    public AVIMConversationsQuery whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public AVIMConversationsQuery whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(key);
        return this;
    }

    public AVIMConversationsQuery whereNotContainsIn(String key, Collection<?> value) {
        this.conditions.whereNotContainedIn(key, value);
        return this;
    }

    public AVIMConversationsQuery whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(key, values);
        return this;
    }

    public AVIMConversationsQuery whereContains(String key, String subString) {
        this.conditions.whereContains(key, subString);
        return this;
    }

    public AVIMConversationsQuery whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(key, prefix);
        return this;
    }

    public AVIMConversationsQuery whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(key, suffix);
        return this;
    }

    public AVIMConversationsQuery whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public AVIMConversationsQuery whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    public AVIMConversationsQuery whereNear(String key, AVGeoPoint point) {
        this.conditions.whereNear(key, point);
        return this;
    }

    public AVIMConversationsQuery whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public AVIMConversationsQuery whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public AVIMConversationsQuery whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance);
        return this;
    }

    public AVIMConversationsQuery whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance);
        return this;
    }

    public AVIMConversationsQuery setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public AVIMConversationsQuery limit(int limit) {
        return this.setLimit(limit);
    }

    public AVIMConversationsQuery setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public AVIMConversationsQuery skip(int skip) {
        return this.setSkip(skip);
    }

    public AVIMConversationsQuery orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public AVIMConversationsQuery orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public AVIMConversationsQuery addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public AVIMConversationsQuery addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public AVIMConversationsQuery whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(key, size);
        return this;
    }

    public boolean isWithLastMessagesRefreshed() {
        return this.conditions.isWithLastMessagesRefreshed();
    }

    public AVIMConversationsQuery setWithLastMessagesRefreshed(boolean isWithLastMessageRefreshed) {
        this.conditions.setWithLastMessagesRefreshed(isWithLastMessageRefreshed);
        return this;
    }

    public void findInBackground(AVIMConversationQueryCallback callback) {
        Map<String, String> queryParams = this.conditions.assembleParameters();
        final String queryParamsString = JSON.toJSONString(queryParams, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[0]);
        switch (this.policy) {
            case CACHE_THEN_NETWORK: 
            case CACHE_ELSE_NETWORK: {
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback){

                    @Override
                    public void onFailure(Throwable error, String content) {
                        AVIMConversationsQuery.this.queryFromNetwork(this.callback, queryParamsString);
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                if (AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
                    this.queryFromNetwork(callback, queryParamsString);
                    break;
                }
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback));
                break;
            }
            case CACHE_ONLY: {
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback));
                break;
            }
            case NETWORK_ONLY: 
            case IGNORE_CACHE: {
                this.queryFromNetwork(callback, queryParamsString);
            }
        }
    }

    private void queryFromNetwork(final AVIMConversationQueryCallback callback, final String queryParamsString) {
        if (!AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            if (callback != null) {
                callback.internalDone(null, new AVException(100, "Connection lost"));
            }
            return;
        }
        BroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    block9: {
                        try {
                            Serializable data = intent.getExtras().getSerializable("callbackData");
                            List conversations = null;
                            Throwable error = null;
                            if (data instanceof Throwable) {
                                error = (Throwable)data;
                            } else if (data instanceof JSONArray) {
                                JSONArray content = (JSONArray)data;
                                conversations = AVIMConversationsQuery.this.parseQueryResult(content);
                                if (!AVUtils.isEmptyList((List)conversations)) {
                                    AVIMConversationsQuery.this.cacheQueryResult(queryParamsString, conversations);
                                }
                            } else if (data instanceof String && !AVUtils.isEmptyList((List)(conversations = AVIMConversationsQuery.this.parseQueryResult(JSON.parseArray((String)String.valueOf(data)))))) {
                                AVIMConversationsQuery.this.cacheQueryResult(queryParamsString, conversations);
                            }
                            if (callback != null) {
                                callback.internalDone(error == null ? conversations : null, error == null ? null : new AVException(error));
                            }
                            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Exception e) {
                            if (callback == null) break block9;
                            callback.internalDone(null, new AVException((Throwable)e));
                        }
                    }
                }
            };
        }
        this.client.sendClientCMDToPushService(queryParamsString, receiver, Conversation.AVIMOperation.CONVERSATION_QUERY);
    }

    private void cacheQueryResult(String queryParamsStr, List<AVIMConversation> conversations) {
        LinkedList<String> conversationList = new LinkedList<String>();
        AVIMMessageStorage storage = null;
        for (AVIMConversation conversation : conversations) {
            conversationList.add(conversation.getConversationId());
            storage = conversation.storage;
        }
        if (storage != null) {
            storage.insertConversations(conversations);
        }
        AVCacheManager.sharedInstance().save(queryParamsStr, JSON.toJSONString(conversationList), null);
    }

    private List<AVIMConversation> parseQueryResult(JSONArray content) {
        LinkedList<AVIMConversation> conversations = new LinkedList<AVIMConversation>();
        for (int i = 0; i < content.size(); ++i) {
            AVIMConversation convResult;
            JSONObject jsonObject = content.getJSONObject(i);
            AVIMConversation allNewConversation = AVIMConversation.parseFromJson(this.client, jsonObject);
            if (null == allNewConversation || null == (convResult = this.client.mergeConversationCache(allNewConversation, false, jsonObject))) continue;
            conversations.add(convResult);
        }
        return conversations;
    }

    public void setQueryPolicy(AVQuery.CachePolicy policy) {
        this.policy = policy;
    }

    public static AVIMConversationsQuery or(List<AVIMConversationsQuery> queries) {
        if (null == queries || 0 == queries.size()) {
            throw new IllegalArgumentException("Queries cannot be empty");
        }
        AVIMClient client = queries.get((int)0).client;
        AVIMConversationsQuery result = new AVIMConversationsQuery(client);
        for (AVIMConversationsQuery query : queries) {
            if (!client.clientId.equals(query.client.getClientId())) {
                throw new IllegalArgumentException("All queries must be for the same client");
            }
            result.conditions.addOrItems(new QueryOperation("$or", "$or", (Object)query.conditions.compileWhereOperationMap()));
        }
        return result;
    }

    public void setCacheMaxAge(long maxAgeInSecond) {
        this.maxAge = maxAgeInSecond * 1000L;
    }

    public long getCacheMaxAge() {
        return this.maxAge / 1000L;
    }

    static class CacheConversationQueryCallback
    extends GenericObjectCallback {
        AVIMConversationQueryCallback callback;
        AVIMClient client;

        public CacheConversationQueryCallback(AVIMClient client, AVIMConversationsQuery query, AVIMConversationQueryCallback callback) {
            this.callback = callback;
            this.client = client;
        }

        public void onSuccess(String content, AVException e) {
            if (!AVUtils.isBlankString((String)content)) {
                try {
                    List conversationList = (List)JSON.parseObject((String)content, List.class);
                    List<AVIMConversation> conversations = this.client.storage.getCachedConversations(conversationList);
                    if (conversations == null || conversations.size() < conversationList.size()) {
                        this.onFailure(AVErrorUtils.createException((int)120, (String)"Cache Missing"), null);
                        return;
                    }
                    this.callback.internalDone(conversations, null);
                }
                catch (Exception e1) {
                    this.callback.internalDone(null, new AVException((Throwable)e1));
                }
            } else {
                this.callback.internalDone(new LinkedList(), null);
            }
        }

        public void onFailure(Throwable error, String content) {
            this.callback.internalDone(null, new AVException(error));
        }
    }
}

