/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.IntentUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.PushServiceParcel;
import com.avos.avoscloud.QueryConditions;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.im.v2.AVIMBaseBroadcastReceiver;
import com.avos.avoscloud.im.v2.AVIMChatRoom;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMException;
import com.avos.avoscloud.im.v2.AVIMMessage;
import com.avos.avoscloud.im.v2.AVIMMessageInterval;
import com.avos.avoscloud.im.v2.AVIMMessageOption;
import com.avos.avoscloud.im.v2.AVIMMessageQueryDirection;
import com.avos.avoscloud.im.v2.AVIMMessageStorage;
import com.avos.avoscloud.im.v2.AVIMServiceConversation;
import com.avos.avoscloud.im.v2.AVIMTemporaryConversation;
import com.avos.avoscloud.im.v2.AVIMTypedMessage;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avoscloud.im.v2.callback.AVIMConversationCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationMemberCountCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationMemberQueryCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationSimpleResultCallback;
import com.avos.avoscloud.im.v2.callback.AVIMMessageRecalledCallback;
import com.avos.avoscloud.im.v2.callback.AVIMMessageUpdatedCallback;
import com.avos.avoscloud.im.v2.callback.AVIMMessagesQueryCallback;
import com.avos.avoscloud.im.v2.callback.AVIMOperationPartiallySucceededCallback;
import com.avos.avoscloud.im.v2.callback.AVIMSingleMessageQueryCallback;
import com.avos.avoscloud.im.v2.conversation.AVIMConversationMemberInfo;
import com.avos.avoscloud.im.v2.conversation.ConversationMemberRole;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessage;
import com.avos.avoscloud.im.v2.messages.AVIMFileMessageAccessor;
import com.avos.avoscloud.im.v2.messages.AVIMRecalledMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AVIMConversation {
    public static final int TRANSIENT_MESSAGE_FLAG = 16;
    public static final int RECEIPT_MESSAGE_FLAG = 256;
    private static final String ATTR_PERFIX = "attr.";
    String conversationId;
    Set<String> members;
    Map<String, Object> attributes;
    Map<String, Object> pendingAttributes;
    AVIMClient client;
    String creator;
    boolean isTransient;
    AVIMMessageStorage storage;
    Date lastMessageAt;
    AVIMMessage lastMessage;
    String createdAt;
    String updatedAt;
    Map<String, Object> instanceData = new HashMap<String, Object>();
    Map<String, Object> pendingInstanceData = new HashMap<String, Object>();
    private boolean isSyncLastMessage = false;
    int unreadMessagesCount = 0;
    boolean unreadMessagesMentioned = false;
    long lastDeliveredAt;
    long lastReadAt;
    boolean isSystem = false;
    boolean isTemporary = false;
    long temporaryExpiredat = 0L;
    int FETCH_TIME_INTERVEL = 3600000;
    long latestConversationFetch = 0L;
    static Comparator<AVIMMessage> messageComparator = new Comparator<AVIMMessage>(){

        @Override
        public int compare(AVIMMessage m1, AVIMMessage m2) {
            if (m1.getTimestamp() < m2.getTimestamp()) {
                return -1;
            }
            if (m1.getTimestamp() > m2.getTimestamp()) {
                return 1;
            }
            return m1.messageId.compareTo(m2.messageId);
        }
    };

    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    void setTemporary(boolean temporary) {
        this.isTemporary = temporary;
    }

    public long getTemporaryExpiredat() {
        return this.temporaryExpiredat;
    }

    public void setTemporaryExpiredat(long temporaryExpiredat) {
        if (this.isTemporary()) {
            this.temporaryExpiredat = temporaryExpiredat;
        }
    }

    protected int getType() {
        if (this.isSystem()) {
            return 3;
        }
        if (this.isTransient()) {
            return 2;
        }
        if (this.isTemporary()) {
            return 4;
        }
        return 1;
    }

    protected AVIMConversation(AVIMClient client, List<String> members, Map<String, Object> attributes, boolean isTransient) {
        this.members = new HashSet<String>();
        if (members != null) {
            this.members.addAll(members);
        }
        this.attributes = new HashMap<String, Object>();
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.client = client;
        this.pendingAttributes = new HashMap<String, Object>();
        this.isTransient = isTransient;
        this.storage = AVIMMessageStorage.getInstance(client.clientId);
    }

    protected AVIMConversation(AVIMClient client, String conversationId) {
        this(client, null, null, false);
        this.conversationId = conversationId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    protected void setConversationId(String id) {
        this.conversationId = id;
    }

    protected void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void sendMessage(AVIMMessage message, AVIMConversationCallback callback) {
        this.sendMessage(message, null, callback);
    }

    public void sendMessage(final AVIMMessage message, final AVIMMessageOption messageOption, final AVIMConversationCallback callback) {
        message.setConversationId(this.conversationId);
        message.setFrom(this.client.clientId);
        message.generateUniqueToken();
        message.setTimestamp(System.currentTimeMillis());
        if (!AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusFailed);
            if (callback != null) {
                callback.internalDone(new AVException(100, "Connection lost"));
            }
            return;
        }
        message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusSending);
        if (AVIMFileMessage.class.isAssignableFrom(message.getClass())) {
            AVIMFileMessageAccessor.upload((AVIMFileMessage)message, new SaveCallback(){

                public void done(AVException e) {
                    if (e != null) {
                        message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusFailed);
                        if (callback != null) {
                            callback.internalDone(e);
                        }
                    } else {
                        boolean ret = AVIMConversation.this.sendCMDToPushService(null, message, messageOption, Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE, callback, null);
                        if (!ret && null != callback) {
                            callback.internalDone(new AVException(119, "couldn't start service in background."));
                        }
                    }
                }
            });
        } else {
            boolean ret = this.sendCMDToPushService(null, message, messageOption, Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE, callback, null);
            if (!ret && null != callback) {
                callback.internalDone(new AVException(119, "couldn't start service in background."));
            }
        }
    }

    public void sendMessage(AVIMMessage message, int messageFlag, AVIMConversationCallback callback) {
        AVIMMessageOption option = new AVIMMessageOption();
        option.setReceipt((messageFlag & 0x100) == 256);
        option.setTransient((messageFlag & 0x10) == 16);
        this.sendMessage(message, option, callback);
    }

    public void updateMessage(AVIMMessage oldMessage, AVIMMessage newMessage, AVIMMessageUpdatedCallback callback) {
        PushServiceParcel parcel = new PushServiceParcel();
        parcel.setOldMessage(oldMessage);
        parcel.setNewMessage(newMessage);
        boolean ret = this.sendParcelToPushService(parcel, Conversation.AVIMOperation.CONVERSATION_UPDATE_MESSAGE, callback);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void recallMessage(AVIMMessage message, AVIMMessageRecalledCallback callback) {
        PushServiceParcel parcel = new PushServiceParcel();
        parcel.setRecallMessage(message);
        boolean ret = this.sendParcelToPushService(parcel, Conversation.AVIMOperation.CONVERSATION_RECALL_MESSAGE, callback);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void addToLocalCache(AVIMMessage message) {
        this.storage.insertLocalMessage(message);
    }

    public void removeFromLocalCache(AVIMMessage message) {
        this.storage.removeLocalMessage(message);
    }

    public void queryMessages(AVIMMessagesQueryCallback callback) {
        this.queryMessages(20, callback);
    }

    public void queryMessagesFromServer(int limit, final AVIMMessagesQueryCallback callback) {
        this.queryMessagesFromServer(null, 0L, limit, null, 0L, new AVIMMessagesQueryCallback(){

            @Override
            public void done(List<AVIMMessage> messages, AVIMException e) {
                if (null == e) {
                    if (AVIMClient.messageQueryCacheEnabled) {
                        AVIMConversation.this.processContinuousMessages(messages);
                    }
                    callback.internalDone(messages, null);
                } else {
                    callback.internalDone(null, e);
                }
            }
        });
    }

    public void queryMessagesFromCache(int limit, AVIMMessagesQueryCallback callback) {
        this.queryMessagesFromCache(null, 0L, limit, callback);
    }

    private void queryMessagesFromServer(String msgId, long timestamp, int limit, String toMsgId, long toTimestamp, AVIMMessagesQueryCallback callback) {
        this.queryMessagesFromServer(msgId, timestamp, false, toMsgId, toTimestamp, false, AVIMMessageQueryDirection.AVIMMessageQueryDirectionFromNewToOld, limit, callback);
    }

    public void queryMessagesByType(int msgType, int limit, AVIMMessagesQueryCallback callback) {
        this.queryMessagesByType(msgType, null, 0L, limit, callback);
    }

    public void queryMessagesByType(int msgType, String msgId, long timestamp, int limit, AVIMMessagesQueryCallback callback) {
        if (null == callback) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", msgId);
        params.put("ts", timestamp);
        params.put("sinc", false);
        params.put("tmid", "");
        params.put("tt", 0);
        params.put("tinc", false);
        params.put("direct", AVIMMessageQueryDirection.AVIMMessageQueryDirectionFromNewToOld.getCode());
        params.put("limit", limit);
        params.put("type", msgType);
        boolean ret = this.sendNonSideEffectCommand(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY, callback);
        if (!ret) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    private void queryMessagesFromServer(String msgId, long timestamp, boolean startClosed, String toMsgId, long toTimestamp, boolean toClosed, AVIMMessageQueryDirection direction, int limit, AVIMMessagesQueryCallback cb) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mid", msgId);
        params.put("ts", timestamp);
        params.put("sinc", startClosed);
        params.put("tmid", toMsgId);
        params.put("tt", toTimestamp);
        params.put("tinc", toClosed);
        params.put("direct", direction.getCode());
        params.put("limit", limit);
        params.put("type", 0);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY, cb);
        if (!ret && null != cb) {
            cb.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    private void queryMessagesFromCache(String msgId, long timestamp, int limit, final AVIMMessagesQueryCallback callback) {
        if (null != callback) {
            this.storage.getMessages(msgId, timestamp, limit, this.conversationId, new AVIMMessageStorage.StorageQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, List<Boolean> breakpoints) {
                    Collections.reverse(messages);
                    callback.internalDone(messages, null);
                }
            });
        }
    }

    public void queryMessages(final int limit, final AVIMMessagesQueryCallback callback) {
        if ((limit <= 0 || limit > 1000) && callback != null) {
            callback.internalDone(null, new AVException((Throwable)new IllegalArgumentException("limit should be in [1, 1000]")));
        }
        if (!AVIMClient.messageQueryCacheEnabled) {
            this.queryMessagesFromServer(null, 0L, limit, null, 0L, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, AVIMException e) {
                    if (callback != null) {
                        if (e != null) {
                            callback.internalDone(e);
                        } else {
                            callback.internalDone(messages, null);
                        }
                    }
                }
            });
            return;
        }
        if (!AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            this.queryMessagesFromCache(null, 0L, limit, callback);
        } else {
            AVIMMessage latestMessage;
            long cacheMessageCount = this.storage.getMessageCount(this.conversationId);
            long toTimestamp = 0L;
            String toMsgId = null;
            if (cacheMessageCount >= (long)limit && (latestMessage = this.storage.getLatestMessageWithBreakpoint(this.conversationId, false)) != null) {
                toMsgId = latestMessage.getMessageId();
                toTimestamp = latestMessage.getTimestamp();
            }
            this.queryMessagesFromServer(null, 0L, limit, toMsgId, toTimestamp, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, AVIMException e) {
                    if (e != null) {
                        if (e.getCode() == 124 || e.getCode() == 0 || e.getCode() == 3000) {
                            AVIMConversation.this.queryMessagesFromCache(null, 0L, limit, callback);
                        } else if (callback != null) {
                            callback.internalDone(e);
                        }
                    } else {
                        if (!AVUtils.isEmptyList(messages)) {
                            AVIMConversation.this.processContinuousMessages(messages);
                        }
                        AVIMConversation.this.queryMessagesFromCache(null, 0L, limit, callback);
                    }
                }
            });
        }
    }

    public void queryMessages(final String msgId, final long timestamp, final int limit, final AVIMMessagesQueryCallback callback) {
        if (AVUtils.isBlankString((String)msgId) && timestamp == 0L) {
            this.queryMessages(limit, callback);
            return;
        }
        if (!AVIMClient.messageQueryCacheEnabled) {
            this.queryMessagesFromServer(msgId, timestamp, limit, null, 0L, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, AVIMException e) {
                    if (callback != null) {
                        if (e != null) {
                            callback.internalDone(e);
                        } else {
                            callback.internalDone(messages, null);
                        }
                    }
                }
            });
            return;
        }
        this.storage.getMessage(msgId, timestamp, this.conversationId, new AVIMMessageStorage.StorageMessageCallback(){

            @Override
            public void done(final AVIMMessage indicatorMessage, boolean isIndicateMessageBreakPoint) {
                if (indicatorMessage == null || isIndicateMessageBreakPoint) {
                    String startMsgId = msgId;
                    long startTS = timestamp;
                    int requestLimit = limit;
                    AVIMConversation.this.queryMessagesFromServer(startMsgId, startTS, requestLimit, null, 0L, new AVIMMessagesQueryCallback(){

                        @Override
                        public void done(List<AVIMMessage> messages, AVIMException e) {
                            if (e != null) {
                                callback.internalDone(e);
                            } else {
                                LinkedList<AVIMMessage> cachedMsgs = new LinkedList<AVIMMessage>();
                                if (indicatorMessage != null) {
                                    cachedMsgs.add(indicatorMessage);
                                }
                                if (messages != null) {
                                    cachedMsgs.addAll(messages);
                                }
                                AVIMConversation.this.processContinuousMessages(cachedMsgs);
                                AVIMConversation.this.queryMessagesFromCache(msgId, timestamp, limit, callback);
                            }
                        }
                    });
                } else {
                    AVIMConversation.this.storage.getMessages(msgId, timestamp, limit, AVIMConversation.this.conversationId, new AVIMMessageStorage.StorageQueryCallback(){

                        @Override
                        public void done(List<AVIMMessage> messages, List<Boolean> breakpoints) {
                            AVIMConversation.this.processStorageQueryResult(messages, breakpoints, msgId, timestamp, limit, callback);
                        }
                    });
                }
            }
        });
    }

    public void queryMessages(AVIMMessageInterval interval, AVIMMessageQueryDirection direction, int limit, AVIMMessagesQueryCallback callback) {
        if (null == interval || limit < 0) {
            if (null != callback) {
                callback.internalDone(null, new AVException((Throwable)new IllegalArgumentException("interval must not null, or limit must great than 0.")));
            }
            return;
        }
        String mid = null;
        long ts = 0L;
        boolean startClosed = false;
        String tmid = null;
        long tts = 0L;
        boolean endClosed = false;
        if (null != interval.startIntervalBound) {
            mid = interval.startIntervalBound.messageId;
            ts = interval.startIntervalBound.timestamp;
            startClosed = interval.startIntervalBound.closed;
        }
        if (null != interval.endIntervalBound) {
            tmid = interval.endIntervalBound.messageId;
            tts = interval.endIntervalBound.timestamp;
            endClosed = interval.endIntervalBound.closed;
        }
        this.queryMessagesFromServer(mid, ts, startClosed, tmid, tts, endClosed, direction, limit, callback);
    }

    public void getLastMessage(final AVIMSingleMessageQueryCallback callback) {
        if (AVIMClient.messageQueryCacheEnabled) {
            this.queryMessagesFromCache(null, 0L, 1, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, AVIMException e) {
                    AVIMConversation.this.processLastMessageResult(messages, e, callback);
                }
            });
        } else {
            this.queryMessagesFromServer(null, 0L, 1, null, 0L, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> messages, AVIMException e) {
                    AVIMConversation.this.processLastMessageResult(messages, e, callback);
                }
            });
        }
    }

    private void processLastMessageResult(List<AVIMMessage> resultMessages, AVIMException e, AVIMSingleMessageQueryCallback callback) {
        if (e == null) {
            if (resultMessages != null && resultMessages.size() > 0) {
                callback.internalDone(resultMessages.get(0), null);
            } else {
                callback.done(null, null);
            }
        } else {
            callback.internalDone(null, e);
        }
    }

    private void processStorageQueryResult(List<AVIMMessage> cachedMessages, List<Boolean> breakpoints, String originMsgId, long originMsgTS, int limit, final AVIMMessagesQueryCallback callback) {
        boolean connected;
        final ArrayList<AVIMMessage> continuousMessages = new ArrayList<AVIMMessage>();
        int firstBreakPointIndex = -1;
        for (int index = 0; index < cachedMessages.size(); ++index) {
            if (breakpoints.get(index).booleanValue()) {
                firstBreakPointIndex = index;
                break;
            }
            continuousMessages.add(cachedMessages.get(index));
        }
        if (!(connected = AVUtils.isConnected((Context)AVOSCloud.applicationContext)) || continuousMessages.size() >= limit) {
            Collections.sort(continuousMessages, messageComparator);
            callback.internalDone(continuousMessages, null);
        } else {
            AVIMMessage startMessage;
            int restCount;
            if (!continuousMessages.isEmpty()) {
                restCount = limit - continuousMessages.size();
                startMessage = (AVIMMessage)continuousMessages.get(continuousMessages.size() - 1);
            } else {
                startMessage = null;
                restCount = limit;
            }
            this.queryMessagesFromServer(startMessage == null ? originMsgId : startMessage.messageId, startMessage == null ? originMsgTS : startMessage.timestamp, restCount, null, 0L, new AVIMMessagesQueryCallback(){

                @Override
                public void done(List<AVIMMessage> serverMessages, AVIMException e) {
                    if (e != null) {
                        if (continuousMessages.size() > 0) {
                            callback.internalDone(continuousMessages, null);
                        } else {
                            callback.internalDone(e);
                        }
                    } else {
                        if (serverMessages == null) {
                            serverMessages = new ArrayList<AVIMMessage>();
                        }
                        continuousMessages.addAll(serverMessages);
                        AVIMConversation.this.processContinuousMessages(continuousMessages);
                        callback.internalDone(continuousMessages, null);
                    }
                }
            });
        }
    }

    public void getAllMemberInfo(int offset, int limit, AVIMConversationMemberQueryCallback callback) {
        QueryConditions conditions = new QueryConditions();
        conditions.addWhereItem("cid", "__eq", (Object)this.conversationId);
        conditions.setSkip(offset);
        conditions.setLimit(limit);
        this.queryMemberInfo(conditions, callback);
    }

    public void getMemberInfo(String memberId, AVIMConversationMemberQueryCallback callback) {
        QueryConditions conditions = new QueryConditions();
        conditions.addWhereItem("cid", "__eq", (Object)this.conversationId);
        conditions.addWhereItem("peerId", "__eq", (Object)memberId);
        this.queryMemberInfo(conditions, callback);
    }

    public void updateMemberRole(String memberId, ConversationMemberRole role, AVIMConversationCallback callback) {
        AVIMConversationMemberInfo info = new AVIMConversationMemberInfo(this.conversationId, memberId, role);
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("conversation.memberDetails", info.getUpdateAttrs());
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_PROMOTE_MEMBER, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    private void updateNickName(String nickname, AVIMConversationCallback callback) {
    }

    private void updateMemberComment(String memberComment, AVIMConversationCallback callback) {
    }

    private void queryMemberInfo(QueryConditions queryConditions, AVIMConversationMemberQueryCallback callback) {
        if (null == queryConditions || null == callback) {
            return;
        }
        this.client.queryConversationMemberInfo(queryConditions, callback);
    }

    public void muteMembers(List<String> memberIds, AVIMOperationPartiallySucceededCallback callback) {
        if (null == memberIds || memberIds.size() < 1) {
            if (null != callback) {
                callback.done(new AVIMException(new IllegalArgumentException("memberIds is null")), null, null);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", memberIds);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_MUTE_MEMBER, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public void unmuteMembers(List<String> memberIds, AVIMOperationPartiallySucceededCallback callback) {
        if (null == memberIds || memberIds.size() < 1) {
            if (null != callback) {
                callback.done(new AVIMException(new IllegalArgumentException("memberIds is null")), null, null);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", memberIds);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_UNMUTE_MEMBER, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public void queryMutedMembers(int offset, int limit, AVIMConversationSimpleResultCallback callback) {
        if (null == callback) {
            return;
        }
        if (offset < 0 || limit > 100) {
            callback.internalDone(null, new AVIMException(new IllegalArgumentException("offset/limit is illegal.")));
            return;
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("limit", limit);
        params.put("skip", offset);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY, callback, null);
        if (!ret) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public void blockMembers(List<String> memberIds, AVIMOperationPartiallySucceededCallback callback) {
        if (null == memberIds || memberIds.size() < 1) {
            if (null != callback) {
                callback.done(new AVIMException(new IllegalArgumentException("memberIds is null")), null, null);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", memberIds);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_BLOCK_MEMBER, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void unblockMembers(List<String> memberIds, AVIMOperationPartiallySucceededCallback callback) {
        if (null == memberIds || memberIds.size() < 1) {
            if (null != callback) {
                callback.done(new AVIMException(new IllegalArgumentException("memberIds is null")), null, null);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", memberIds);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_UNBLOCK_MEMBER, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void queryBlockedMembers(int offset, int limit, AVIMConversationSimpleResultCallback callback) {
        if (null == callback) {
            return;
        }
        if (offset < 0 || limit > 100) {
            callback.internalDone(null, new AVIMException(new IllegalArgumentException("offset/limit is illegal.")));
            return;
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("limit", limit);
        params.put("skip", offset);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY, callback, null);
        if (!ret) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public void getMemberCount(AVIMConversationMemberCountCallback callback) {
        if (null == callback) {
            return;
        }
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY, callback);
        if (!ret) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void addMembers(final List<String> friendsList, AVIMConversationCallback callback) {
        AVException membersCheckException = AVIMClient.validateNonEmptyConversationMembers(friendsList);
        if (membersCheckException != null) {
            if (callback != null) {
                callback.internalDone(null, membersCheckException);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", friendsList);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_ADD_MEMBER, callback, new OperationCompleteCallback(){

            @Override
            public void onComplete() {
                AVIMConversation.this.members.addAll(friendsList);
                AVIMConversation.this.storage.insertConversations(Arrays.asList(AVIMConversation.this));
            }

            @Override
            public void onFailure() {
            }
        });
        if (!ret && null != callback) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public void kickMembers(final List<String> friendsList, AVIMConversationCallback callback) {
        AVException membersCheckException = AVIMClient.validateNonEmptyConversationMembers(friendsList);
        if (membersCheckException != null) {
            if (callback != null) {
                callback.internalDone(null, membersCheckException);
            }
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("conversation.member", friendsList);
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_RM_MEMBER, callback, new OperationCompleteCallback(){

            @Override
            public void onComplete() {
                AVIMConversation.this.members.removeAll(friendsList);
                AVIMConversation.this.storage.insertConversations(Arrays.asList(AVIMConversation.this));
            }

            @Override
            public void onFailure() {
            }
        });
        if (!ret && null != callback) {
            callback.internalDone(null, new AVException(119, "couldn't start service in background."));
        }
    }

    public List<String> getMembers() {
        ArrayList<String> allList = new ArrayList<String>();
        allList.addAll(this.members);
        return Collections.unmodifiableList(allList);
    }

    public void mute(AVIMConversationCallback callback) {
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_MUTE, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void unmute(AVIMConversationCallback callback) {
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_UNMUTE, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    protected void setMembers(List<String> m) {
        this.members.clear();
        if (m != null) {
            this.members.addAll(m);
        }
    }

    public long getLastReadAt() {
        return this.lastReadAt;
    }

    public long getLastDeliveredAt() {
        if (this.lastReadAt > this.lastDeliveredAt) {
            return this.lastReadAt;
        }
        return this.lastDeliveredAt;
    }

    void setLastReadAt(long timeStamp, boolean saveToLocal) {
        if (timeStamp > this.lastReadAt) {
            this.lastReadAt = timeStamp;
            if (saveToLocal) {
                this.storage.updateConversationTimes(this);
            }
        }
    }

    void setLastDeliveredAt(long timeStamp, boolean saveToLocal) {
        if (timeStamp > this.lastDeliveredAt) {
            this.lastDeliveredAt = timeStamp;
            if (saveToLocal) {
                this.storage.updateConversationTimes(this);
            }
        }
    }

    public void quit(AVIMConversationCallback callback) {
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_QUIT, callback, new OperationCompleteCallback(){

            @Override
            public void onComplete() {
                AVIMConversation.this.storage.deleteConversationData(AVIMConversation.this.conversationId);
                AVIMConversation.this.members.remove(AVIMConversation.this.client.getClientId());
            }

            @Override
            public void onFailure() {
            }
        });
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void set(String key, Object value) {
        if (!AVUtils.isBlankString((String)key) && null != value) {
            this.pendingInstanceData.put(key, value);
        }
    }

    public Object get(String key) {
        if (!AVUtils.isBlankString((String)key)) {
            if (this.pendingInstanceData.containsKey(key)) {
                return this.pendingInstanceData.get(key);
            }
            if (this.instanceData.containsKey(key)) {
                return this.instanceData.get(key);
            }
        }
        return null;
    }

    @Deprecated
    public Object getAttribute(String key) {
        Object value = this.pendingAttributes.containsKey(key) ? this.pendingAttributes.get(key) : this.attributes.get(key);
        return value;
    }

    @Deprecated
    public void setAttribute(String key, Object value) {
        if (!AVUtils.isBlankContent((String)key)) {
            if (key.startsWith(ATTR_PERFIX)) {
                this.pendingAttributes.put(key.substring(ATTR_PERFIX.length()), value);
            } else {
                this.pendingAttributes.put(key, value);
            }
        }
    }

    @Deprecated
    public void setAttributes(Map<String, Object> attr) {
        this.pendingAttributes.clear();
        this.pendingAttributes.putAll(attr);
    }

    void setAttributesForInit(Map<String, Object> attr) {
        this.attributes.clear();
        if (attr != null) {
            this.attributes.putAll(attr);
        }
    }

    public String getName() {
        return (String)this.getAttribute("name");
    }

    public void setName(String name) {
        this.pendingAttributes.put("name", name);
    }

    public Date getLastMessageAt() {
        AVIMMessage lastMessage = this.getLastMessage();
        if (null != lastMessage) {
            this.setLastMessageAt(new Date(lastMessage.getReceiptTimestamp()));
        }
        return this.lastMessageAt;
    }

    void setLastMessageAt(Date messageTime) {
        if (null != messageTime && (null == this.lastMessageAt || messageTime.after(this.lastMessageAt))) {
            this.lastMessageAt = messageTime;
        }
    }

    public AVIMMessage getLastMessage() {
        if (AVIMClient.messageQueryCacheEnabled && !this.isSyncLastMessage) {
            this.setLastMessage(this.getLastMessageFromLocal());
        }
        return this.lastMessage;
    }

    private AVIMMessage getLastMessageFromLocal() {
        if (AVIMClient.messageQueryCacheEnabled) {
            AVIMMessage lastMessageInLocal = this.storage.getLatestMessage(this.getConversationId());
            this.isSyncLastMessage = true;
            return lastMessageInLocal;
        }
        return null;
    }

    void setLastMessage(AVIMMessage lastMessage) {
        if (null != lastMessage) {
            if (null == this.lastMessage) {
                this.lastMessage = lastMessage;
            } else if (this.lastMessage.getTimestamp() <= lastMessage.getTimestamp()) {
                this.lastMessage = lastMessage;
            } else {
                LogUtil.log.d((String)("lastMessage timestamp is invalid. existed=" + this.lastMessage.getTimestamp() + ", newValue=" + lastMessage.getTimestamp()));
            }
        }
    }

    void increaseUnreadCount(int num, boolean mentioned) {
        this.unreadMessagesCount = this.getUnreadMessagesCount() + num;
        if (mentioned) {
            this.unreadMessagesMentioned = mentioned;
        }
    }

    void updateUnreadCountAndMessage(AVIMMessage lastMessage, int unreadCount, boolean mentioned) {
        if (null != lastMessage) {
            this.setLastMessage(lastMessage);
            this.storage.insertMessage(lastMessage, true);
        }
        if (this.unreadMessagesCount != unreadCount) {
            this.unreadMessagesCount = unreadCount;
            this.unreadMessagesMentioned = mentioned;
            this.storage.updateConversationUreadCount(this.conversationId, this.unreadMessagesCount, mentioned);
        }
    }

    public int getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public boolean unreadMessagesMentioned() {
        return this.unreadMessagesMentioned;
    }

    public void read() {
        if (!this.isTransient) {
            AVIMMessage lastMessage = this.getLastMessage();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null != lastMessage) {
                params.put("mid", lastMessage.getMessageId());
                params.put("ts", lastMessage.getTimestamp());
            }
            this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_READ, null, null);
        }
    }

    public Date getCreatedAt() {
        return AVUtils.dateFromString((String)this.createdAt);
    }

    void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return AVUtils.dateFromString((String)this.updatedAt);
    }

    void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void fetchReceiptTimestamps(AVIMConversationCallback callback) {
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_FETCH_RECEIPT_TIME, callback, null);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public void updateInfoInBackground(AVIMConversationCallback callback) {
        if (!this.pendingAttributes.isEmpty() || !this.pendingInstanceData.isEmpty()) {
            boolean ret;
            Map<String, Object> pendingAttrMap;
            HashMap<String, Object> attributesMap = new HashMap<String, Object>();
            if (!this.pendingAttributes.isEmpty() && null != (pendingAttrMap = AVIMConversation.processAttributes(this.pendingAttributes, false))) {
                attributesMap.putAll(pendingAttrMap);
            }
            if (!this.pendingInstanceData.isEmpty()) {
                attributesMap.putAll(this.pendingInstanceData);
            }
            HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>();
            if (!attributesMap.isEmpty()) {
                params.put("conversation.attributes", attributesMap);
            }
            if (!(ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_UPDATE, callback, new OperationCompleteCallback(){

                @Override
                public void onComplete() {
                    AVIMConversation.this.attributes.putAll(AVIMConversation.this.pendingAttributes);
                    AVIMConversation.this.pendingAttributes.clear();
                    AVIMConversation.this.instanceData.putAll(AVIMConversation.this.pendingInstanceData);
                    AVIMConversation.this.pendingInstanceData.clear();
                    AVIMConversation.this.storage.insertConversations(Arrays.asList(AVIMConversation.this));
                }

                @Override
                public void onFailure() {
                }
            })) && null != callback) {
                callback.internalDone(new AVException(119, "couldn't start service in background."));
            }
        } else {
            callback.internalDone(null);
        }
    }

    public void fetchInfoInBackground(AVIMConversationCallback callback) {
        if (AVUtils.isBlankString((String)this.conversationId)) {
            if (callback != null) {
                callback.internalDone(null, new AVException(102, "ConversationId is empty"));
            } else {
                LogUtil.avlog.e((String)"ConversationId is empty");
            }
            return;
        }
        Map<String, Object> params = this.getFetchRequestParams();
        boolean ret = this.sendCMDToPushService(JSON.toJSONString(params), Conversation.AVIMOperation.CONVERSATION_QUERY, callback);
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public Map<String, Object> getFetchRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.conversationId.startsWith("_tmp:")) {
            params.put("temp_id", this.conversationId);
        } else {
            HashMap<String, String> whereMap = new HashMap<String, String>();
            whereMap.put("objectId", this.conversationId);
            params.put("where", whereMap);
        }
        return params;
    }

    public void join(AVIMConversationCallback callback) {
        boolean ret = this.sendCMDToPushService(null, Conversation.AVIMOperation.CONVERSATION_JOIN, callback, new OperationCompleteCallback(){

            @Override
            public void onComplete() {
                AVIMConversation.this.members.add(AVIMConversation.this.client.getClientId());
            }

            @Override
            public void onFailure() {
            }
        });
        if (!ret && null != callback) {
            callback.internalDone(new AVException(119, "couldn't start service in background."));
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    void setTransientForInit(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isShouldFetch() {
        return null == this.getCreatedAt() || System.currentTimeMillis() - this.latestConversationFetch > (long)this.FETCH_TIME_INTERVEL;
    }

    public void setMustFetch() {
        this.latestConversationFetch = 0L;
    }

    private void processContinuousMessages(List<AVIMMessage> messages) {
        if (null != messages && !messages.isEmpty()) {
            Collections.sort(messages, messageComparator);
            this.setLastMessage(messages.get(messages.size() - 1));
            this.storage.insertContinuousMessages(messages, this.conversationId);
        }
    }

    void updateLocalMessage(AVIMMessage message) {
        this.storage.updateMessageForPatch(message);
    }

    private boolean sendParcelToPushService(final PushServiceParcel pushServiceParcel, final Conversation.AVIMOperation operation, AVCallback callback) {
        int requestId = AVUtils.getNextIMRequestId();
        Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
        i.setAction("com.avoscloud.im.v2.parcel.action");
        i.putExtra("conversation.data", (Parcelable)pushServiceParcel);
        i.putExtra("conversation.client", this.client.clientId);
        i.putExtra("convesration.id", this.conversationId);
        i.putExtra("conversation.type", this.getType());
        i.putExtra("conversation.requestId", requestId);
        i.putExtra("conversation.operation", operation.getCode());
        try {
            AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
            if (callback != null) {
                LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver((BroadcastReceiver)new AVIMBaseBroadcastReceiver(callback){

                    @Override
                    public void execute(Intent intent, Throwable error) {
                        if (null == error) {
                            long patchTime = intent.getLongExtra("message_patch_time", 0L);
                            if (operation.equals((Object)Conversation.AVIMOperation.CONVERSATION_RECALL_MESSAGE)) {
                                AVIMConversation.this.onMessageRecalled(pushServiceParcel, patchTime, this.callback);
                            } else {
                                AVIMConversation.this.onMessageUpdated(pushServiceParcel, patchTime, this.callback);
                            }
                        } else {
                            this.callback.internalDone(new AVException(error));
                        }
                    }
                }, new IntentFilter(operation.getOperation() + requestId));
            }
            return true;
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
            return false;
        }
    }

    private void onMessageRecalled(PushServiceParcel pushServiceParcel, long patchTime, AVCallback callback) {
        AVIMMessage oldMessage = pushServiceParcel.getRecallMessage();
        AVIMRecalledMessage recalledMessage = new AVIMRecalledMessage();
        this.copyMessageWithoutContent(oldMessage, recalledMessage);
        recalledMessage.setUpdateAt(patchTime);
        recalledMessage.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusRecalled);
        this.updateLocalMessage(recalledMessage);
        callback.internalDone((Object)recalledMessage, null);
    }

    private void onMessageUpdated(PushServiceParcel pushServiceParcel, long patchTime, AVCallback callback) {
        AVIMMessage oldMessage = pushServiceParcel.getOldMessage();
        AVIMMessage newMessage = pushServiceParcel.getNewMessage();
        this.copyMessageWithoutContent(oldMessage, newMessage);
        newMessage.setUpdateAt(patchTime);
        this.updateLocalMessage(newMessage);
        callback.internalDone((Object)newMessage, null);
    }

    private void copyMessageWithoutContent(AVIMMessage oldMessage, AVIMMessage newMessage) {
        newMessage.setMessageId(oldMessage.getMessageId());
        newMessage.setConversationId(oldMessage.getConversationId());
        newMessage.setFrom(oldMessage.getFrom());
        newMessage.setDeliveredAt(oldMessage.getDeliveredAt());
        newMessage.setReadAt(oldMessage.getReadAt());
        newMessage.setTimestamp(oldMessage.getTimestamp());
        newMessage.setMessageStatus(oldMessage.getMessageStatus());
        newMessage.setMessageIOType(oldMessage.getMessageIOType());
    }

    private boolean sendCMDToPushService(String dataInString, Conversation.AVIMOperation operation, AVCallback callback, OperationCompleteCallback occ) {
        return this.sendCMDToPushService(dataInString, null, null, operation, callback, occ);
    }

    protected boolean sendCMDToPushService(String dataInString, Conversation.AVIMOperation operation, AVCallback callback) {
        return this.sendCMDToPushService(dataInString, null, null, operation, callback, null);
    }

    private boolean sendNonSideEffectCommand(String dataInString, final Conversation.AVIMOperation operation, AVCallback callback) {
        if (null == callback) {
            return true;
        }
        int requestId = AVUtils.getNextIMRequestId();
        Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!AVUtils.isBlankString((String)dataInString)) {
            i.putExtra("conversation.data", dataInString);
        }
        i.putExtra("conversation.client", this.client.clientId);
        i.putExtra("convesration.id", this.conversationId);
        i.putExtra("conversation.type", this.getType());
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver((BroadcastReceiver)new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Intent intent, Throwable ex) {
                    if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY.getCode()) {
                        List historyMessages = intent.getParcelableArrayListExtra("callbackHistoryMessages");
                        if (ex != null) {
                            this.callback.internalDone(null, (AVException)new AVIMException(ex));
                        } else {
                            if (historyMessages == null) {
                                historyMessages = Collections.EMPTY_LIST;
                            }
                            this.callback.internalDone((Object)historyMessages, null);
                        }
                        return;
                    }
                }
            }, new IntentFilter(operation.getOperation() + requestId));
            return true;
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
            return false;
        }
    }

    private boolean sendCMDToPushService(String dataInString, final AVIMMessage message, final AVIMMessageOption messageOption, final Conversation.AVIMOperation operation, AVCallback callback, final OperationCompleteCallback occ) {
        int requestId = AVUtils.getNextIMRequestId();
        Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!AVUtils.isBlankString((String)dataInString)) {
            i.putExtra("conversation.data", dataInString);
        }
        if (message != null) {
            i.putExtra("conversation.data", (Parcelable)message);
            if (null != messageOption) {
                i.putExtra("conversation.messageoption", (Parcelable)messageOption);
                if (!this.isTransient && null != messageOption.getPriority() && AVOSCloud.isDebugLogEnabled()) {
                    LogUtil.avlog.d((String)"Message priority is invalid in transient conversation");
                }
            }
        }
        i.putExtra("conversation.client", this.client.clientId);
        i.putExtra("convesration.id", this.conversationId);
        i.putExtra("conversation.type", this.getType());
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
            if (callback != null) {
                LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver((BroadcastReceiver)new AVIMBaseBroadcastReceiver(callback){

                    @Override
                    public void execute(Intent intent, Throwable error) {
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_QUIT.getCode()) {
                            AVIMConversation.this.client.removeConversationCache(AVIMConversation.this);
                        }
                        if (error == null && occ != null) {
                            occ.onComplete();
                        } else if (error != null && occ != null) {
                            occ.onFailure();
                        }
                        if (message != null) {
                            if (error == null) {
                                long timestamp = intent.getExtras().getLong("callbackMessageTimeStamp", -1L);
                                String messageId = intent.getStringExtra("callbackMessageId");
                                message.setMessageId(messageId);
                                message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusSent);
                                if (timestamp != -1L) {
                                    message.setTimestamp(timestamp);
                                }
                                if ((null == messageOption || !messageOption.isTransient()) && AVIMClient.messageQueryCacheEnabled) {
                                    AVIMConversation.this.setLastMessage(message);
                                    AVIMConversation.this.storage.insertMessage(message, false);
                                } else {
                                    LogUtil.avlog.d((String)"skip inserting into local storage.");
                                }
                                AVIMConversation.this.lastMessageAt = new Date(timestamp);
                                AVIMConversation.this.storage.updateConversationLastMessageAt(AVIMConversation.this);
                            } else {
                                message.setMessageStatus(AVIMMessage.AVIMMessageStatus.AVIMMessageStatusFailed);
                            }
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY.getCode()) {
                            List historyMessages = intent.getParcelableArrayListExtra("callbackHistoryMessages");
                            if (error != null) {
                                this.callback.internalDone(null, (AVException)new AVIMException(124, 100, error.getMessage()));
                            } else {
                                AVIMConversation.this.setLastReadAt(intent.getLongExtra("callbackReadAt", 0L), false);
                                AVIMConversation.this.setLastDeliveredAt(intent.getLongExtra("callbackDeliveredAt", 0L), false);
                                AVIMConversation.this.storage.updateConversationTimes(AVIMConversation.this);
                                if (historyMessages == null) {
                                    historyMessages = Collections.EMPTY_LIST;
                                }
                                this.callback.internalDone((Object)historyMessages, null);
                            }
                            return;
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_UPDATE.getCode() && intent.getExtras().containsKey("callbackUpdatedAt")) {
                            String updatedAt;
                            AVIMConversation.this.updatedAt = updatedAt = intent.getExtras().getString("callbackUpdatedAt");
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY.getCode()) {
                            int memberCount = intent.getIntExtra("callbackMemberCount", 0);
                            this.callback.internalDone((Object)memberCount, (AVException)AVIMException.wrapperAVException(error));
                            return;
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_FETCH_RECEIPT_TIME.getCode()) {
                            AVIMConversation.this.setLastReadAt(intent.getLongExtra("callbackReadAt", 0L), false);
                            AVIMConversation.this.setLastDeliveredAt(intent.getLongExtra("callbackDeliveredAt", 0L), false);
                            AVIMConversation.this.storage.updateConversationTimes(AVIMConversation.this);
                            this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException(error));
                            return;
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_MUTE_MEMBER.getCode() || operation.getCode() == Conversation.AVIMOperation.CONVERSATION_UNMUTE_MEMBER.getCode() || operation.getCode() == Conversation.AVIMOperation.CONVERSATION_BLOCK_MEMBER.getCode() || operation.getCode() == Conversation.AVIMOperation.CONVERSATION_UNBLOCK_MEMBER.getCode()) {
                            String[] allowedList = intent.getStringArrayExtra("callbackConvMemberMutedSUCC");
                            ArrayList failedList = intent.getParcelableArrayListExtra("callbackConvMemberMutedFAIL");
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            result.put("callbackConvMemberMutedSUCC", allowedList);
                            result.put("callbackConvMemberMutedFAIL", failedList);
                            this.callback.internalDone(result, (AVException)AVIMException.wrapperAVException(error));
                            return;
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY.getCode() || operation.getCode() == Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY.getCode()) {
                            String[] result = intent.getStringArrayExtra("callbackData");
                            this.callback.internalDone(null != result ? Arrays.asList(result) : null, (AVException)AVIMException.wrapperAVException(error));
                            return;
                        }
                        if (operation.getCode() == Conversation.AVIMOperation.CONVERSATION_QUERY.getCode()) {
                            if (null != error) {
                                this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException(error));
                            } else {
                                Exception exception = AVIMConversation.this.processQueryResult(intent.getExtras().getSerializable("callbackData"));
                                this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException(exception));
                            }
                            return;
                        }
                        this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException(error));
                    }
                }, new IntentFilter(operation.getOperation() + requestId));
            }
        }
        catch (Exception ex) {
            LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
            return false;
        }
        return true;
    }

    public Exception processQueryResult(Serializable serializable) {
        if (null != serializable) {
            try {
                String result = (String)((Object)serializable);
                JSONArray jsonArray = JSON.parseArray((String)String.valueOf(result));
                if (null == jsonArray || jsonArray.isEmpty()) {
                    return new AVIMException(9100, "Conversation not found");
                }
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                AVIMConversation.updateConversation(this, jsonObject);
                this.client.mergeConversationCache(this, true, null);
                this.storage.insertConversations(Arrays.asList(this));
                this.latestConversationFetch = System.currentTimeMillis();
            }
            catch (Exception e) {
                return e;
            }
        } else {
            return new AVIMException(9100, "Conversation not found");
        }
        return null;
    }

    public static AVIMConversation parseFromJson(AVIMClient client, JSONObject jsonObj) {
        if (null == jsonObj || null == client) {
            return null;
        }
        String conversationId = jsonObj.getString("objectId");
        if (AVUtils.isBlankContent((String)conversationId)) {
            return null;
        }
        boolean systemConv = false;
        boolean transientConv = false;
        boolean tempConv = false;
        if (jsonObj.containsKey((Object)"sys")) {
            systemConv = jsonObj.getBoolean("sys");
        }
        if (jsonObj.containsKey((Object)"tr")) {
            transientConv = jsonObj.getBoolean("tr");
        }
        if (jsonObj.containsKey((Object)"temp")) {
            tempConv = jsonObj.getBoolean("temp");
        }
        AVIMConversation originConv = null;
        originConv = systemConv ? new AVIMServiceConversation(client, conversationId) : (tempConv ? new AVIMTemporaryConversation(client, conversationId) : (transientConv ? new AVIMChatRoom(client, conversationId) : new AVIMConversation(client, conversationId)));
        originConv.latestConversationFetch = System.currentTimeMillis();
        return AVIMConversation.updateConversation(originConv, jsonObj);
    }

    public static void mergeConversationFromJsonObject(AVIMConversation conversation, JSONObject jsonObj) {
        JSONObject moreAttributes;
        if (null == conversation || null == jsonObj) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (jsonObj.containsKey((Object)"name")) {
            attributes.put("name", jsonObj.getString("name"));
        }
        if (jsonObj.containsKey((Object)"attr") && (moreAttributes = jsonObj.getJSONObject("attr")) != null) {
            Map moreAttributesMap = (Map)JSON.toJavaObject((JSON)moreAttributes, Map.class);
            attributes.putAll(moreAttributesMap);
        }
        conversation.attributes.putAll(attributes);
        Set keySet = jsonObj.keySet();
        if (!keySet.isEmpty()) {
            for (String key : keySet) {
                if (Arrays.asList(Conversation.CONVERSATION_COLUMNS).contains(key)) continue;
                conversation.instanceData.put(key, jsonObj.get((Object)key));
            }
        }
    }

    static AVIMConversation updateConversation(AVIMConversation conversation, JSONObject jsonObj) {
        JSONObject moreAttributes;
        if (null == jsonObj || null == conversation) {
            return conversation;
        }
        String conversationId = jsonObj.getString("objectId");
        List m = (List)jsonObj.getObject("m", List.class);
        conversation.setMembers(m);
        conversation.setCreator(jsonObj.getString("c"));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (jsonObj.containsKey((Object)"name")) {
            attributes.put("name", jsonObj.getString("name"));
        }
        if (jsonObj.containsKey((Object)"attr") && (moreAttributes = jsonObj.getJSONObject("attr")) != null) {
            Map moreAttributesMap = (Map)JSON.toJavaObject((JSON)moreAttributes, Map.class);
            attributes.putAll(moreAttributesMap);
        }
        conversation.setAttributesForInit(attributes);
        conversation.instanceData.clear();
        Set keySet = jsonObj.keySet();
        if (!keySet.isEmpty()) {
            for (String key : keySet) {
                if (Arrays.asList(Conversation.CONVERSATION_COLUMNS).contains(key)) continue;
                conversation.instanceData.put(key, jsonObj.get((Object)key));
            }
        }
        if (jsonObj.containsKey((Object)"sys")) {
            conversation.instanceData.put("sys", jsonObj.get((Object)"sys"));
        }
        if (jsonObj.containsKey((Object)"mu")) {
            conversation.instanceData.put("mu", jsonObj.get((Object)"mu"));
        }
        if (jsonObj.containsKey((Object)"createdAt")) {
            conversation.setCreatedAt(jsonObj.getString("createdAt"));
        }
        if (jsonObj.containsKey((Object)"updatedAt")) {
            conversation.setUpdatedAt(jsonObj.getString("updatedAt"));
        }
        AVIMMessage message = AVIMTypedMessage.parseMessage(conversationId, jsonObj);
        conversation.setLastMessage(message);
        if (jsonObj.containsKey((Object)"lm")) {
            conversation.setLastMessageAt(AVUtils.dateFromMap((Map)((Map)jsonObj.getObject("lm", Map.class))));
        }
        if (jsonObj.containsKey((Object)"tr")) {
            conversation.isTransient = jsonObj.getBoolean("tr");
        }
        return conversation;
    }

    static Map<String, Object> processAttributes(Map<String, Object> attributes, boolean isCovered) {
        if (isCovered) {
            return AVIMConversation.processAttributesForCovering(attributes);
        }
        return AVIMConversation.processAttributesForIncremental(attributes);
    }

    static Map<String, Object> processAttributesForIncremental(Map<String, Object> attributes) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        if (attributes.containsKey("name")) {
            attributeMap.put("name", attributes.get("name"));
        }
        for (String k : attributes.keySet()) {
            if (Arrays.asList(Conversation.CONVERSATION_COLUMNS).contains(k)) continue;
            attributeMap.put(ATTR_PERFIX + k, attributes.get(k));
        }
        if (attributeMap.isEmpty()) {
            return null;
        }
        return attributeMap;
    }

    static JSONObject processAttributesForCovering(Map<String, Object> attributes) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        if (attributes.containsKey("name")) {
            attributeMap.put("name", attributes.get("name"));
        }
        HashMap<String, Object> innerAttribute = new HashMap<String, Object>();
        for (String k : attributes.keySet()) {
            if (Arrays.asList(Conversation.CONVERSATION_COLUMNS).contains(k)) continue;
            innerAttribute.put(k, attributes.get(k));
        }
        if (!innerAttribute.isEmpty()) {
            attributeMap.put("attr", innerAttribute);
        }
        if (attributeMap.isEmpty()) {
            return null;
        }
        return new JSONObject(attributeMap);
    }

    static interface OperationCompleteCallback {
        public void onComplete();

        public void onFailure();
    }
}

