/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.signature.Base64Decoder;
import com.avos.avoscloud.signature.Base64Encoder;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class NotifyUtil {
    protected static HandlerThread thread = new HandlerThread("com.avos.avoscloud.notify");
    static final int SERVICE_RESTART = 1024;
    static final String SERVICE_RESTART_ACTION = "com.avos.avoscloud.notify.action";
    static Handler notifyHandler;

    NotifyUtil() {
    }

    private static void registerApp() {
        Set<String> appSet = NotifyUtil.getRegisteredApps();
        if (appSet != null) {
            appSet.add(Base64Encoder.encode((String)AVOSCloud.applicationContext.getPackageName()));
            AVPersistenceUtils.sharedInstance();
            AVPersistenceUtils.saveContentToFile((String)JSON.toJSONString(appSet), (File)NotifyUtil.getRegisterAppsFile());
        }
    }

    private static Set<String> getRegisteredApps() {
        if (AVOSCloud.applicationContext == null) {
            return null;
        }
        File registerFile = NotifyUtil.getRegisterAppsFile();
        HashSet<String> appSet = new HashSet<String>();
        if (registerFile.exists()) {
            AVPersistenceUtils.sharedInstance();
            String registerApps = AVPersistenceUtils.readContentFromFile((File)registerFile);
            if (!AVUtils.isBlankString((String)registerApps)) {
                block5: {
                    try {
                        appSet.addAll((Collection)JSON.parseObject((String)registerApps, Set.class));
                    }
                    catch (Exception e) {
                        if (!AVOSCloud.showInternalDebugLog()) break block5;
                        LogUtil.log.e((String)"NotifyUtil", (String)"getRegisteredApps", (Exception)e);
                    }
                }
                return appSet;
            }
        }
        return appSet;
    }

    private static File getRegisterAppsFile() {
        File file = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/", "dontpanic.cp");
        if (file.exists()) {
            return file;
        }
        File folder = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/");
        folder.mkdirs();
        return file;
    }

    static {
        thread.start();
        notifyHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message m) {
                if (m.what == 1024 && AVOSCloud.applicationContext != null) {
                    this.removeMessages(1024);
                    try {
                        Set registeredApps = NotifyUtil.getRegisteredApps();
                        for (String encodedAppPackage : registeredApps) {
                            String appPackage = Base64Decoder.decode((String)encodedAppPackage);
                            if (AVOSCloud.applicationContext.getPackageName().equals(appPackage)) continue;
                            Intent intent = new Intent();
                            intent.setClassName(appPackage, "com.avos.avoscloud.PushService");
                            intent.setAction(NotifyUtil.SERVICE_RESTART_ACTION);
                            if (AVOSCloud.showInternalDebugLog()) {
                                LogUtil.avlog.d((String)("try to start:" + appPackage + " from:" + AVOSCloud.applicationContext.getPackageName()));
                            }
                            try {
                                AVOSCloud.applicationContext.startService(intent);
                            }
                            catch (Exception ex) {
                                LogUtil.avlog.e((String)("failed to startService. cause: " + ex.getMessage()));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NotifyUtil.registerApp();
                }
            }
        };
    }
}

