/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVLiveQueryEventHandler;
import com.avos.avoscloud.AVLiveQuerySubscribeCallback;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.IntentUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.PushService;
import com.avos.avoscloud.im.v2.AVIMBaseBroadcastReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AVLiveQuery {
    private static final String SUBSCRIBE_PATH = "LiveQuery/subscribe";
    private static final String UNSUBSCRIBE_PATH = "LiveQuery/unsubscribe";
    private static final String SUBSCRIBE_ID = "id";
    private static final String QUERY_ID = "query_id";
    private static final String SESSION_TOKEN = "sessionToken";
    private static final String QUERY = "query";
    private static final String OBJECT = "object";
    private static final String OP = "op";
    private static final String UPDATE_KEYS = "updatedKeys";
    static final String LIVEQUERY_PRIFIX = "live_query_";
    static final String ACTION_LIVE_QUERY_LOGIN = "action_live_query_login";
    private static String subscribeId;
    private String queryId;
    private AVQuery query;
    private static Set<AVLiveQuery> liveQuerySet;
    private AVLiveQueryEventHandler eventHandler;

    static void resumeSubscribeers() {
        for (AVLiveQuery query : liveQuerySet) {
            query.subscribeInBackground(null);
        }
    }

    private AVLiveQuery(AVQuery query) {
        this.query = query;
    }

    public static AVLiveQuery initWithQuery(AVQuery query) {
        if (null == query) {
            throw new IllegalArgumentException("query cannot be null");
        }
        return new AVLiveQuery(query);
    }

    public void subscribeInBackground(final AVLiveQuerySubscribeCallback callback) {
        Map params = this.query.assembleParameters();
        params.put("className", this.query.getClassName());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(QUERY, params);
        String session = this.getSessionToken();
        if (!AVUtils.isBlankString((String)session)) {
            dataMap.put(SESSION_TOKEN, session);
        }
        dataMap.put(SUBSCRIBE_ID, this.getSubscribeId());
        String jsonString = AVUtils.jsonStringFromMapWithNull(dataMap);
        PaasClient.storageInstance().postObject(SUBSCRIBE_PATH, jsonString, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                JSONObject jsonObject = JSONObject.parseObject((String)content);
                if (null != jsonObject && jsonObject.containsKey((Object)AVLiveQuery.QUERY_ID)) {
                    AVLiveQuery.this.queryId = jsonObject.getString(AVLiveQuery.QUERY_ID);
                    liveQuerySet.add(AVLiveQuery.this);
                    AVLiveQuery.this.loginLiveQuery(callback);
                } else if (null != callback) {
                    callback.internalDone(new AVException((Throwable)e));
                }
            }

            public void onFailure(Throwable error, String content) {
                if (null != callback) {
                    callback.internalDone(new AVException(error));
                }
            }
        });
    }

    public void setEventHandler(AVLiveQueryEventHandler eventHandler) {
        if (null == eventHandler) {
            throw new IllegalArgumentException("eventHandler can not be null.");
        }
        this.eventHandler = eventHandler;
    }

    private void loginLiveQuery(final AVLiveQuerySubscribeCallback callback) {
        block2: {
            int requestId = AVUtils.getNextIMRequestId();
            AVIMBaseBroadcastReceiver loginReceiver = new AVIMBaseBroadcastReceiver(null){

                @Override
                public void execute(Intent intent, Throwable error) {
                    if (null != callback) {
                        callback.internalDone(null == error ? null : new AVException(error));
                    }
                }
            };
            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).registerReceiver((BroadcastReceiver)loginReceiver, new IntentFilter(LIVEQUERY_PRIFIX + requestId));
            try {
                Intent i = new Intent(AVOSCloud.applicationContext, PushService.class);
                i.setAction(ACTION_LIVE_QUERY_LOGIN);
                i.putExtra(SUBSCRIBE_ID, this.getSubscribeId());
                i.putExtra("conversation.requestId", requestId);
                AVOSCloud.applicationContext.startService(IntentUtil.setupIntentFlags(i));
            }
            catch (Exception ex) {
                LogUtil.avlog.e((String)("failed to start PushServer. cause: " + ex.getMessage()));
                if (null == callback) break block2;
                callback.internalDone(new AVException((Throwable)ex));
            }
        }
    }

    public void unsubscribeInBackground(final AVLiveQuerySubscribeCallback callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SUBSCRIBE_ID, this.getSubscribeId());
        map.put(QUERY_ID, this.queryId);
        String jsonString = AVUtils.jsonStringFromMapWithNull(map);
        PaasClient.storageInstance().postObject(UNSUBSCRIBE_PATH, jsonString, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (null == e) {
                    liveQuerySet.remove(AVLiveQuery.this);
                    AVLiveQuery.this.queryId = "";
                    if (null != callback) {
                        callback.internalDone(null);
                    }
                } else if (null != callback) {
                    callback.internalDone(e);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (null != callback) {
                    callback.internalDone(new AVException(error));
                }
            }
        });
    }

    private String getSubscribeId() {
        if (AVUtils.isBlankString((String)subscribeId)) {
            String SP_LIVEQUERY_KEY = "livequery_keyzone";
            String SP_SUBSCRIBE_ID = "subscribeId";
            subscribeId = AVPersistenceUtils.sharedInstance().getPersistentSettingString("livequery_keyzone", "subscribeId", "");
            if (AVUtils.isBlankString((String)subscribeId)) {
                String packageName = AVOSCloud.applicationContext.getPackageName();
                String additionalStr = UUID.randomUUID().toString();
                subscribeId = AVUtils.md5((String)(packageName + additionalStr));
                AVPersistenceUtils.sharedInstance().savePersistentSettingString("livequery_keyzone", "subscribeId", subscribeId);
            }
        }
        return subscribeId;
    }

    private String getSessionToken() {
        AVUser currentUser = AVUser.getCurrentUser();
        if (null != currentUser) {
            return currentUser.getSessionToken();
        }
        return "";
    }

    static void processData(ArrayList<String> dataList) {
        for (final String data : dataList) {
            AVOSCloud.handler.post(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            JSONObject jsonObject = JSON.parseObject((String)data);
                            String op = jsonObject.getString(AVLiveQuery.OP);
                            String queryId = jsonObject.getString(AVLiveQuery.QUERY_ID);
                            JSONObject object = jsonObject.getJSONObject(AVLiveQuery.OBJECT);
                            if (!AVUtils.isBlankString((String)queryId)) {
                                ArrayList<String> updateKeyList = new ArrayList<String>();
                                if (jsonObject.containsKey((Object)AVLiveQuery.UPDATE_KEYS)) {
                                    JSONArray jsonArray = jsonObject.getJSONArray(AVLiveQuery.UPDATE_KEYS);
                                    for (Object item : jsonArray) {
                                        updateKeyList.add((String)item);
                                    }
                                }
                                for (AVLiveQuery liveQuery : liveQuerySet) {
                                    if (!queryId.equals(liveQuery.queryId) || null == liveQuery.eventHandler) continue;
                                    liveQuery.eventHandler.done(EventType.getType(op), AVUtils.parseObjectFromMap((Map)object), updateKeyList);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!AVOSCloud.isDebugLogEnabled()) break block6;
                            LogUtil.avlog.e((String)"Parsing json data error, ", (Exception)e);
                        }
                    }
                }
            });
        }
    }

    static {
        liveQuerySet = Collections.synchronizedSet(new HashSet());
    }

    public static enum EventType {
        CREATE("create"),
        UPDATE("update"),
        ENTER("enter"),
        LEAVE("leave"),
        DELETE("delete"),
        LOGIN("login"),
        UNKONWN("unknown");

        private String event;

        public static EventType getType(String event) {
            if (CREATE.getContent().equals(event)) {
                return CREATE;
            }
            if (UPDATE.getContent().equals(event)) {
                return UPDATE;
            }
            if (ENTER.getContent().equals(event)) {
                return ENTER;
            }
            if (LEAVE.getContent().equals(event)) {
                return LEAVE;
            }
            if (DELETE.getContent().equals(event)) {
                return DELETE;
            }
            if (LOGIN.getContent().equals(event)) {
                return LOGIN;
            }
            return UNKONWN;
        }

        private EventType(String event) {
            this.event = event;
        }

        public String getContent() {
            return this.event;
        }
    }
}

