/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.os.Bundle;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVPushConnectionManager;
import com.avos.avoscloud.AVSession;
import com.avos.avoscloud.AVSessionCacheHelper;
import com.avos.avoscloud.AVSessionListener;
import com.avos.avoscloud.BroadcastUtil;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMClientEventHandler;
import com.avos.avoscloud.im.v2.AVIMMessageManagerHelper;
import com.avos.avoscloud.im.v2.Conversation;
import java.util.ArrayList;
import java.util.List;

public class AVDefaultSessionListener
extends AVSessionListener {
    AVPushConnectionManager manager;

    public AVDefaultSessionListener(AVPushConnectionManager manager) {
        this.manager = manager;
    }

    @Override
    public void onSessionOpen(Context context, AVSession session, int requestId) {
        AVSessionCacheHelper.getTagCacheInstance().addSession(session.getSelfPeerId(), session.tag);
        if (requestId > -65537) {
            BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, Conversation.AVIMOperation.CLIENT_OPEN);
        }
    }

    @Override
    public void onSessionPaused(Context context, AVSession session) {
        AVIMClientEventHandler handler = AVIMMessageManagerHelper.getClientEventHandler();
        if (handler != null) {
            handler.processEvent(50006, null, null, AVIMClient.getInstance(session.getSelfPeerId()));
        }
    }

    @Override
    public void onSessionTokenRenewed(Context context, AVSession session, int requestId) {
        if (requestId > -65537) {
            BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, Conversation.AVIMOperation.CLIENT_REFRESH_TOKEN);
        }
    }

    @Override
    public void onSessionResumed(Context context, AVSession session) {
        AVIMClientEventHandler handler = AVIMMessageManagerHelper.getClientEventHandler();
        if (handler != null) {
            handler.processEvent(50007, null, null, AVIMClient.getInstance(session.getSelfPeerId()));
        }
    }

    @Override
    public void onSessionClosedFromServer(Context context, AVSession session, int code) {
        this.cleanSession(session);
        AVIMClientEventHandler handler = AVIMMessageManagerHelper.getClientEventHandler();
        if (handler != null) {
            handler.processEvent(50010, null, code, AVIMClient.getInstance(session.getSelfPeerId()));
        }
    }

    @Override
    public void onError(Context context, AVSession session, Throwable e, int sessionOperation, int requestId) {
        if (AVOSCloud.isDebugLogEnabled() || AVOSCloud.showInternalDebugLog()) {
            LogUtil.log.e((String)("session error:" + e));
        }
        if (requestId > -65537) {
            switch (sessionOperation) {
                case 10004: {
                    BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, e, Conversation.AVIMOperation.CLIENT_OPEN);
                    break;
                }
                case 10005: {
                    BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, e, Conversation.AVIMOperation.CLIENT_DISCONNECT);
                }
            }
            if (sessionOperation == Conversation.AVIMOperation.CONVERSATION_CREATION.getCode()) {
                BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, e, Conversation.AVIMOperation.CONVERSATION_CREATION);
            }
        }
    }

    @Override
    public void onSessionClose(Context context, AVSession session, int requestId) {
        this.manager.removeSession(session.getSelfPeerId());
        if (requestId > -65537) {
            BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestId, Conversation.AVIMOperation.CLIENT_DISCONNECT);
        }
    }

    @Override
    public void onGoaway(Context context, final AVSession session) {
        LogUtil.log.d((String)"received GOAWAY command and try to re-connect to rtm server...");
        this.manager.cleanupSocketConnection();
        this.manager.initConnection(new AVCallback(){

            protected void internalDone0(Object o, AVException avException) {
                if (null != avException) {
                    LogUtil.log.e((String)("failed to re-connect to rtm server. error:" + avException));
                } else {
                    session.reopen();
                }
            }
        });
    }

    private void cleanSession(AVSession session) {
        AVSessionCacheHelper.getTagCacheInstance().removeSession(session.getSelfPeerId());
        session.sessionOpened.set(false);
        session.cleanUp();
        this.manager.removeSession(session.getSelfPeerId());
    }

    @Override
    public void onOnlineQuery(Context context, AVSession session, List<String> onlinePeerIds, int requestCode) {
        if (requestCode != -65537) {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList("callbackOnlineClient", new ArrayList<String>(onlinePeerIds));
            BroadcastUtil.sendIMLocalBroadcast(session.getSelfPeerId(), null, requestCode, bundle, Conversation.AVIMOperation.CLIENT_ONLINE_QUERY);
        }
    }
}

