/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.session.PeerBasedCommandPacket;

public class UnreadMessagesClearPacket
extends PeerBasedCommandPacket {
    String conversationId;
    String messageId;
    long messageTS;

    public UnreadMessagesClearPacket() {
        this.setCmd("read");
    }

    String getConversationId() {
        return this.conversationId;
    }

    void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    void setMessageTS(long timestamp) {
        this.messageTS = timestamp;
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setReadMessage(this.getReadCommand());
        return builder;
    }

    protected Messages.ReadCommand getReadCommand() {
        Messages.ReadCommand.Builder builder = Messages.ReadCommand.newBuilder();
        Messages.ReadTuple.Builder readTupleBuilder = builder.addConvsBuilder();
        if (!AVUtils.isBlankString((String)this.messageId)) {
            readTupleBuilder.setMid(this.messageId);
        }
        if (this.messageTS > 0L) {
            readTupleBuilder.setTimestamp(this.messageTS);
        }
        readTupleBuilder.setCid(this.conversationId);
        return builder.build();
    }

    public static UnreadMessagesClearPacket getUnreadClearPacket(String peerId, String conversationId, String messageId, long timeStamp, int requestId) {
        UnreadMessagesClearPacket packet = new UnreadMessagesClearPacket();
        if (AVIMClient.getClientsCount() > 1) {
            packet.setPeerId(peerId);
        }
        packet.setConversationId(conversationId);
        packet.setRequestId(requestId);
        packet.setMessageId(messageId);
        packet.setMessageTS(timeStamp);
        return packet;
    }
}

