/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import android.os.Handler;
import android.os.HandlerThread;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.LogUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessageQueue<E>
implements Queue<E> {
    Queue<E> messages = new ConcurrentLinkedQueue();
    private final String queueKey;
    private static final String MESSAGE_ZONE = "com.avoscloud.chat.message";
    private static final String QUEUE_KEY = "com.avoscloud.chat.message.queue";
    private final Class<E> type;
    static HandlerThread serializeThread = new HandlerThread("com.avos.avoscloud.push.messagequeue");
    static Handler serializeHanlder;

    public MessageQueue(String peerId, Class<E> type) {
        this.type = type;
        this.queueKey = "com.avoscloud.chat.message.queue." + peerId;
        LinkedList<E> storedMessages = this.restoreMessageQueue();
        if (storedMessages != null && storedMessages.size() > 0) {
            this.messages.addAll(storedMessages);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean result = this.messages.addAll(collection);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public void clear() {
        this.messages.clear();
        this.storeMessageQueue();
    }

    @Override
    public boolean contains(Object object) {
        return this.messages.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.messages.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.messages.iterator();
    }

    @Override
    public boolean remove(Object object) {
        boolean result = this.messages.remove(object);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = this.messages.removeAll(collection);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean result = this.messages.retainAll(collection);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public Object[] toArray() {
        return this.messages.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.messages.toArray(array);
    }

    @Override
    public boolean add(E e) {
        boolean result = this.messages.add(e);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public boolean offer(E e) {
        boolean result = this.messages.offer(e);
        this.storeMessageQueue();
        return result;
    }

    @Override
    public E remove() {
        E result = this.messages.remove();
        this.storeMessageQueue();
        return result;
    }

    @Override
    public E poll() {
        E result = this.messages.poll();
        this.storeMessageQueue();
        return result;
    }

    @Override
    public E element() {
        E result = this.messages.element();
        this.storeMessageQueue();
        return result;
    }

    @Override
    public E peek() {
        return this.messages.peek();
    }

    private void storeMessageQueue() {
        serializeHanlder.post(new Runnable(){

            @Override
            public void run() {
                String queueString = JSON.toJSONString(MessageQueue.this.messages, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField, SerializerFeature.WriteClassName, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
                AVPersistenceUtils.sharedInstance().savePersistentSettingString(MessageQueue.MESSAGE_ZONE, MessageQueue.this.queueKey, queueString);
            }
        });
    }

    private synchronized LinkedList<E> restoreMessageQueue() {
        LinkedList storedMessages = new LinkedList();
        String queueString = AVPersistenceUtils.sharedInstance().getPersistentSettingString(MESSAGE_ZONE, this.queueKey, null);
        if (!AVUtils.isBlankString((String)queueString)) {
            try {
                storedMessages.addAll(JSON.parseArray((String)queueString, this.type));
            }
            catch (Exception e) {
                AVPersistenceUtils.sharedInstance().removePersistentSettingString(MESSAGE_ZONE, this.queueKey);
                LogUtil.log.e((String)e.getMessage());
            }
        }
        return storedMessages;
    }

    static {
        serializeThread.start();
        serializeHanlder = new Handler(serializeThread.getLooper());
    }

    public static interface HasId {
        public String getId();

        public void setId(String var1);
    }
}

