/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.session.PeerBasedCommandPacket;
import com.google.protobuf.ByteString;
import java.util.List;

public class MessagePatchModifyPacket
extends PeerBasedCommandPacket {
    private String conversationId;
    private String messageId;
    private long timestamp;
    private String messageData;
    private boolean isRecall;
    private boolean mentionAll;
    private List<String> mentionList;
    private ByteString binaryData = null;

    public MessagePatchModifyPacket() {
        this.setCmd("patch");
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setOp(Messages.OpType.modify);
        builder.setPatchMessage(this.getPatchCommand());
        return builder;
    }

    private Messages.PatchCommand getPatchCommand() {
        Messages.PatchCommand.Builder builder = Messages.PatchCommand.newBuilder();
        Messages.PatchItem.Builder patchItemBuilder = Messages.PatchItem.newBuilder();
        if (this.timestamp > 0L) {
            patchItemBuilder.setTimestamp(this.timestamp);
        }
        if (!AVUtils.isBlankString((String)this.messageId)) {
            patchItemBuilder.setMid(this.messageId);
        }
        if (!AVUtils.isBlankString((String)this.conversationId)) {
            patchItemBuilder.setCid(this.conversationId);
        }
        if (!AVUtils.isBlankString((String)this.messageData)) {
            patchItemBuilder.setData(this.messageData);
        }
        patchItemBuilder.setMentionAll(this.mentionAll);
        if (null != this.mentionList) {
            patchItemBuilder.addAllMentionPids(this.mentionList);
        }
        patchItemBuilder.setRecall(this.isRecall);
        if (null != this.binaryData) {
            patchItemBuilder.setDataBytes(this.binaryData);
        }
        builder.addPatches(patchItemBuilder.build());
        return builder.build();
    }

    public static MessagePatchModifyPacket getMessagePatchPacketForUpdate(String peerId, String conversationId, String messageId, String data, byte[] binaryData, boolean mentionAll, List<String> mentionList, long timestamp, int requestId) {
        MessagePatchModifyPacket packet = new MessagePatchModifyPacket();
        packet.conversationId = conversationId;
        packet.messageId = messageId;
        packet.timestamp = timestamp;
        packet.messageData = data;
        if (null != binaryData) {
            packet.binaryData = ByteString.copyFrom((byte[])binaryData);
        }
        packet.isRecall = false;
        packet.mentionAll = mentionAll;
        packet.mentionList = mentionList;
        packet.setRequestId(requestId);
        if (AVIMClient.getClientsCount() > 1) {
            packet.setPeerId(peerId);
        }
        return packet;
    }

    public static MessagePatchModifyPacket getMessagePatchPacketForRecall(String peerId, String conversationId, String messageId, long timestamp, int requestId) {
        MessagePatchModifyPacket packet = new MessagePatchModifyPacket();
        packet.conversationId = conversationId;
        packet.messageId = messageId;
        packet.timestamp = timestamp;
        packet.isRecall = true;
        packet.setRequestId(requestId);
        if (AVIMClient.getClientsCount() > 1) {
            packet.setPeerId(peerId);
        }
        return packet;
    }
}

