/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avospush.session;

import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.Messages;
import com.avos.avoscloud.Signature;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avospush.session.PeerBasedCommandPacket;
import java.util.List;
import java.util.Map;

public class ConversationControlPacket
extends PeerBasedCommandPacket {
    public static final String CONVERSATION_CMD = "conv";
    private List<String> members;
    private String signature;
    private long timestamp;
    private String nonce;
    private String conversationId;
    private String op;
    private Map<String, Object> attributes;
    private boolean isTransient;
    private boolean isUnique;
    private boolean isTemporary = false;
    private int tempTTL = 0;
    private Map<String, Object> memberInfo = null;
    private int queryOffset = 0;
    private int queryLimit = 0;

    public ConversationControlPacket() {
        this.setCmd(CONVERSATION_CMD);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean val) {
        this.isTemporary = val;
    }

    public int getTempTTL() {
        return this.tempTTL;
    }

    public void setTempTTL(int tempTTL) {
        this.tempTTL = tempTTL;
    }

    public void setMemberInfo(Map<String, Object> memberInfo) {
        this.memberInfo = memberInfo;
    }

    public int getQueryOffset() {
        return this.queryOffset;
    }

    public void setQueryOffset(int queryOffset) {
        this.queryOffset = queryOffset;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public void setQueryLimit(int queryLimit) {
        this.queryLimit = queryLimit;
    }

    @Override
    protected Messages.GenericCommand.Builder getGenericCommandBuilder() {
        Messages.GenericCommand.Builder builder = super.getGenericCommandBuilder();
        builder.setOp(Messages.OpType.valueOf(this.op));
        builder.setConvMessage(this.getConvCommand());
        return builder;
    }

    private Messages.ConvCommand getConvCommand() {
        Messages.ConvCommand.Builder builder = Messages.ConvCommand.newBuilder();
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Messages.JsonObjectMessage.Builder attrBuilder = Messages.JsonObjectMessage.newBuilder();
            attrBuilder.setData(this.attributes.toString());
            builder.setAttr(attrBuilder);
        }
        if (!AVUtils.isEmptyList(this.members)) {
            builder.addAllM(this.members);
        }
        if (this.getSignature() != null) {
            builder.setS(this.getSignature());
            builder.setT(this.getTimestamp());
            builder.setN(this.getNonce());
        }
        if (!AVUtils.isBlankString((String)this.conversationId)) {
            builder.setCid(this.conversationId);
        }
        if (this.isTransient) {
            builder.setTransient(this.isTransient);
        }
        if (this.isUnique) {
            builder.setUnique(this.isUnique);
        }
        if (this.isTemporary) {
            builder.setTempConv(this.isTemporary);
            builder.setTempConvTTL(this.tempTTL);
        }
        if (null != this.memberInfo) {
            Messages.ConvMemberInfo.Builder cmiBuilder = Messages.ConvMemberInfo.newBuilder();
            if (this.memberInfo.containsKey("peerId")) {
                cmiBuilder.setPid((String)this.memberInfo.get("peerId"));
                builder.setTargetClientId((String)this.memberInfo.get("peerId"));
            }
            if (this.memberInfo.containsKey("role")) {
                cmiBuilder.setRole((String)this.memberInfo.get("role"));
            }
            if (this.memberInfo.containsKey("infoId")) {
                cmiBuilder.setInfoId((String)this.memberInfo.get("infoId"));
            }
            builder.setInfo(cmiBuilder.build());
        }
        if (this.queryOffset > 0) {
            builder.setNext(new Integer(this.queryOffset).toString());
        }
        if (this.queryLimit > 0) {
            builder.setLimit(this.queryLimit);
        }
        return builder.build();
    }

    public static ConversationControlPacket genConversationCommand(String selfId, String conversationId, List<String> peers, String op, Map<String, Object> attributes, Signature signature, boolean isTransient, boolean isUnique, boolean isTemporary, int tempTTL, boolean isSystem, int requestId) {
        ConversationControlPacket ccp = new ConversationControlPacket();
        if (AVIMClient.getClientsCount() > 1) {
            ccp.setPeerId(selfId);
        }
        ccp.setConversationId(conversationId);
        ccp.setRequestId(requestId);
        ccp.setTransient(isTransient);
        ccp.setUnique(isUnique);
        ccp.setTemporary(isTemporary);
        if (isTemporary) {
            ccp.setTempTTL(tempTTL);
        }
        if (!AVUtils.isEmptyList(peers)) {
            ccp.setMembers(peers);
        }
        ccp.setOp(op);
        if (signature != null && (op.equals("add") || op.equals("remove") || op.equals("start"))) {
            ccp.setSignature(signature.getSignature());
            ccp.setNonce(signature.getNonce());
            ccp.setTimestamp(signature.getTimestamp());
        }
        ccp.setRequestId(requestId);
        ccp.setAttributes(attributes);
        return ccp;
    }

    public static ConversationControlPacket genConversationCommand(String selfId, String conversationId, List<String> peers, String op, Map<String, Object> attributes, Signature signature, boolean isTransient, int requestId) {
        return ConversationControlPacket.genConversationCommand(selfId, conversationId, peers, op, attributes, signature, isTransient, false, false, 0, false, requestId);
    }

    public static ConversationControlPacket genConversationCommand(String selfId, String conversationId, List<String> peers, String op, Map<String, Object> attributes, Signature signature, int requestId) {
        return ConversationControlPacket.genConversationCommand(selfId, conversationId, peers, op, attributes, signature, false, requestId);
    }

    public static ConversationControlPacket genConversationMemberCommand(String selfId, String conversationId, String op, Map<String, Object> memberInfo, Signature signature, int requestId) {
        ConversationControlPacket ccp = ConversationControlPacket.genConversationCommand(selfId, conversationId, null, op, null, signature, false, false, false, 0, false, requestId);
        ccp.setMemberInfo(memberInfo);
        return ccp;
    }

    public static class ConversationControlOp {
        public static final String START = "start";
        public static final String ADD = "add";
        public static final String REMOVE = "remove";
        public static final String QUERY = "query";
        public static final String UPDATE = "update";
        public static final String MUTE = "mute";
        public static final String UNMUTE = "unmute";
        public static final String COUNT = "count";
        public static final String MAX_READ = "max_read";
        public static final String MEMBER_UPDATE = "member_info_update";
        public static final String ADD_SHUTUP = "add_shutup";
        public static final String REMOVE_SHUTUP = "remove_shutup";
        public static final String QUERY_SHUTUP = "query_shutup";
        public static final String STARTED = "started";
        public static final String JOINED = "joined";
        public static final String MEMBER_JOINED = "members_joined";
        public static final String MEMBER_LEFTED = "members_left";
        public static final String ADDED = "added";
        public static final String REMOVED = "removed";
        public static final String LEFT = "left";
        public static final String QUERY_RESULT = "results";
        public static final String MEMBER_COUNT_QUERY_RESULT = "result";
        public static final String UPDATED = "updated";
        public static final String MEMBER_UPDATED = "member_info_updated";
        public static final String MEMBER_INFO_CHANGED = "member_info_changed";
        public static final String SHUTUP_ADDED = "shutup_added";
        public static final String SHUTUP_REMOVED = "shutup_removed";
        public static final String SHUTUPED = "shutuped";
        public static final String UNSHUTUPED = "unshutuped";
        public static final String MEMBER_SHUTPED = "members_shutuped";
        public static final String MEMBER_UNSHUTUPED = "members_unshutuped";
        public static final String QUERY_SHUTUP_RESULT = "shutup_result";
        public static final String BLOCKED = "blocked";
        public static final String UNBLOCKED = "unblocked";
        public static final String MEMBER_BLOCKED_NOTIFY = "members_blocked";
        public static final String MEMBER_UNBLOCKED_NOTIFY = "members_unblocked";
    }
}

