/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2.messages;

import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.im.v2.AVIMMessageCreator;
import com.avos.avoscloud.im.v2.AVIMMessageField;
import com.avos.avoscloud.im.v2.AVIMMessageType;
import com.avos.avoscloud.im.v2.AVIMTypedMessage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@AVIMMessageType(type=-6)
public class AVIMFileMessage
extends AVIMTypedMessage {
    static final String OBJECT_ID = "objId";
    static final String FILE_URL = "url";
    static final String FILE_META = "metaData";
    static final String FILE_SIZE = "size";
    static final String FORMAT = "format";
    static final String DURATION = "duration";
    private static final String LOCAL_PATH = "local_path";
    File localFile;
    AVFile actualFile;
    @AVIMMessageField(name="_lcfile")
    protected Map<String, Object> file;
    @AVIMMessageField(name="_lctext")
    String text;
    @AVIMMessageField(name="_lcattrs")
    Map<String, Object> attrs;
    ProgressCallback progressCallback;
    public static final AVIMMessageCreator<AVIMFileMessage> CREATOR = new AVIMMessageCreator<AVIMFileMessage>(AVIMFileMessage.class);

    public AVIMFileMessage() {
    }

    public AVIMFileMessage(String localPath) throws IOException {
        this(new File(localPath));
    }

    public AVIMFileMessage(File localFile) throws IOException {
        this.localFile = localFile;
        this.actualFile = AVFile.withFile((String)localFile.getName(), (File)localFile);
        this.file = new HashMap<String, Object>();
        this.file.put(LOCAL_PATH, localFile.getPath());
    }

    public AVIMFileMessage(AVFile file) {
        this.actualFile = file;
    }

    public Map<String, Object> getFile() {
        return this.file;
    }

    public String getLocalFilePath() {
        return null != this.localFile && this.localFile.exists() ? this.localFile.getPath() : null;
    }

    public AVFile getAVFile() {
        if (this.actualFile != null) {
            return this.actualFile;
        }
        if (null != this.file && this.file.containsKey(FILE_URL)) {
            Map avfileMeta = null;
            if (this.file.containsKey(FILE_META)) {
                avfileMeta = (Map)this.file.get(FILE_META);
            }
            AVFile avfile = new AVFile(null, (String)this.file.get(FILE_URL), avfileMeta);
            if (this.file.containsKey(OBJECT_ID)) {
                avfile.setObjectId((String)this.file.get(OBJECT_ID));
            }
            return avfile;
        }
        return null;
    }

    protected void setFile(Map<String, Object> file) {
        this.file = file;
        Map metaData = (Map)file.get(FILE_META);
        this.actualFile = new AVFile(null, (String)file.get(FILE_URL), metaData);
        this.actualFile.setObjectId((String)file.get(OBJECT_ID));
        if (file.containsKey(LOCAL_PATH)) {
            this.localFile = new File((String)file.get(LOCAL_PATH));
        }
    }

    public String getFileUrl() {
        if (this.file != null) {
            return (String)this.file.get(FILE_URL);
        }
        return null;
    }

    public Map<String, Object> getFileMetaData() {
        HashMap<String, Object> meta;
        if (this.file == null) {
            this.file = new HashMap<String, Object>();
        }
        if (!this.file.containsKey(FILE_META)) {
            meta = new HashMap<String, Integer>();
            meta.put(FILE_SIZE, this.actualFile.getSize());
        } else {
            meta = (Map)this.file.get(FILE_META);
        }
        return meta;
    }

    public long getSize() {
        Map<String, Object> meta = this.getFileMetaData();
        if (meta != null && meta.containsKey(FILE_SIZE)) {
            return Long.valueOf(meta.get(FILE_SIZE).toString());
        }
        return 0L;
    }

    protected void upload(final SaveCallback callback) {
        if (this.actualFile != null) {
            this.actualFile.saveInBackground(new SaveCallback(){

                public void done(AVException e) {
                    if (e != null) {
                        callback.internalDone(e);
                    } else {
                        AVIMFileMessage.this.fulFillFileInfo(callback);
                    }
                }
            }, this.progressCallback);
        } else {
            callback.internalDone(new AVException((Throwable)new RuntimeException("cannot find the file!")));
        }
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.progressCallback = callback;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Map<String, Object> attr) {
        this.attrs = attr;
    }

    protected void fulFillFileInfo(final SaveCallback callback) {
        if (this.actualFile != null) {
            Map<Object, Object> metaData;
            this.file = this.getFile() == null ? new HashMap() : this.getFile();
            this.file.put(OBJECT_ID, this.actualFile.getObjectId());
            this.file.put(FILE_URL, this.actualFile.getUrl());
            this.file.remove(LOCAL_PATH);
            Map<Object, Object> map = metaData = this.getFileMetaData() == null ? new HashMap() : this.getFileMetaData();
            if (!metaData.containsKey(FILE_SIZE)) {
                metaData.put(FILE_SIZE, this.actualFile.getSize());
            }
            this.getAdditionalMetaData(metaData, new SaveCallback(){

                public void done(AVException e) {
                    AVIMFileMessage.this.file.put(AVIMFileMessage.FILE_META, metaData);
                    if (callback != null) {
                        callback.internalDone(e);
                    }
                }
            });
        } else {
            callback.internalDone(new AVException((Throwable)new RuntimeException("cannot find the file!")));
        }
    }

    static boolean isExternalAVFile(AVFile avFile) {
        return null != avFile && null != avFile.getMetaData() && avFile.getMetaData().containsKey("__source") && avFile.getMetaData().get("__source").equals("external");
    }

    protected void getAdditionalMetaData(Map<String, Object> meta, SaveCallback callback) {
        callback.internalDone(null);
    }
}

