/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRequestParams;
import com.avos.avoscloud.AVResponse;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMException;
import com.avos.avoscloud.im.v2.AVIMReadonlyConversation;
import com.avos.avoscloud.im.v2.callback.AVIMConversationCallback;
import com.avos.avoscloud.im.v2.callback.AVIMConversationMemberCountCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AVIMServiceConversation
extends AVIMReadonlyConversation {
    private static final String SUBSCRIBERCOUNT_PATH = "rtm/conversation/subscribed";

    protected AVIMServiceConversation(AVIMClient client, List<String> members, Map<String, Object> attributes) {
        super(client, members, attributes);
        this.isSystem = true;
    }

    protected AVIMServiceConversation(AVIMClient client, String conversationId) {
        super(client, conversationId);
        this.isSystem = true;
    }

    public void subscribe(AVIMConversationCallback callback) {
        this.join(callback);
    }

    public void unsubscribe(AVIMConversationCallback callback) {
        this.quit(callback);
    }

    public void getSubscriberCount(final AVIMConversationMemberCountCallback callback) {
        if (null == callback) {
            return;
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("conv_id", this.conversationId);
        AVRequestParams params = new AVRequestParams(queryParams);
        PaasClient.storageInstance().getObject(SUBSCRIBERCOUNT_PATH, params, false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (null != e) {
                    callback.internalDone(null, new AVIMException(e));
                } else {
                    int result = 0;
                    if (AVUtils.isBlankContent((String)content)) {
                        LogUtil.log.e((String)"response is empty for request rtm/conversation/subscribed");
                    } else {
                        try {
                            AVResponse resp = new AVResponse();
                            resp = (AVResponse)JSON.parseObject((String)content, resp.getClass());
                            result = resp.count;
                        }
                        catch (Exception ex) {
                            LogUtil.log.e((String)"failed to parse result for request rtm/conversation/subscribed", (Exception)ex);
                        }
                    }
                    callback.internalDone(result, null);
                }
            }

            public void onFailure(Throwable error, String content) {
                LogUtil.log.e((String)("failed to query rtm/conversation/subscribed cause: " + error.getMessage()));
                callback.internalDone(null, new AVIMException(content, error));
            }
        }, AVQuery.CachePolicy.NETWORK_ONLY, 86400000L);
    }
}

