/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.os.Parcel;
import android.os.Parcelable;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.im.v2.AVIMMessageCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class AVIMMessage
implements Parcelable {
    String conversationId;
    String content;
    String from;
    long timestamp;
    long deliveredAt;
    long readAt;
    long updateAt;
    List<String> mentionList = null;
    boolean mentionAll = false;
    String currentClient = null;
    String messageId;
    String uniqueToken;
    AVIMMessageStatus status;
    AVIMMessageIOType ioType;
    public static final AVIMMessageCreator<AVIMMessage> CREATOR = new AVIMMessageCreator<AVIMMessage>(AVIMMessage.class);

    public AVIMMessage() {
        this(null, null);
    }

    public AVIMMessage(String conversationId, String from) {
        this(conversationId, from, 0L, 0L);
    }

    public AVIMMessage(String conversationId, String from, long timestamp, long deliveredAt) {
        this(conversationId, from, timestamp, deliveredAt, 0L);
    }

    public AVIMMessage(String conversationId, String from, long timestamp, long deliveredAt, long readAt) {
        this.ioType = AVIMMessageIOType.AVIMMessageIOTypeOut;
        this.status = AVIMMessageStatus.AVIMMessageStatusNone;
        this.conversationId = conversationId;
        this.from = from;
        this.timestamp = timestamp;
        this.deliveredAt = deliveredAt;
        this.readAt = readAt;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getReceiptTimestamp() {
        return this.deliveredAt;
    }

    public void setReceiptTimestamp(long receiptTimestamp) {
        this.deliveredAt = receiptTimestamp;
    }

    void setDeliveredAt(long deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    public long getDeliveredAt() {
        return this.deliveredAt;
    }

    void setReadAt(long readAt) {
        this.readAt = readAt;
    }

    long getReadAt() {
        return this.readAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public long getUpdateAt() {
        return this.updateAt;
    }

    public void setMessageStatus(AVIMMessageStatus status) {
        this.status = status;
    }

    public AVIMMessageStatus getMessageStatus() {
        return this.status;
    }

    public AVIMMessageIOType getMessageIOType() {
        return this.ioType;
    }

    public void setMessageIOType(AVIMMessageIOType ioType) {
        this.ioType = ioType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public int describeContents() {
        return 0;
    }

    public boolean mentioned() {
        return this.isMentionAll() || null != this.mentionList && this.mentionList.contains(this.currentClient);
    }

    public void setMentionList(List<String> peerIdList) {
        this.mentionList = peerIdList;
    }

    public List<String> getMentionList() {
        return this.mentionList;
    }

    public String getMentionListString() {
        if (null == this.mentionList) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mentionList.size(); ++i) {
            builder.append(this.mentionList.get(i));
            if (i == this.mentionList.size() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public void setMentionListString(String content) {
        if (AVUtils.isBlankString((String)content)) {
            this.mentionList = null;
        } else {
            String[] peerIdArray = content.split(",");
            this.mentionList = new ArrayList<String>(peerIdArray.length);
            this.mentionList.addAll(Arrays.asList(peerIdArray));
        }
    }

    public boolean isMentionAll() {
        return this.mentionAll;
    }

    public void setMentionAll(boolean mentionAll) {
        this.mentionAll = mentionAll;
    }

    void setCurrentClient(String clientId) {
        this.currentClient = clientId;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.conversationId);
        out.writeString(this.getContent());
        out.writeString(this.from);
        out.writeLong(this.timestamp);
        out.writeLong(this.deliveredAt);
        out.writeLong(this.readAt);
        out.writeLong(this.updateAt);
        out.writeString(this.messageId);
        out.writeInt(this.status.getStatusCode());
        out.writeInt(this.ioType.getIOType());
        out.writeString(this.uniqueToken);
        out.writeInt(this.mentionAll ? 1 : 0);
        out.writeString(this.getMentionListString());
    }

    public AVIMMessage(Parcel in) {
        this.conversationId = in.readString();
        this.setContent(in.readString());
        this.setFrom(in.readString());
        this.setTimestamp(in.readLong());
        this.setDeliveredAt(in.readLong());
        this.setReadAt(in.readLong());
        this.setUpdateAt(in.readLong());
        this.setMessageId(in.readString());
        this.status = AVIMMessageStatus.getMessageStatus(in.readInt());
        this.ioType = AVIMMessageIOType.getMessageIOType(in.readInt());
        this.uniqueToken = in.readString();
        int mentionFlag = in.readInt();
        this.mentionAll = mentionFlag == 1;
        String mentionLst = in.readString();
        this.setMentionListString(mentionLst);
        this.initMessage(in);
    }

    protected void initMessage(Parcel in) {
    }

    protected synchronized void generateUniqueToken() {
        if (AVUtils.isBlankString((String)this.uniqueToken)) {
            this.uniqueToken = UUID.randomUUID().toString();
        }
    }

    void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    protected String getUniqueToken() {
        return this.uniqueToken;
    }

    public static enum AVIMMessageIOType {
        AVIMMessageIOTypeIn(1),
        AVIMMessageIOTypeOut(2);

        int ioType;

        private AVIMMessageIOType(int type) {
            this.ioType = type;
        }

        public int getIOType() {
            return this.ioType;
        }

        public static AVIMMessageIOType getMessageIOType(int type) {
            switch (type) {
                case 1: {
                    return AVIMMessageIOTypeIn;
                }
                case 2: {
                    return AVIMMessageIOTypeOut;
                }
            }
            return AVIMMessageIOTypeOut;
        }
    }

    public static enum AVIMMessageStatus {
        AVIMMessageStatusNone(0),
        AVIMMessageStatusSending(1),
        AVIMMessageStatusSent(2),
        AVIMMessageStatusReceipt(3),
        AVIMMessageStatusFailed(4),
        AVIMMessageStatusRecalled(5);

        int statusCode;

        private AVIMMessageStatus(int status) {
            this.statusCode = status;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public static AVIMMessageStatus getMessageStatus(int statusCode) {
            switch (statusCode) {
                case 0: {
                    return AVIMMessageStatusNone;
                }
                case 1: {
                    return AVIMMessageStatusSending;
                }
                case 2: {
                    return AVIMMessageStatusSent;
                }
                case 3: {
                    return AVIMMessageStatusReceipt;
                }
                case 4: {
                    return AVIMMessageStatusFailed;
                }
                case 5: {
                    return AVIMMessageStatusRecalled;
                }
            }
            return null;
        }
    }
}

