/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.im.v2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.ObjectValueFilter;
import com.avos.avoscloud.QueryOperation;
import com.avos.avoscloud.im.v2.AVIMClient;
import com.avos.avoscloud.im.v2.AVIMConversation;
import com.avos.avoscloud.im.v2.AVIMConversationQueryConditions;
import com.avos.avoscloud.im.v2.AVIMMessageStorage;
import com.avos.avoscloud.im.v2.Conversation;
import com.avos.avoscloud.im.v2.callback.AVIMConversationQueryCallback;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AVIMConversationQuery {
    private AVIMClient client;
    AVIMConversationQueryConditions conditions;
    AVQuery.CachePolicy policy = AVQuery.CachePolicy.CACHE_ELSE_NETWORK;
    private static final long MAX_CONVERSATION_CACHE_TIME = 3600000L;
    private long maxAge = 3600000L;

    protected AVIMConversationQuery(AVIMClient client) {
        this.client = client;
        this.conditions = new AVIMConversationQueryConditions();
    }

    public AVIMConversationQuery withMembers(List<String> peerIds) {
        return this.withMembers(peerIds, false);
    }

    public AVIMConversationQuery withMembers(List<String> peerIds, boolean includeSelf) {
        HashSet<String> targetPeerIds = new HashSet<String>(peerIds);
        if (includeSelf) {
            targetPeerIds.add(this.client.clientId);
        }
        this.containsMembers(new LinkedList<String>(targetPeerIds));
        this.whereSizeEqual("m", targetPeerIds.size());
        return this;
    }

    public AVIMConversationQuery containsMembers(List<String> peerIds) {
        this.conditions.addWhereItem("m", "$all", peerIds);
        return this;
    }

    public AVIMConversationQuery whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereLessThanOrEqualsTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereGreaterThanOrEqualsTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereNotEqualsTo(String key, Object value) {
        this.conditions.whereNotEqualTo(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereContainsIn(String key, Collection<?> value) {
        this.conditions.whereContainedIn(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereExists(String key) {
        this.conditions.whereExists(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery whereNotContainsIn(String key, Collection<?> value) {
        this.conditions.whereNotContainedIn(this.getColumnKey(key), value);
        return this;
    }

    public AVIMConversationQuery whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(this.getColumnKey(key), values);
        return this;
    }

    public AVIMConversationQuery whereContains(String key, String subString) {
        this.conditions.whereContains(this.getColumnKey(key), subString);
        return this;
    }

    public AVIMConversationQuery whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(this.getColumnKey(key), prefix);
        return this;
    }

    public AVIMConversationQuery whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(this.getColumnKey(key), suffix);
        return this;
    }

    public AVIMConversationQuery whereMatches(String key, String regex) {
        this.conditions.whereMatches(this.getColumnKey(key), regex);
        return this;
    }

    public AVIMConversationQuery whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(this.getColumnKey(key), regex, modifiers);
        return this;
    }

    public AVIMConversationQuery whereNear(String key, AVGeoPoint point) {
        this.conditions.whereNear(this.getColumnKey(key), point);
        return this;
    }

    public AVIMConversationQuery whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(this.getColumnKey(key), southwest, northeast);
        return this;
    }

    public AVIMConversationQuery whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(this.getColumnKey(key), point, maxDistance);
        return this;
    }

    public AVIMConversationQuery whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(this.getColumnKey(key), point, maxDistance);
        return this;
    }

    public AVIMConversationQuery whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(this.getColumnKey(key), point, maxDistance);
        return this;
    }

    public AVIMConversationQuery setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public AVIMConversationQuery limit(int limit) {
        return this.setLimit(limit);
    }

    public AVIMConversationQuery setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public AVIMConversationQuery skip(int skip) {
        return this.setSkip(skip);
    }

    public AVIMConversationQuery orderByAscending(String key) {
        this.conditions.orderByAscending(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery orderByDescending(String key) {
        this.conditions.orderByDescending(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(this.getColumnKey(key));
        return this;
    }

    public AVIMConversationQuery whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(this.getColumnKey(key), size);
        return this;
    }

    public boolean isWithLastMessagesRefreshed() {
        return this.conditions.isWithLastMessagesRefreshed();
    }

    public AVIMConversationQuery setWithLastMessagesRefreshed(boolean isWithLastMessageRefreshed) {
        this.conditions.setWithLastMessagesRefreshed(isWithLastMessageRefreshed);
        return this;
    }

    public AVIMConversationQuery setCompact(boolean isCompact) {
        this.conditions.setCompact(isCompact);
        return this;
    }

    private String getAttributeKey(String key) {
        return "attr." + key;
    }

    private String getColumnKey(String key) {
        if (Arrays.asList(Conversation.CONVERSATION_COLUMNS).contains(key)) {
            return key;
        }
        if (key.startsWith("attr.")) {
            return key;
        }
        return this.getAttributeKey(key);
    }

    public void findInBackground(AVIMConversationQueryCallback callback) {
        Map<String, String> queryParams = this.conditions.assembleParameters();
        final String queryParamsString = JSON.toJSONString(queryParams, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[0]);
        switch (this.policy) {
            case CACHE_THEN_NETWORK: 
            case CACHE_ELSE_NETWORK: {
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback){

                    @Override
                    public void onFailure(Throwable error, String content) {
                        AVIMConversationQuery.this.queryFromNetwork(this.callback, queryParamsString);
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                if (AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
                    this.queryFromNetwork(callback, queryParamsString);
                    break;
                }
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback));
                break;
            }
            case CACHE_ONLY: {
                AVCacheManager.sharedInstance().get(queryParamsString, this.maxAge, null, (GenericObjectCallback)new CacheConversationQueryCallback(this.client, this, callback));
                break;
            }
            case NETWORK_ONLY: 
            case IGNORE_CACHE: {
                this.queryFromNetwork(callback, queryParamsString);
            }
        }
    }

    private void queryFromNetwork(final AVIMConversationQueryCallback callback, final String queryParamsString) {
        if (!AVUtils.isConnected((Context)AVOSCloud.applicationContext)) {
            if (callback != null) {
                callback.internalDone(null, new AVException(100, "Connection lost"));
            }
            return;
        }
        BroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    block9: {
                        try {
                            Serializable data = intent.getExtras().getSerializable("callbackData");
                            List conversations = null;
                            Throwable error = null;
                            if (data instanceof Throwable) {
                                error = (Throwable)data;
                            } else if (data instanceof JSONArray) {
                                JSONArray content = (JSONArray)data;
                                conversations = AVIMConversationQuery.this.parseQueryResult(content);
                                if (!AVUtils.isEmptyList((List)conversations)) {
                                    AVIMConversationQuery.this.cacheQueryResult(queryParamsString, conversations);
                                }
                            } else if (data instanceof String && !AVUtils.isEmptyList((List)(conversations = AVIMConversationQuery.this.parseQueryResult(JSON.parseArray((String)String.valueOf(data)))))) {
                                AVIMConversationQuery.this.cacheQueryResult(queryParamsString, conversations);
                            }
                            if (callback != null) {
                                callback.internalDone(error == null ? conversations : null, error == null ? null : new AVException(error));
                            }
                            LocalBroadcastManager.getInstance((Context)AVOSCloud.applicationContext).unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Exception e) {
                            if (callback == null) break block9;
                            callback.internalDone(null, new AVException((Throwable)e));
                        }
                    }
                }
            };
        }
        this.client.sendClientCMDToPushService(queryParamsString, receiver, Conversation.AVIMOperation.CONVERSATION_QUERY);
    }

    private void cacheQueryResult(String queryParamsStr, List<AVIMConversation> conversations) {
        LinkedList<String> conversationList = new LinkedList<String>();
        AVIMMessageStorage storage = null;
        for (AVIMConversation conversation : conversations) {
            conversationList.add(conversation.getConversationId());
            storage = conversation.storage;
        }
        if (storage != null) {
            storage.insertConversations(conversations);
        }
        AVCacheManager.sharedInstance().save(queryParamsStr, JSON.toJSONString(conversationList), null);
    }

    private List<AVIMConversation> parseQueryResult(JSONArray content) {
        LinkedList<AVIMConversation> conversations = new LinkedList<AVIMConversation>();
        for (int i = 0; i < content.size(); ++i) {
            AVIMConversation convResult;
            JSONObject jsonObject = content.getJSONObject(i);
            AVIMConversation allNewConversation = AVIMConversation.parseFromJson(this.client, jsonObject);
            if (null == allNewConversation || null == (convResult = this.client.mergeConversationCache(allNewConversation, false, jsonObject))) continue;
            conversations.add(convResult);
        }
        return conversations;
    }

    public void setQueryPolicy(AVQuery.CachePolicy policy) {
        this.policy = policy;
    }

    public static AVIMConversationQuery or(List<AVIMConversationQuery> queries) {
        if (queries.size() <= 1) {
            throw new IllegalArgumentException("Queries length should be l");
        }
        AVIMClient client = queries.get((int)0).client;
        AVIMConversationQuery result = new AVIMConversationQuery(client);
        if (queries.size() > 1) {
            for (AVIMConversationQuery query : queries) {
                if (!client.clientId.equals(query.client.getClientId())) {
                    throw new IllegalArgumentException("All queries must be for the same client");
                }
                result.conditions.addOrItems(new QueryOperation("$or", "$or", (Object)query.conditions.compileWhereOperationMap()));
            }
        } else {
            result.conditions.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public void setCacheMaxAge(long maxAgeInSecond) {
        this.maxAge = maxAgeInSecond * 1000L;
    }

    public long getCacheMaxAge() {
        return this.maxAge / 1000L;
    }

    static class CacheConversationQueryCallback
    extends GenericObjectCallback {
        AVIMConversationQueryCallback callback;
        AVIMClient client;

        public CacheConversationQueryCallback(AVIMClient client, AVIMConversationQuery query, AVIMConversationQueryCallback callback) {
            this.callback = callback;
            this.client = client;
        }

        public void onSuccess(String content, AVException e) {
            if (!AVUtils.isBlankString((String)content)) {
                try {
                    List conversationList = (List)JSON.parseObject((String)content, List.class);
                    List<AVIMConversation> conversations = this.client.storage.getCachedConversations(conversationList);
                    if (conversations == null || conversations.size() < conversationList.size()) {
                        this.onFailure(AVErrorUtils.createException((int)120, (String)"Cache Missing"), null);
                        return;
                    }
                    this.callback.internalDone(conversations, null);
                }
                catch (Exception e1) {
                    this.callback.internalDone(null, new AVException((Throwable)e1));
                }
            } else {
                this.callback.internalDone(new LinkedList(), null);
            }
        }

        public void onFailure(Throwable error, String content) {
            this.callback.internalDone(null, new AVException(error));
        }
    }
}

